/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.survey;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.dao.LearningSessionDAO;
import com.webmcq.ld.controller.dao.LearningSessionNotFoundException;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.survey.ISurveyService;
import com.webmcq.ld.tool.survey.SurveyDAO;
import com.webmcq.ld.tool.survey.entity.SurCandidateAnswerVO;
import com.webmcq.ld.tool.survey.entity.SurQuestionUsersVO;
import com.webmcq.ld.tool.survey.entity.SurQuestionVO;
import com.webmcq.ld.tool.survey.entity.SurSurveyVO;
import com.webmcq.ld.tool.survey.entity.SurUserResponseVO;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.util.exception.DataAccessException;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import org.apache.log4j.Logger;

public class SurveyServicePOJO
implements ISurveyService {
    private SurveyDAO surveyDAO;
    private LearningSessionDAO lsDAO;
    private boolean isLongSession = false;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$survey$SurveyServicePOJO == null ? (class$com$webmcq$ld$tool$survey$SurveyServicePOJO = SurveyServicePOJO.class$("com.webmcq.ld.tool.survey.SurveyServicePOJO")) : class$com$webmcq$ld$tool$survey$SurveyServicePOJO));
    private static final int NOT_SHOWN_CANDIDATE_ANSWER_ORDER = -1;
    static /* synthetic */ Class class$com$webmcq$ld$tool$survey$SurveyServicePOJO;

    public SurveyServicePOJO() {
        this.surveyDAO = new SurveyDAO();
        this.lsDAO = new LearningSessionDAO();
    }

    public SurveyServicePOJO(Session sess) {
        this.surveyDAO = new SurveyDAO(new PersistenceSession(sess));
        this.lsDAO = new LearningSessionDAO(new PersistenceSession(sess));
        this.isLongSession = true;
    }

    public int getSurveyClassSize(long orgId, String username) {
        try {
            long userId = UserServiceDelegate.findUserId(username);
            OrganisationCompleteData orgData = UserServiceDelegate.findOrganisation(orgId, userId);
            if (orgData == null) {
                throw new SystemException("Fail to get organization informationthat is running current survey");
            }
            return orgData.getUsers().size();
        }
        catch (UserManagementException e) {
            throw new SystemException("Fail to get organization informationthat is running current survey", e);
        }
        catch (UserNotFoundException e) {
            throw new SystemException("Fail to get user id informationin getSurveyClassSize", e);
        }
    }

    public SurSurveyVO retrieveSurvey(long taskinstanceId) {
        try {
            this.surveyDAO.initializePersistenceSession(this.isLongSession);
            SurSurveyVO surSurveyVO = this.surveyDAO.getSurveyByTaskInstance(taskinstanceId);
            return surSurveyVO;
        }
        catch (DataAccessException e) {
            throw new SystemException("Exception occured when lams is loading survey: " + e.getMessage(), e);
        }
        finally {
            this.surveyDAO.finalizeSession(this.isLongSession);
        }
    }

    public int countTotalNumberOfUserResponsed(SurSurveyVO survey) {
        try {
            this.surveyDAO.initializePersistenceSession(this.isLongSession);
            int n = this.surveyDAO.countUserResponsed(survey);
            return n;
        }
        catch (DataAccessException e) {
            throw new SystemException("Exception occured when lams is counting total number of user responsed: " + e.getMessage(), e);
        }
        finally {
            this.surveyDAO.finalizeSession(this.isLongSession);
        }
    }

    public DisplayTaskData completeSession(long userId, long taskInstanceId) {
        DisplayTaskData displayTaskData = null;
        try {
            displayTaskData = LearnerServiceDelegate.moveToNextTask(taskInstanceId, userId);
        }
        catch (TaskInstanceNotFoundException e) {
            throw new SystemException("Exception occured in completeSession ofsurvey tool. TaskInstanceNotFoundException is reported by controller: " + e.getMessage(), e);
        }
        catch (ControllerException e) {
            throw new SystemException("Exception occured in completeSession ofsurvey tool. ControllerException is reported by controller: " + e.getMessage(), e);
        }
        return displayTaskData;
    }

    public UserData getCurrentUserData(String username) {
        try {
            return UserServiceDelegate.findCompleteUser(username);
        }
        catch (UserNotFoundException e) {
            throw new SystemException("Unable to find current user information Root Cause: [" + e.getMessage() + "]", e);
        }
    }

    public LearningSession getCurrentLearningSession(long lsessionId) {
        try {
            this.lsDAO.initializePersistenceSession(this.isLongSession);
            LearningSession learningSession = this.lsDAO.find(lsessionId);
            return learningSession;
        }
        catch (DataAccessException e) {
            throw new SystemException("Exception occured when lams is loading learning session:" + e.getMessage(), e);
        }
        catch (LearningSessionNotFoundException e) {
            throw new SystemException("Fail to find learning session in the database: " + e.getMessage(), e);
        }
        finally {
            this.lsDAO.finalizeSession(this.isLongSession);
        }
    }

    public void saveUserResponses(List responses, long taskinstanceId, UserData user) {
        Transaction tx = null;
        try {
            long userId = UserServiceDelegate.findUserId(user.getLogin());
            this.surveyDAO.initializePersistenceSession(this.isLongSession);
            tx = this.surveyDAO.startTransaction();
            SurSurveyVO survey = this.surveyDAO.getSurveyByTaskInstance(taskinstanceId);
            Iterator i = survey.getSurQuestions().iterator();
            while (i.hasNext()) {
                SurQuestionVO q = (SurQuestionVO)i.next();
                this.removeQuestionUser(q, userId, responses);
                SurQuestionUsersVO qUser = null;
                Iterator j = q.getQuestionUsers().iterator();
                while (j.hasNext()) {
                    SurQuestionUsersVO curUser = (SurQuestionUsersVO)j.next();
                    if (curUser.getUserId() != userId) continue;
                    qUser = curUser;
                }
                if (qUser == null) {
                    qUser = new SurQuestionUsersVO(q, user.getLogin(), userId);
                }
                this.updateUserResponses(responses, q, qUser);
            }
            this.surveyDAO.commitTransaction(tx);
        }
        catch (DataAccessException e) {
            this.surveyDAO.rollbackTransaction(tx);
            throw new SystemException("Exception occured when lams is saving user responses: " + e.getMessage(), e);
        }
        catch (UserNotFoundException e) {
            throw new SystemException("UserNotFoundException occured in saveUserResponses of survey tool", e);
        }
        finally {
            this.surveyDAO.finalizeSession(this.isLongSession);
        }
    }

    private void removeQuestionUser(SurQuestionVO q, long userId, List responses) throws DataAccessException {
        if (!q.isResponsesForQuestion(responses)) {
            Iterator i = q.getQuestionUsers().iterator();
            while (i.hasNext()) {
                SurQuestionUsersVO qUser = (SurQuestionUsersVO)i.next();
                if (qUser.getUserId() != userId) continue;
                this.surveyDAO.removeQuestionUser(qUser);
            }
            this.surveyDAO.flush();
        }
    }

    private void updateUserResponses(List responses, SurQuestionVO q, SurQuestionUsersVO qUser) throws DataAccessException {
        qUser.getResponses().clear();
        Iterator i = responses.iterator();
        while (i.hasNext()) {
            SurUserResponseVO res = (SurUserResponseVO)i.next();
            if (!res.getSurveyQuestion().getQuestionId().equals(q.getQuestionId())) continue;
            res.setSurveyQuestion(q);
            res.setQuestionUser(qUser);
            Iterator j = q.getSurCandidateAnswers().iterator();
            while (j.hasNext()) {
                SurCandidateAnswerVO cAnswer = (SurCandidateAnswerVO)j.next();
                if (!cAnswer.getAnswerEntry().equals(res.getAnswer())) continue;
                res.setCandidateAnswer(cAnswer);
                cAnswer.getResponses().add(res);
                this.surveyDAO.saveUserResponse(res);
            }
            if (res.getCandidateAnswer() == null) {
                TreeSet<SurUserResponseVO> resSet = new TreeSet<SurUserResponseVO>();
                resSet.add(res);
                res.setCandidateAnswer(new SurCandidateAnswerVO(res.getAnswer(), -1, q, resSet));
                this.surveyDAO.saveUserResponse(res);
            }
            qUser.getResponses().add(res);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

