/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.survey;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.SurveyContent;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.survey.SurveyDAO;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.exception.DataAccessException;
import com.webmcq.ld.util.exception.SystemException;
import org.apache.log4j.Logger;

public class SurveyServiceBean
extends BaseSessionBean {
    private SurveyDAO surveyDAO;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$survey$SurveyServiceBean == null ? (class$com$webmcq$ld$tool$survey$SurveyServiceBean = SurveyServiceBean.class$("com.webmcq.ld.tool.survey.SurveyServiceBean")) : class$com$webmcq$ld$tool$survey$SurveyServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$survey$SurveyServiceBean;

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            log.debug((Object)("createSession: task_instance : " + taskInstance));
            log.debug((Object)("task_definition: " + task));
            log.debug((Object)("contentId: " + inputContentId));
            log.debug((Object)("group: " + group));
            Content content = null;
            if (inputContentId != null) {
                content = ContentServiceDelegate.getContent(inputContentId);
                log.debug((Object)("content: " + content));
            }
            SurveyDAO surveyDao = new SurveyDAO();
            surveyDao.buildSurveyFromContent(taskInstance, (SurveyContent)content);
            this.notifyReportingActivated(taskInstance.getSid(), taskInstance.getTitle() + " Reporting");
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (DataAccessException e) {
            this.getSessionContext().setRollbackOnly();
            throw new SystemException(e);
        }
    }

    private void notifyReportingActivated(long taskInstanceId, String title) throws SystemException {
        try {
            String toolpath = "/tool/survey/report.do?method=loadMonitorReport&sessionId=" + taskInstanceId + "&mode=checkup";
            StaffMonitorNotifier.notifyControllerOfURL(taskInstanceId, "Survey", title, toolpath);
        }
        catch (ControllerException e) {
            throw new SystemException(e);
        }
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

