/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.simpleassessment;

import com.webmcq.ld.tool.simpleassessment.interfaces.LearnerAttemptLocal;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionInfoData;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionInfoPK;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionLocal;
import com.webmcq.ld.util.BaseEntityBean;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import org.apache.log4j.Logger;

public abstract class QuestionInfoBean
extends BaseEntityBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$simpleassessment$QuestionInfoBean == null ? (class$com$webmcq$ld$tool$simpleassessment$QuestionInfoBean = QuestionInfoBean.class$("com.webmcq.ld.tool.simpleassessment.QuestionInfoBean")) : class$com$webmcq$ld$tool$simpleassessment$QuestionInfoBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$simpleassessment$QuestionInfoBean;

    public abstract int getSid();

    public abstract void setSid(int var1);

    public abstract long getTaskInstanceId();

    public abstract void setTaskInstanceId(long var1);

    public abstract Long getOutputContentId();

    public abstract void setOutputContentId(Long var1);

    public abstract String getTitle();

    public abstract void setTitle(String var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    public abstract String getInstructions();

    public abstract void setInstructions(String var1);

    public abstract Collection getQuestions();

    public abstract void setQuestions(Collection var1);

    public QuestionLocal getQuestion(int sid) {
        Iterator iterator = this.getQuestions().iterator();
        while (iterator.hasNext()) {
            QuestionLocal element = (QuestionLocal)iterator.next();
            if (element.getSid() != sid) continue;
            return element;
        }
        return null;
    }

    public abstract Collection getLearnerAttempts();

    public abstract void setLearnerAttempts(Collection var1);

    public void addLearnerAttempt(LearnerAttemptLocal attempt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addLearnerAttempt: start: total = " + this.getSummaryMark() + " max " + this.getMaxMark() + " min " + this.getMinMark() + " num done " + this.getNumLearnersAnswered() + " top mark users " + this.getMaxMarkUsernames()));
        }
        if (attempt != null) {
            log.debug((Object)("Adding learner attempt " + attempt.getData().toString()));
            boolean isOnlyAttempt = true;
            int currMaxAttemptNo = 0;
            attempt.setIsBestAttempt(false);
            Iterator iter = this.getLearnerAttempts().iterator();
            while (iter.hasNext()) {
                LearnerAttemptLocal existingAttempt = (LearnerAttemptLocal)iter.next();
                if (existingAttempt.getUserId() != attempt.getUserId()) continue;
                isOnlyAttempt = false;
                if (existingAttempt.getIsBestAttempt() && attempt.getMark().compareTo(existingAttempt.getMark()) >= 0) {
                    existingAttempt.setIsBestAttempt(false);
                    attempt.setIsBestAttempt(true);
                }
                currMaxAttemptNo = Math.max(currMaxAttemptNo, existingAttempt.getAttemptCount());
            }
            if (isOnlyAttempt) {
                attempt.setIsBestAttempt(true);
                attempt.setAttemptCount(1);
            } else {
                attempt.setAttemptCount(currMaxAttemptNo + 1);
            }
            this.getLearnerAttempts().add(attempt);
            this.setSummaryDetails();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addLearnerAttempt: end: total = " + this.getSummaryMark() + " max " + this.getMaxMark() + " min " + this.getMinMark() + " num done " + this.getNumLearnersAnswered() + " top mark users " + this.getMaxMarkUsernames()));
        }
    }

    private void setSummaryDetails() {
        int minMark = Integer.MAX_VALUE;
        int maxMark = 0;
        long sumMarks = 0L;
        int numAnswered = 0;
        String topUsers = null;
        Iterator iter = this.getLearnerAttempts().iterator();
        while (iter.hasNext()) {
            LearnerAttemptLocal attempt = (LearnerAttemptLocal)iter.next();
            if (!attempt.getIsBestAttempt()) continue;
            ++numAnswered;
            if (attempt.getMark() == null) continue;
            int newMark = attempt.getMark();
            minMark = Math.min(minMark, newMark);
            sumMarks += (long)newMark;
            if (newMark > maxMark) {
                maxMark = newMark;
                topUsers = this.addUserToTopList(attempt.getUsername(), null);
                continue;
            }
            if (newMark != maxMark) continue;
            topUsers = this.addUserToTopList(attempt.getUsername(), topUsers);
        }
        this.setSummaryMark(sumMarks);
        this.setMaxMark(maxMark);
        this.setMinMark(minMark != Integer.MAX_VALUE ? minMark : 0);
        this.setMaxMarkUsernames(topUsers);
        this.setNumLearnersAnswered(numAnswered);
    }

    private String addUserToTopList(String username, String currentTopList) {
        if (!this.getShowTopUsernames()) {
            return null;
        }
        if (currentTopList == null) {
            return username;
        }
        if (username != null) {
            String addName = ", " + username;
            if (!username.equals(currentTopList) && currentTopList.indexOf(addName) <= -1) {
                return currentTopList + addName;
            }
        }
        return currentTopList;
    }

    public Iterator getLearnerAttemptIterator() {
        return this.getLearnerAttempts().iterator();
    }

    public LearnerAttemptLocal getAttempt(long userId, int attemptNo) {
        Iterator iter = this.getLearnerAttempts().iterator();
        while (iter.hasNext()) {
            LearnerAttemptLocal learnerAttempt = (LearnerAttemptLocal)iter.next();
            if (learnerAttempt.getUserId() != userId || attemptNo != learnerAttempt.getAttemptCount()) continue;
            return learnerAttempt;
        }
        return null;
    }

    public LearnerAttemptLocal getBestAttempt(long userId) {
        LearnerAttemptLocal bestAttempt = null;
        Iterator iter = this.getLearnerAttempts().iterator();
        while (bestAttempt == null && iter.hasNext()) {
            LearnerAttemptLocal learnerAttempt = (LearnerAttemptLocal)iter.next();
            if (learnerAttempt.getUserId() != userId || !learnerAttempt.getIsBestAttempt()) continue;
            bestAttempt = learnerAttempt;
        }
        return bestAttempt;
    }

    public LearnerAttemptLocal getLastAttempt(long userId) {
        LearnerAttemptLocal lastAttempt = null;
        Iterator iter = this.getLearnerAttempts().iterator();
        while (iter.hasNext()) {
            LearnerAttemptLocal learnerAttempt = (LearnerAttemptLocal)iter.next();
            if (learnerAttempt.getUserId() != userId || lastAttempt != null && lastAttempt.getAttemptCount() >= learnerAttempt.getAttemptCount()) continue;
            lastAttempt = learnerAttempt;
        }
        return lastAttempt;
    }

    public abstract Integer getTotalMark();

    public abstract void setTotalMark(Integer var1);

    public abstract boolean getShowFeedback();

    public abstract void setShowFeedback(boolean var1);

    public abstract boolean getAllowRedo();

    public abstract void setAllowRedo(boolean var1);

    public abstract String getTaskDirectory();

    public abstract void setTaskDirectory(String var1);

    public abstract long getSummaryMark();

    public abstract void setSummaryMark(long var1);

    public abstract int getMaxMark();

    public abstract void setMaxMark(int var1);

    public abstract String getMaxMarkUsernames();

    public abstract void setMaxMarkUsernames(String var1);

    public abstract int getMinMark();

    public abstract void setMinMark(int var1);

    public abstract boolean getShowTopUsernames();

    public abstract void setShowTopUsernames(boolean var1);

    public abstract int getMinPassMark();

    public abstract void setMinPassMark(int var1);

    public void setTotalMinPassMarks(int totalMarks, int minimumPassMark) {
        this.setTotalMark(new Integer(totalMarks));
        this.setMinPassMark(minimumPassMark <= totalMarks ? minimumPassMark : totalMarks);
    }

    public int getAverageMark() {
        if (this.getNumLearnersAnswered() == 0) {
            return 0;
        }
        return (int)this.getSummaryMark() / this.getNumLearnersAnswered();
    }

    public abstract int getNumLearnersAnswered();

    public abstract void setNumLearnersAnswered(int var1);

    public QuestionInfoPK ejbCreate() throws CreateException {
        this.setSid(this.nextId());
        this.setSummaryMark(0L);
        this.setMaxMark(-1);
        this.setMinMark(-1);
        this.setNumLearnersAnswered(0);
        this.setMinPassMark(0);
        return null;
    }

    public void ejbPostCreate() {
    }

    public abstract QuestionInfoData getData();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

