/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.qna.dto;

import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.qna.dto.QuestionAnswerData;
import com.webmcq.ld.tool.qna.interfaces.SimpleAnswerLocal;
import com.webmcq.ld.tool.qna.interfaces.SimpleQuestionLocal;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class QNADTOFactory {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$qna$dto$QNADTOFactory == null ? (class$com$webmcq$ld$tool$qna$dto$QNADTOFactory = QNADTOFactory.class$("com.webmcq.ld.tool.qna.dto.QNADTOFactory")) : class$com$webmcq$ld$tool$qna$dto$QNADTOFactory));
    static /* synthetic */ Class class$com$webmcq$ld$tool$qna$dto$QNADTOFactory;

    public static QuestionAnswerData getAllQAData(SimpleQuestionLocal question, Collection answers) {
        QuestionAnswerData data = new QuestionAnswerData();
        if (question != null) {
            data.setContent(question.getContent());
            data.setSessionId(question.getSessionId());
            data.setSid(question.getSid());
            data.setTitle(question.getTitle());
            data.setDefineLater(question.getDefineLater());
        }
        TreeMap<String, String> answerData = new TreeMap<String, String>();
        if (answers != null) {
            Iterator iter = answers.iterator();
            while (iter.hasNext()) {
                SimpleAnswerLocal element = (SimpleAnswerLocal)iter.next();
                String username = QNADTOFactory.getUsername(element.getUserId());
                if (username == null) {
                    log.error((Object)("QuestionAnswerData: Answer found for user " + element.getUserId() + " but no matching user exists. Answer skipped"));
                    continue;
                }
                answerData.put(username, element.getContent());
            }
        }
        data.setAnswers(answerData);
        return data;
    }

    public static QuestionAnswerData getSingleQAData(long userId, String username, SimpleQuestionLocal question, SimpleAnswerLocal answer) {
        QuestionAnswerData data = new QuestionAnswerData();
        if (question != null) {
            data.setContent(question.getContent());
            data.setSessionId(question.getSessionId());
            data.setSid(question.getSid());
            data.setTitle(question.getTitle());
            data.setDefineLater(question.getDefineLater());
        }
        TreeMap<String, String> answerData = new TreeMap<String, String>();
        if (answer != null) {
            String username2 = username;
            if (username2 == null) {
                username2 = QNADTOFactory.getUsername(userId);
            }
            answerData.put(username2 != null ? username2 : "unknown", answer.getContent());
        }
        data.setAnswers(answerData);
        return data;
    }

    public static QuestionAnswerData[] createDummyQAData() {
        QuestionAnswerData data = new QuestionAnswerData();
        data.setContent("Data missing");
        data.setSessionId(-1L);
        data.setSid(-1);
        data.setTitle("Data missing");
        data.setDefineLater(new Boolean(true));
        data.setAnswers(new TreeMap());
        QuestionAnswerData[] datas = new QuestionAnswerData[]{data};
        return datas;
    }

    private static String getUsername(long userId) {
        ShwaaUserData user = null;
        try {
            user = UserServiceDelegate.find(userId);
            return user.getLogin();
        }
        catch (UserNotFoundException userNotFoundException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

