/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.mb;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.MBAuthoringContent;
import com.webmcq.ld.content.MBAuthoringContentTopic;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.mb.MBException;
import com.webmcq.ld.tool.mb.MBForumVO;
import com.webmcq.ld.tool.mb.MBMessageVO;
import com.webmcq.ld.tool.mb.MBServiceDAO;
import com.webmcq.ld.tool.mb.MBThreadVO;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.ParsingUtil;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import javax.ejb.EJBException;
import org.apache.log4j.Logger;

public abstract class MBServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$mb$MBServiceBean == null ? (class$com$webmcq$ld$tool$mb$MBServiceBean = MBServiceBean.class$("com.webmcq.ld.tool.mb.MBServiceBean")) : class$com$webmcq$ld$tool$mb$MBServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$mb$MBServiceBean;

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            log.debug((Object)("createSession: task_instance : " + taskInstance));
            log.debug((Object)("task_definition: " + task));
            log.debug((Object)("contentId: " + inputContentId));
            log.debug((Object)("group: " + group));
            Content content = null;
            if (inputContentId != null) {
                content = ContentServiceDelegate.getContent(inputContentId);
                log.debug((Object)("content: " + content));
            }
            this.createSession((SimpleTaskVO)task, taskInstance, group, content);
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            throw new SystemException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSession(SimpleTaskVO taskVO, TaskInstanceData instance, GroupData groupData, Content content) throws EJBException {
        MBServiceDAO mbServiceDAO = null;
        try {
            try {
                log.debug((Object)"createSession");
                if (content.theContentType() != "MBAuthoring") {
                    log.error((Object)"incompatible content type");
                    throw new EJBException("incompatible content type");
                }
                MBAuthoringContent mbContent = (MBAuthoringContent)content;
                log.debug((Object)("MBAuthoringContent = " + mbContent));
                long sessionId = instance.getSid();
                mbServiceDAO = new MBServiceDAO(new PersistenceSession());
                MBForumVO forum = mbServiceDAO.getForumData(sessionId);
                if (forum == null) {
                    forum = new MBForumVO();
                    forum.setTitle(content.getTitle());
                    forum.setDescription(content.getBody());
                    forum.setSessionId(new Long(sessionId));
                    forum.setTerminationTypes(mbContent.getTerminationType());
                    forum.setTerminationValue(String.valueOf(mbContent.getDurationInDays()));
                    forum.setIsPostingNotified(ParsingUtil.booleanToInteger(mbContent.isPostingNotified()));
                    forum.setIsPostingModerated(ParsingUtil.booleanToInteger(mbContent.isPostingModerated()));
                    forum.setIsNewTopicAllowed(ParsingUtil.booleanToInteger(mbContent.isNewTopicAllowed()));
                    forum.setIsReusable(ParsingUtil.booleanToInteger(mbContent.isReusable()));
                    forum.setDateCreated(new Date());
                    mbServiceDAO.addForum(forum);
                    log.debug((Object)("forum created: " + forum));
                    TreeSet authoringThreads = new TreeSet(mbContent.getTopics());
                    if (authoringThreads == null) {
                        log.error((Object)"authoringTopics is null");
                        throw new EJBException("authoringTopics is null");
                    }
                    Iterator i = authoringThreads.iterator();
                    while (i.hasNext()) {
                        MBAuthoringContentTopic authoringThread = (MBAuthoringContentTopic)i.next();
                        log.debug((Object)("   retrieved MBAuthoringContentTopic = " + authoringThread));
                        MBThreadVO thread = new MBThreadVO();
                        thread.setForumId(forum.getSid());
                        thread.setSubject(authoringThread.getTopicTitle());
                        thread.setAuthorId(new Long(0L));
                        thread.setAuthorName("Teacher");
                        thread.setDateCreated(new Date());
                        thread.setDateLastPosted(new Date());
                        mbServiceDAO.addThread(thread);
                        MBMessageVO starterMessage = new MBMessageVO();
                        starterMessage.setThreadId(thread.getSid());
                        starterMessage.setAuthorId(new Long(0L));
                        starterMessage.setAuthorName("Teacher");
                        starterMessage.setBodyText(authoringThread.getMessage());
                        starterMessage.setSubject(authoringThread.getTopicTitle());
                        starterMessage.setPostDate(new Date());
                        mbServiceDAO.addMessage(starterMessage);
                        thread.setNumOfMessages(new Integer(1));
                        thread.setStarterMessage(starterMessage.getSid());
                        mbServiceDAO.updateThread(thread);
                    }
                    log.debug((Object)("forum was set with content: " + content));
                } else {
                    log.debug((Object)("forum was found " + forum));
                }
                log.debug((Object)"exiting");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EJBException(e);
            }
            Object var16_15 = null;
            if (mbServiceDAO == null) return;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (mbServiceDAO == null) throw throwable;
            try {
                mbServiceDAO.disconnect();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        mbServiceDAO.disconnect();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DisplayTaskData completeSession(long userId, long sessionId) throws MBException, EJBException {
        DisplayTaskData displayTaskData;
        MBServiceDAO mbServiceDAO = null;
        try {
            try {
                DisplayTaskData displayTaskData2 = null;
                mbServiceDAO = new MBServiceDAO(new PersistenceSession());
                MBForumVO forum = mbServiceDAO.getForumData(sessionId);
                if (forum == null) {
                    throw new MBException("no forum found with session id: " + sessionId);
                }
                displayTaskData = displayTaskData2 = LearnerServiceDelegate.moveToNextTask(sessionId, userId);
                Object var10_10 = null;
                if (mbServiceDAO == null) return displayTaskData;
            }
            catch (MBException e) {
                e.printStackTrace();
                throw e;
            }
            catch (SystemException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EJBException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (mbServiceDAO == null) throw throwable;
            try {
                mbServiceDAO.disconnect();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return displayTaskData;
        }
        mbServiceDAO.disconnect();
        return displayTaskData;
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

