/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.filemanager.web;

import com.webmcq.ld.tool.filemanager.FileManagerDelegate;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.util.UploadFileUtil;
import com.webmcq.ld.util.WebUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class FileManagerAction
extends DispatchAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$filemanager$web$FileManagerAction == null ? (class$com$webmcq$ld$tool$filemanager$web$FileManagerAction = FileManagerAction.class$("com.webmcq.ld.tool.filemanager.web.FileManagerAction")) : class$com$webmcq$ld$tool$filemanager$web$FileManagerAction));
    public static final String ACTION_NAME = "filemanager";
    public static final String TOOL_PATH = "tool/filemanager/";
    public static final String JSP_PREVIEW_TAG = "preview";
    public static final String JSP_ISWEB_TAG = "webpage";
    public static final String JSP_ISRESOURCE_TAG = "resource";
    private static final String JSP_IMPORT_TYPE_TAG = "import";
    private static final String JSP_EXPORT_TYPE_TAG = "export";
    public static String JSP_SUBMIT_BUTTON_FILE_UPLOAD = "Upload";
    public static String JSP_SUBMIT_BUTTON_VIEW = "View";
    public static String JSP_SUBMIT_NEWTITLE = "newTitle";
    public static String JSP_SUBMIT_NEWURLINSTRUCTION = "newUrlInstruction";
    public static String JSP_SUBMIT_FILE = "file";
    public static String JSP_MAX_FILESIZE_TAG = "maxfilesize";
    public static final String JSP_FILENAME_DOWNLOAD_TAG = "filename";
    public static final String JSP_FILETITLE_DOWNLOAD_TAG = "filetitle";
    public static final String JSP_FILEINSTRUCTION_DOWNLOAD_TAG = "fileinstruction";
    public static final String JSP_DIRECTORY_NAME_TAG = "directoryName";
    public static final String JSP_PREFER_DOWNLOAD_TAG = "preferDownload";
    public static final String JSP_ERROR_TAG = "error";
    public static final String JSP_MESSAGE_TAG = "message";
    private static final String JSP_ACCEPT_MIME_TAG = "accept";
    private static final String JSP_ACCEPT_EXTS_TAG = "extensions";
    private static final String JSP_LDID_TAG = "filename";
    private static String URL_ENCODING = "UTF-8";
    private static final boolean IS_RESOURCE = true;
    private static final boolean IS_NOT_RESOURCE = false;
    private static final boolean EXTRACT_WEB_CONTENT = true;
    private static final boolean DONT_EXTRACT_WEB_CONTENT = false;
    private static final String FORWARD_UPLOAD = "upload";
    private static final String FORWARD_DOWNLOAD = "download";
    private static final String FORWARD_DONE = "done";
    private static final String IMPORT_FILE_MIME_TYPES = "application/x-lams";
    private static final String IMPORT_FILE_EXTENSIONS = "las";
    private static final String IMPORT_FILE_EXTENSIONS_ADMIN = "las,lal";
    private static final String JSP_CALLING_METHOD_TAG = "callingMethod";
    private static final String ACTION_UPLOAD_WEBPAGE_ZIP = "uploadWebPageZip";
    private static final String ACTION_IMPORT_DESIGN = "importDesign";
    private static final String ACTION_UPLOAD_FILE = "uploadFile";
    private static final String ACTION_UPLOAD_RESOURCE = "uploadResource";
    static /* synthetic */ Class class$com$webmcq$ld$tool$filemanager$web$FileManagerAction;

    public static String getDownloadPath(String filepath, boolean preferDownload) throws UnsupportedEncodingException {
        return "tool/filemanager/filemanager.do?method=getDownloadPage&preferDownload=" + Boolean.toString(preferDownload) + "&" + "filename" + "=" + URLEncoder.encode(filepath, URL_ENCODING);
    }

    public static String getUploadPath() throws UnsupportedEncodingException {
        return "tool/filemanager/filemanager.do?method=uploadPage";
    }

    public static String getImportPath() throws UnsupportedEncodingException {
        return "tool/filemanager/filemanager.do?method=dispatch&import=las";
    }

    public static String getExportPath(String ldId) throws UnsupportedEncodingException {
        return "tool/filemanager/filemanager.do?method=getDownloadPage&export=las&preferDownload=true&filename=" + URLEncoder.encode(ldId, URL_ENCODING);
    }

    public ActionForward getDirectoryName(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException, Throwable {
        if (!req.isUserInRole(UserRole.AUTHOR.getName())) {
            log.error((Object)"retrieveDirectoryName: Request to retrieveDirectoryName but user not authorised (must have Authoring role)");
            req.setAttribute(JSP_ERROR_TAG, (Object)"You need to be set up as an author to retrieve a directory name");
        }
        String dirName = FileManagerDelegate.getDirectoryName();
        log.debug((Object)("directoryName : " + dirName));
        res.getWriter().print("directoryName=" + dirName);
        return null;
    }

    public ActionForward dispatch(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (!req.isUserInRole(UserRole.AUTHOR.getName())) {
            log.error((Object)"dispatch: Request to upload/preview a file but user not authorised (must have Authoring role)");
            req.setAttribute(JSP_ERROR_TAG, (Object)"You need to be set up as an author to upload/preview a file");
            return mapping.findForward(FORWARD_DONE);
        }
        String uri = req.getParameter(JSP_PREVIEW_TAG);
        String webpage = req.getParameter(JSP_ISWEB_TAG);
        String importParam = req.getParameter(JSP_IMPORT_TYPE_TAG);
        String exportParam = req.getParameter(JSP_EXPORT_TYPE_TAG);
        String resource = req.getParameter(JSP_ISRESOURCE_TAG);
        String directoryName = req.getParameter(JSP_DIRECTORY_NAME_TAG);
        if (uri != null) {
            String url = FileManagerDelegate.getAccessUrl(uri, res, req, true);
            log.debug((Object)("dispatch: url is " + url));
            res.sendRedirect(url);
            return null;
        }
        if (importParam != null) {
            String message = null;
            String errorMessage = null;
            String fileExtension = importParam.trim();
            return this.returnImport(mapping, req, fileExtension, message, errorMessage);
        }
        if (exportParam != null) {
            String message = null;
            String errorMessage = null;
            String fileExtension = exportParam.trim();
            String ldidParam = req.getParameter("filename");
            return this.returnExport(mapping, req, ldidParam, fileExtension, message, errorMessage);
        }
        req.setAttribute(JSP_ISRESOURCE_TAG, (Object)resource);
        req.setAttribute(JSP_DIRECTORY_NAME_TAG, (Object)directoryName);
        return this.returnUpload(mapping, req, null, webpage != null);
    }

    private ActionForward returnImport(ActionMapping mapping, HttpServletRequest req, String fileExtension, String message, String errorMessage) {
        String fileExtensions = req.isUserInRole(UserRole.ADMINISTRATOR.getName()) ? IMPORT_FILE_EXTENSIONS_ADMIN : IMPORT_FILE_EXTENSIONS;
        if (fileExtensions.indexOf(fileExtension) == -1) {
            errorMessage = "Does not import this file (MIME) type";
            log.error((Object)errorMessage);
            req.setAttribute(JSP_ERROR_TAG, (Object)errorMessage);
            return mapping.findForward(FORWARD_DONE);
        }
        req.setAttribute(JSP_IMPORT_TYPE_TAG, (Object)fileExtension);
        req.setAttribute(JSP_ACCEPT_MIME_TAG, (Object)IMPORT_FILE_MIME_TYPES);
        req.setAttribute(JSP_ACCEPT_EXTS_TAG, (Object)fileExtensions);
        req.setAttribute(JSP_ERROR_TAG, (Object)errorMessage);
        req.setAttribute(JSP_MESSAGE_TAG, (Object)message);
        return mapping.findForward(FORWARD_UPLOAD);
    }

    private ActionForward returnExport(ActionMapping mapping, HttpServletRequest req, String ldId, String fileExtension, String message, String errorMessage) {
        String fileExtensions = req.isUserInRole(UserRole.ADMINISTRATOR.getName()) ? IMPORT_FILE_EXTENSIONS_ADMIN : IMPORT_FILE_EXTENSIONS;
        if (fileExtensions.indexOf(fileExtension) == -1) {
            errorMessage = "Does not export this file (MIME) type";
            log.error((Object)errorMessage);
            req.setAttribute(JSP_ERROR_TAG, (Object)errorMessage);
            return mapping.findForward(FORWARD_DONE);
        }
        req.setAttribute("filename", (Object)ldId);
        req.setAttribute(JSP_EXPORT_TYPE_TAG, (Object)fileExtension);
        req.setAttribute(JSP_ERROR_TAG, (Object)errorMessage);
        req.setAttribute(JSP_MESSAGE_TAG, (Object)message);
        return mapping.findForward(FORWARD_DOWNLOAD);
    }

    private ActionForward returnUpload(ActionMapping mapping, HttpServletRequest req, String error, boolean extractWebContent) {
        req.setAttribute(JSP_MAX_FILESIZE_TAG, (Object)Float.toString(UploadFileUtil.getMaxLargeFileSize()));
        if (error != null) {
            req.setAttribute(JSP_ERROR_TAG, (Object)error);
        }
        if (extractWebContent) {
            req.setAttribute(JSP_ISWEB_TAG, (Object)"true");
        }
        return mapping.findForward(FORWARD_UPLOAD);
    }

    public ActionForward uploadResource(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setAttribute(JSP_CALLING_METHOD_TAG, (Object)ACTION_UPLOAD_RESOURCE);
        return this.upload(mapping, form, req, res, false, true);
    }

    public ActionForward uploadFile(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setAttribute(JSP_CALLING_METHOD_TAG, (Object)ACTION_UPLOAD_FILE);
        return this.upload(mapping, form, req, res, false, false);
    }

    public ActionForward uploadWebPageZip(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setAttribute(JSP_CALLING_METHOD_TAG, (Object)ACTION_UPLOAD_WEBPAGE_ZIP);
        return this.upload(mapping, form, req, res, true, false);
    }

    private ActionForward upload(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res, boolean extractWebContent, boolean isResource) throws IOException, ServletException {
        String error = null;
        try {
            log.debug((Object)FORWARD_UPLOAD);
            String username = WebUtil.getUsername(req);
            String submittedUrlInstruction = null;
            String submittedTitle = null;
            FileItem fileToUpload = null;
            String originalFilename = null;
            String directoryName = null;
            if (!req.isUserInRole(UserRole.AUTHOR.getName())) {
                log.error((Object)("upload: Request to upload a file but user " + username + " not entitled to upload a file (must have Authoring role)"));
                error = "You need to be set up as an author to upload a file";
            } else {
                List items = null;
                try {
                    items = UploadFileUtil.getUploadItems(req, true);
                    Iterator iter = items.iterator();
                    while (iter.hasNext()) {
                        FileItem item = (FileItem)iter.next();
                        log.debug((Object)("Processing item " + item.getFieldName()));
                        if (JSP_SUBMIT_NEWURLINSTRUCTION.equals(item.getFieldName())) {
                            submittedUrlInstruction = item.getString();
                            continue;
                        }
                        if (JSP_SUBMIT_NEWTITLE.equals(item.getFieldName())) {
                            submittedTitle = item.getString();
                            continue;
                        }
                        if (JSP_DIRECTORY_NAME_TAG.equals(item.getFieldName())) {
                            directoryName = item.getString();
                            continue;
                        }
                        if (!JSP_SUBMIT_FILE.equals(item.getFieldName()) || item.getName() == null || item.getSize() == 0L) continue;
                        originalFilename = item.getName();
                        fileToUpload = item;
                    }
                }
                catch (FileUploadException fue) {
                    log.error((Object)"Unable to upload file. Exception occured", (Throwable)fue);
                    error = "Unable to upload file. Error returned by uploader was:" + fue.getMessage();
                }
            }
            if (error == null) {
                log.debug((Object)("Expected webpage " + extractWebContent));
                Integer taskInstanceId = null;
                boolean preferDownload = true;
                boolean allowExecutables = false;
                String lamsUri = isResource ? FileManagerDelegate.uploadResource(fileToUpload, originalFilename, directoryName, taskInstanceId, allowExecutables) : FileManagerDelegate.uploadFile(fileToUpload, originalFilename, taskInstanceId, preferDownload, extractWebContent, allowExecutables);
                req.setAttribute("filename", (Object)lamsUri);
                req.setAttribute(JSP_FILETITLE_DOWNLOAD_TAG, (Object)submittedTitle);
                req.setAttribute(JSP_FILEINSTRUCTION_DOWNLOAD_TAG, (Object)submittedUrlInstruction);
                return mapping.findForward(FORWARD_DONE);
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error occured", e);
            error = e.getMessage();
        }
        return this.returnUpload(mapping, req, error, extractWebContent);
    }

    public ActionForward importDesign(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String message = null;
        String errorMessage = null;
        String fileExtension = null;
        try {
            log.debug((Object)ACTION_IMPORT_DESIGN);
            String username = WebUtil.getUsername(req);
            log.debug((Object)"  username");
            if (!req.isUserInRole(UserRole.AUTHOR.getName())) {
                log.error((Object)("user " + username + " must in an Authoring role"));
                throw new IllegalAccessException("You need to be set up as an author to upload a file");
            }
            log.debug((Object)"  iterating through multipart");
            String submittedTitle = null;
            FileItem fileToUpload = null;
            String originalFilename = null;
            List items = UploadFileUtil.getUploadItems(req, true);
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                log.debug((Object)"  Next item");
                FileItem item = (FileItem)iter.next();
                log.debug((Object)("    item = " + item));
                String fieldName = item.getFieldName();
                log.debug((Object)("    fieldName = " + fieldName));
                if (JSP_SUBMIT_NEWTITLE.equals(fieldName)) {
                    submittedTitle = item.getString();
                    log.debug((Object)("      submittedTitle = " + submittedTitle));
                    continue;
                }
                if (JSP_SUBMIT_FILE.equals(fieldName) && item.getName() != null && item.getSize() != 0L) {
                    originalFilename = item.getName();
                    log.debug((Object)("      originalFilename = " + originalFilename));
                    fileToUpload = item;
                    log.debug((Object)("      fileToUpload = " + fileToUpload));
                    continue;
                }
                if (!JSP_IMPORT_TYPE_TAG.equals(fieldName)) continue;
                fileExtension = item.getString();
                log.debug((Object)("      fileExtension = " + fileExtension));
            }
            log.debug((Object)"   calling FileManagerDelegate");
            Long ldId = FileManagerDelegate.importDesign(username, fileToUpload, originalFilename, submittedTitle, fileExtension);
            log.debug((Object)(" got ldId: " + ldId));
            req.setAttribute("filename", (Object)ldId);
            ActionForward destination = mapping.findForward(FORWARD_DONE);
            log.debug((Object)("forwarding to" + destination));
            req.setAttribute(JSP_CALLING_METHOD_TAG, (Object)ACTION_IMPORT_DESIGN);
            return destination;
        }
        catch (Throwable e) {
            log.debug((Object)"Error occured", e);
            errorMessage = e.getMessage();
            message = null;
            req.setAttribute(JSP_CALLING_METHOD_TAG, (Object)ACTION_IMPORT_DESIGN);
            return this.returnImport(mapping, req, fileExtension, message, errorMessage);
        }
    }

    public ActionForward getDownloadPage(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            req.setAttribute("filename", (Object)req.getParameter("filename"));
            req.setAttribute(JSP_PREFER_DOWNLOAD_TAG, (Object)req.getParameter(JSP_PREFER_DOWNLOAD_TAG));
            req.setAttribute(JSP_EXPORT_TYPE_TAG, (Object)req.getParameter(JSP_EXPORT_TYPE_TAG));
            return mapping.findForward(FORWARD_DOWNLOAD);
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            req.setAttribute(JSP_ERROR_TAG, (Object)e.getMessage());
            return mapping.findForward(FORWARD_DONE);
        }
    }

    public ActionForward getFile(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        log.debug((Object)"getFile without filename");
        String filename = req.getParameter("filename");
        log.debug((Object)("filename:" + filename));
        if (filename == null) {
            req.setAttribute(JSP_ERROR_TAG, (Object)"No filename given. Unable to download file.");
            return mapping.findForward(JSP_ERROR_TAG);
        }
        return this.getFile(mapping, form, req, res, filename);
    }

    private ActionForward getFile(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res, String filename) throws IOException, ServletException {
        try {
            String username = WebUtil.getUsername(req);
            String preferDownloadString = req.getParameter(JSP_PREFER_DOWNLOAD_TAG);
            String exportType = req.getParameter(JSP_EXPORT_TYPE_TAG);
            boolean preferDownload = true;
            if (preferDownloadString != null) {
                preferDownload = Boolean.valueOf(preferDownloadString);
            }
            try {
                if (exportType == null) {
                    FileManagerDelegate.sendFile(filename, res, this.getServlet().getServletContext(), preferDownload);
                } else {
                    String ldId = filename;
                    FileManagerDelegate.sendDesign(username, ldId, res, this.getServlet().getServletContext(), exportType);
                }
            }
            catch (IOException e) {
                log.debug((Object)("Exception in getFile(): " + e.getMessage()));
                req.setAttribute(JSP_ERROR_TAG, (Object)" Requested file was not found..Please contact your Administrator ");
                return mapping.findForward(FORWARD_DONE);
            }
            return null;
        }
        catch (Exception e) {
            log.debug((Object)("General exception thrown: " + e.getMessage()));
            req.setAttribute(JSP_ERROR_TAG, (Object)e.getMessage());
            return mapping.findForward(FORWARD_DONE);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

