/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.filemanager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtil {
    private final String PATH_SEPARATOR = "/";
    private ZipFile m_zip;

    public ZipUtil(String filename) throws IOException {
        File file = new File(filename);
        this.m_zip = new ZipFile(file);
    }

    public ZipUtil(File file) throws IOException {
        this.m_zip = new ZipFile(file);
    }

    public void unzip(String dir) throws IOException {
        Enumeration<? extends ZipEntry> entries = this.m_zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            this.createDir(entry.getName(), dir);
            this.unzipFile(this.m_zip, entry, dir);
        }
    }

    public void close() {
        try {
            this.m_zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createDir(String filepath, String dir) {
        int ix = filepath.lastIndexOf("/");
        if (ix == -1) {
            return;
        }
        String dirPortion = filepath.substring(0, ix);
        File newDir = new File(dir + File.separator + dirPortion);
        newDir.mkdirs();
    }

    private void unzipFile(ZipFile zip, ZipEntry entry, String dir) throws IOException {
        int bytesRead;
        BufferedInputStream bis = new BufferedInputStream(zip.getInputStream(entry));
        File newFile = new File(dir + File.separator + entry.getName());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile));
        byte[] buffer = new byte[1024];
        while ((bytesRead = bis.read(buffer)) != -1) {
            bos.write(buffer, 0, bytesRead);
        }
        bis.close();
        bos.close();
    }

    public static void main(String[] args) {
        try {
            ZipUtil zu = new ZipUtil("D:\\tmp\\tmp.zip");
            zu.unzip("D:\\tmp\\extract");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

