/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.filemanager;

import com.allaire.wddx.WddxDeserializationException;
import com.webmcq.ld.NewVersion;
import com.webmcq.ld.UnsupportedVersionException;
import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.authoring.interfaces.LDAuthoringServiceLocal;
import com.webmcq.ld.activities.authoring.interfaces.LDAuthoringServiceLocalHome;
import com.webmcq.ld.activities.authoring.interfaces.LDAuthoringServiceUtil;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ConfigurationServiceDelegate;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.filemanager.FileManagerException;
import com.webmcq.ld.tool.filemanager.IllegalFileException;
import com.webmcq.ld.tool.filemanager.ZipUtil;
import com.webmcq.ld.tool.filemanager.web.FileManagerAction;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.DownloadFile;
import com.webmcq.ld.util.EJBHomeFactory;
import com.webmcq.ld.util.WDDXProcessor;
import com.webmcq.ld.util.WDDXProcessorConversionException;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.sequence.interfaces.SequenceGenHome;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.zip.ZipException;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.ejb.CreateException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class FileManagerServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$filemanager$FileManagerServiceBean == null ? (class$com$webmcq$ld$tool$filemanager$FileManagerServiceBean = FileManagerServiceBean.class$("com.webmcq.ld.tool.filemanager.FileManagerServiceBean")) : class$com$webmcq$ld$tool$filemanager$FileManagerServiceBean));
    public static final String URI_SCHEME = "urlcont";
    private static String uploadDir = null;
    public static final String SEQUENCE_NAME = "upload_file_number";
    private static final char URL_SEPARATOR = '/';
    private static final String DEFAULT_DIRECTORY_NAME = "ContentStorage";
    private static final String HTMLNB_DIRECTORY_NAME = "htmlnb";
    private static String[] exeExtensions = null;
    private static final String UTF_8_ENCODING = "UTF-8";
    private static final String ENCODED_KEY_BASE64 = "emEjkQfjGZs=";
    private static final String KEY_IV_BASE64 = "AToFlf/Ue40=";
    private static final String ENC_CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";
    private static Key secretKey = null;
    private static AlgorithmParameterSpec algorithmParameterSpec = null;
    static /* synthetic */ Class class$com$webmcq$ld$tool$filemanager$FileManagerServiceBean;
    static /* synthetic */ Class class$com$webmcq$ld$util$sequence$interfaces$SequenceGenHome;

    public void ejbCreate() throws CreateException {
        try {
            byte[] encodedKey = Base64.decodeBase64((byte[])ENCODED_KEY_BASE64.getBytes());
            byte[] keyIv = Base64.decodeBase64((byte[])KEY_IV_BASE64.getBytes());
            DESKeySpec desKeySpec = new DESKeySpec(encodedKey);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("DES");
            secretKey = factory.generateSecret(desKeySpec);
            algorithmParameterSpec = new IvParameterSpec(keyIv);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new CreateException(e.getMessage());
        }
    }

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) {
        log.error((Object)"Unexpected call to createSession - doesn't know how to behave as a task!");
    }

    public static String getUploadDir() {
        if (uploadDir == null) {
            File dir;
            uploadDir = ConfigurationServiceDelegate.get(ConfigurationKeys.FILEMANAGER_DIRECTORY_NAME);
            if (uploadDir == null) {
                log.error((Object)"Configuration parameter for upload directory name (fileManagerDirectory) is missing, using default");
                uploadDir = DEFAULT_DIRECTORY_NAME;
            }
            if (!(dir = new File(uploadDir)).exists()) {
                dir.mkdir();
            }
        }
        return uploadDir;
    }

    public String getDirectoryName() {
        return String.valueOf(File.separator + HTMLNB_DIRECTORY_NAME + File.separator + this.nextInt());
    }

    private String[] getExeExtensions() {
        if (exeExtensions == null) {
            String extensions = ConfigurationServiceDelegate.get(ConfigurationKeys.FILEMANAGER_EXE_EXTENSIONS);
            if (extensions == null) {
                log.error((Object)"Configuration parameter for executable extensions (fileManagerExecutableExtensions) is missing, using none");
                exeExtensions = new String[0];
            } else {
                exeExtensions = StringUtils.split((String)extensions, (String)",");
            }
        }
        return exeExtensions;
    }

    public boolean createTextFile(String fileName, String fileDirectory, String content) throws FileManagerException {
        try {
            if (content != null) {
                File directoryName = new File(FileManagerServiceBean.getUploadDir() + fileDirectory);
                directoryName.mkdirs();
                File newFile = new File(FileManagerServiceBean.getUploadDir() + fileDirectory, fileName);
                newFile.createNewFile();
                FileOutputStream out = new FileOutputStream(newFile);
                out.write(content.getBytes());
                out.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"createTextFile: File write failed ", (Throwable)e);
            throw new FileManagerException(e);
        }
        return true;
    }

    public String readTextFile(String fileName, String fileDirectory) throws FileManagerException {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            File newFile = new File(FileManagerServiceBean.getUploadDir() + fileDirectory, fileName);
            input = new BufferedReader(new FileReader(newFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (Exception e) {
            log.error((Object)"readTextFile: File write failed ", (Throwable)e);
        }
        return contents.toString();
    }

    public String uploadFile(FileItem fileToUpload, String originalFilename, Integer taskInstanceId, boolean preferDownload, boolean extractWebContent, boolean allowExecutables) throws FileManagerException, IllegalFileException {
        if (!allowExecutables && this.isExecutable(originalFilename)) {
            throw new IllegalFileException("May not upload executable file " + originalFilename);
        }
        String filename = this.attemptSaveFile(fileToUpload, originalFilename, taskInstanceId);
        String directoryName = null;
        if (extractWebContent) {
            directoryName = this.attemptUnzipWebContent(filename, taskInstanceId);
        }
        return "urlcont:" + (directoryName != null ? directoryName : filename);
    }

    public String uploadResource(FileItem fileToUpload, String originalFilename, String directoryName, boolean allowExecutables) throws FileManagerException, IllegalFileException {
        if (!allowExecutables && this.isExecutable(originalFilename)) {
            throw new IllegalFileException("May not upload executable file " + originalFilename);
        }
        String filename = this.attemptSaveFile(fileToUpload, originalFilename, directoryName);
        return "urlcont:" + (directoryName != null ? directoryName + File.separator + filename : filename);
    }

    public boolean deleteResource(String fileName, String directoryName) {
        try {
            if (fileName != null) {
                String fullDirectoryName = FileManagerServiceBean.getUploadDir() + File.separator + directoryName;
                File newFile = new File(fullDirectoryName, fileName);
                return newFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyDirectory(String source, String destination) {
        block16: {
            try {
                if (source == null || destination == null) break block16;
                String fullSourceDirectoryName = FileManagerServiceBean.getUploadDir() + File.separator + source;
                File sourceDirectory = new File(fullSourceDirectoryName);
                File[] sourceFiles = sourceDirectory.listFiles();
                String fullDestinationDirectoryName = FileManagerServiceBean.getUploadDir() + File.separator + destination;
                File directoryName = new File(fullDestinationDirectoryName);
                if (!directoryName.exists()) {
                    directoryName.mkdirs();
                }
                for (int indexFile = 0; indexFile < sourceFiles.length; ++indexFile) {
                    IOException e2;
                    Object var14_14;
                    File currentFile = sourceFiles[indexFile];
                    File newFile = new File(fullDestinationDirectoryName + File.separator + currentFile.getName());
                    FileInputStream fin = null;
                    FileOutputStream fout = null;
                    try {
                        fin = new FileInputStream(currentFile);
                        fout = new FileOutputStream(newFile);
                        this.copyStream(fin, fout);
                        var14_14 = null;
                    }
                    catch (Throwable throwable) {
                        var14_14 = null;
                        try {
                            if (fin != null) {
                                fin.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        try {
                            if (fout != null) {
                                fout.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (fout != null) {
                            fout.close();
                        }
                    }
                    catch (IOException e2) {}
                    fin.close();
                    fout.close();
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStream(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    private String attemptSaveFile(FileItem fileToUpload, String originalFilename, String directoryName) {
        File origName = new File(originalFilename);
        String pathRemoved = origName.getName();
        try {
            String fullDirectoryName = FileManagerServiceBean.getUploadDir() + File.separator + directoryName;
            File dir = new File(fullDirectoryName);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File newFile = new File(fullDirectoryName, pathRemoved);
            fileToUpload.write(newFile);
        }
        catch (Exception e) {
            log.error((Object)"uploadFile: File write failed ", (Throwable)e);
            throw new FileManagerException(e);
        }
        return pathRemoved;
    }

    private String attemptSaveFile(FileItem fileToUpload, String originalFilename, Integer taskInstanceId) {
        String newFilename;
        File origName = new File(originalFilename);
        String pathRemoved = origName.getName();
        try {
            int fileNum = this.nextInt();
            newFilename = this.buildNewFilename(fileNum, pathRemoved, taskInstanceId);
            File newFile = new File(FileManagerServiceBean.getUploadDir(), newFilename);
            fileToUpload.write(newFile);
        }
        catch (Exception e) {
            log.error((Object)"uploadFile: File write failed ", (Throwable)e);
            throw new FileManagerException(e);
        }
        return newFilename;
    }

    private StringBuffer formatURLString(String stringToFormat) {
        StringBuffer shortenedName = new StringBuffer(100);
        for (int i = 0; i < stringToFormat.length(); ++i) {
            char c = stringToFormat.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '.') continue;
            shortenedName.append(c);
        }
        return shortenedName;
    }

    private String buildNewFilename(long fileNum, String originalFileName, Integer taskInstanceId) {
        StringBuffer shortenedName = null;
        if (originalFileName != null) {
            shortenedName = this.formatURLString(originalFileName);
        }
        String newName = Long.toString(fileNum);
        if (taskInstanceId != null) {
            newName = newName + "_TASK" + taskInstanceId.toString();
        }
        if (shortenedName != null) {
            newName = newName + "_" + shortenedName.toString();
        }
        return newName;
    }

    private String attemptUnzipWebContent(String filename, Integer taskInstanceId) {
        String newDirName = null;
        try {
            File inputFile = new File(FileManagerServiceBean.getUploadDir(), filename);
            ZipUtil zipfile = null;
            try {
                zipfile = new ZipUtil(inputFile);
            }
            catch (ZipException ze) {
                // empty catch block
            }
            if (zipfile != null) {
                newDirName = this.buildNewFilename(this.nextInt(), null, taskInstanceId);
                File dir = new File(FileManagerServiceBean.getUploadDir(), newDirName);
                dir.mkdir();
                String installDir = dir.getAbsolutePath();
                zipfile.unzip(installDir);
                zipfile.close();
                inputFile.delete();
            }
        }
        catch (Exception e) {
            throw new FileManagerException(e);
        }
        return newDirName != null ? newDirName + '/' : null;
    }

    public void sendFile(String uriString, HttpServletResponse res, ServletContext context, boolean preferDownload) throws FileManagerException, IOException {
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            log.info((Object)"URISyntaxException being handled");
            throw new IOException(e.getClass().getName());
        }
        if (!URI_SCHEME.equals(uri.getScheme())) {
            String errorMessage = "Unexpected Protocol encountered: Expected:  urlcont  Received: " + uri.getScheme();
            log.debug((Object)errorMessage);
            throw new IOException(errorMessage);
        }
        String path = uri.getSchemeSpecificPart();
        if (path == null || path.length() == 0) {
            throw new IOException("Filename missing - no path");
        }
        File fullPath = new File(FileManagerServiceBean.getUploadDir(), path);
        try {
            DownloadFile.download(res, context, fullPath.getName(), fullPath.getAbsolutePath(), null, preferDownload);
        }
        catch (IOException e) {
            log.debug((Object)("IOException occured in sendFile(): " + e.getMessage()));
            throw new IOException(e.getClass().getName());
        }
    }

    public String getAccessUrl(String uriString, HttpServletResponse res, HttpServletRequest req, boolean preferDownload) throws FileManagerException {
        URI uri = null;
        log.debug((Object)("getAccessUrl: uri is " + uriString));
        if (uriString == null) {
            return null;
        }
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new FileManagerException("Unable to process file due to error in file uri", e);
        }
        String returnUrl = null;
        if (!URI_SCHEME.equals(uri.getScheme())) {
            returnUrl = uriString;
        } else {
            String path = uri.getSchemeSpecificPart();
            if (path == null || path.length() == 0) {
                throw new FileManagerException("Filename missing - no path");
            }
            if (path != null && path.indexOf(47) != -1) {
                String servername = ConfigurationServiceDelegate.get(ConfigurationKeys.SERVER_URL);
                log.debug((Object)("getAccessUrl: servername is " + servername));
                returnUrl = servername + "/upload/" + path;
            } else if (path != null) {
                try {
                    returnUrl = req.getContextPath() + '/' + FileManagerAction.getDownloadPath(uriString, preferDownload);
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Encoding of path threw exception", (Throwable)e);
                    throw new FileManagerException(e);
                }
            }
        }
        log.debug((Object)("Returning url " + returnUrl));
        return returnUrl;
    }

    public int isSupportedType(String uriString) {
        if (uriString != null && uriString.startsWith(URI_SCHEME)) {
            try {
                URI uri = new URI(uriString);
                String path = uri.getSchemeSpecificPart();
                if (path != null) {
                    if (path.indexOf(47) != -1) {
                        return 2;
                    }
                    return 1;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return 0;
    }

    private int nextInt() throws FileManagerException {
        try {
            SequenceGenHome sgHome;
            try {
                sgHome = (SequenceGenHome)EJBHomeFactory.getInstance().lookup("ejb/util/SequenceGen", class$com$webmcq$ld$util$sequence$interfaces$SequenceGenHome == null ? (class$com$webmcq$ld$util$sequence$interfaces$SequenceGenHome = FileManagerServiceBean.class$("com.webmcq.ld.util.sequence.interfaces.SequenceGenHome")) : class$com$webmcq$ld$util$sequence$interfaces$SequenceGenHome);
            }
            catch (NameNotFoundException e) {
                throw new CreateException("sequence generator not found: " + e.getMessage());
            }
            return sgHome.create().getNextNumber(SEQUENCE_NAME);
        }
        catch (NamingException e) {
            throw new FileManagerException("Cannot generate id: " + e.toString());
        }
        catch (CreateException e) {
            throw new FileManagerException("Cannot generate id: " + e.toString());
        }
        catch (RemoteException e) {
            throw new FileManagerException("Cannot generate id: " + e.toString());
        }
    }

    private boolean isExecutable(String filename) {
        String extToCheck = this.getExtension(filename);
        if (extToCheck == null) {
            return false;
        }
        log.debug((Object)("Checking extension " + extToCheck));
        String[] extensions = this.getExeExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            log.debug((Object)("Comparing to extension " + extensions[i]));
            if (!extToCheck.equals(extensions[i])) continue;
            return true;
        }
        return false;
    }

    private String getExtension(String filename) {
        int index;
        String ext = null;
        if (filename != null && (index = filename.lastIndexOf(46)) > -1) {
            ext = filename.substring(index);
        }
        return ext;
    }

    public Long importDesign(String username, FileItem fileToUpload, String originalFilename, String submittedTitle, String fileExtension) {
        log.debug((Object)"importDesign");
        Long ldId = null;
        try {
            String fileContent = fileToUpload.getString(UTF_8_ENCODING);
            log.debug((Object)"got fileContent");
            String wddxPacket = this.decryptImport(fileContent);
            log.debug((Object)("got wddxPacket: " + wddxPacket));
            wddxPacket = this.verifyForImport(wddxPacket);
            log.debug((Object)("  modifed wddxPacket=" + wddxPacket));
            LDAuthoringServiceLocalHome home = LDAuthoringServiceUtil.getLocalHome();
            log.debug((Object)("  got LDAuthoringServiceLocalHome: " + home));
            LDAuthoringServiceLocal service = home.create();
            log.debug((Object)("  got LDAuthoringServiceLocal: " + service));
            String responseWddxPacket = service.storeLDDataWDDX(wddxPacket, username);
            log.debug((Object)("  responseWddxPacket: " + responseWddxPacket));
            service.remove();
            if (this.isErrorResponse(responseWddxPacket)) {
                String errorMessage = this.extractWddxErrorMsg(responseWddxPacket);
                log.error((Object)("  errorMessage: " + errorMessage));
                throw new Exception(errorMessage);
            }
            ldId = this.extractLdId(responseWddxPacket);
            log.debug((Object)("  *** ldId= " + ldId));
            return ldId;
        }
        catch (CreateException e) {
            log.error((Object)("EJB CreateException: " + (Object)((Object)e)));
            throw new FileManagerException(e);
        }
        catch (Exception e) {
            log.error((Object)"FileManager: import failed", (Throwable)e);
            throw new FileManagerException(e);
        }
    }

    private String decryptImport(String fileContent) throws WddxDeserializationException {
        if (fileContent.indexOf("<CipherValue>") == -1) {
            return fileContent;
        }
        int start = fileContent.indexOf("<CipherValue>") + 13;
        int end = fileContent.indexOf("</CipherValue>");
        String cipherValue = fileContent.substring(start, end);
        log.debug((Object)("  cipherValue= " + cipherValue));
        byte[] encryptedBytes = Base64.decodeBase64((byte[])cipherValue.getBytes());
        String decrypted = this.getDecrypted(encryptedBytes);
        log.debug((Object)("  cipherValue= " + decrypted));
        return decrypted;
    }

    private String getDecrypted(byte[] encryptedBytes) throws SecurityException {
        try {
            Cipher cipher = Cipher.getInstance(ENC_CIPHER_ALGORITHM);
            cipher.init(2, secretKey, algorithmParameterSpec);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new SecurityException(e.getMessage());
        }
    }

    private String verifyForImport(String wddxPacket) throws WddxDeserializationException, UnsupportedVersionException, IOException {
        log.debug((Object)"verifyForImport");
        if (wddxPacket.indexOf("<null") != -1) {
            log.error((Object)"Cannot process data containing '<null/>'.");
            throw new IllegalArgumentException("Version string missing");
        }
        Map wddxData = (Map)WDDXProcessor.deserialize(wddxPacket);
        String versionString = (String)wddxData.get("lamsVersion");
        log.debug((Object)("The version in this packet is: " + versionString));
        if (versionString == null) {
            log.error((Object)"lamsVersion string missing");
            throw new UnsupportedVersionException("LAMS version string missing");
        }
        String curVersion = NewVersion.getVersion();
        log.debug((Object)("The current version is: " + curVersion));
        if (!curVersion.equals(versionString)) {
            log.debug((Object)("Trying to import a different version: " + versionString));
        }
        wddxData.put("LDId", new Long(-1L));
        wddxData.put("readOnly", new Boolean(false));
        wddxData.put("readAccessStatus", new Boolean(true));
        wddxData.put("readAccessDesc", "Private");
        wddxData.put("readAccess", new Integer(-1));
        wddxData.put("writeAccessStatus", new Boolean(true));
        wddxData.put("writeAccessDesc", "Private");
        wddxData.put("writeAccess", new Integer(-1));
        wddxPacket = WDDXProcessor.serialize(wddxData);
        log.debug((Object)("modified wddxPacket: " + wddxPacket));
        return wddxPacket;
    }

    private boolean isErrorResponse(String responseWddxPacket) {
        log.debug((Object)("responseWddxPacket = " + responseWddxPacket));
        return responseWddxPacket.indexOf("Error") != -1;
    }

    private String extractWddxErrorMsg(String responseWddxPacket) throws WddxDeserializationException {
        Map response = (Map)WDDXProcessor.deserialize(responseWddxPacket);
        String errorMessage = (String)response.get("message");
        return errorMessage;
    }

    private Long extractLdId(String responseWddxPacket) throws WddxDeserializationException, WDDXProcessorConversionException {
        Map response = (Map)WDDXProcessor.deserialize(responseWddxPacket);
        Object responseData = response.get("responseData");
        Long ldId = WDDXProcessor.convertToLong("responseData", responseData);
        return ldId;
    }

    public void sendDesign(String username, String ldIdStr, HttpServletResponse res, ServletContext context, String exportType) throws FileManagerException, IOException, NamingException, WddxDeserializationException, CreateException, ServletException {
        log.debug((Object)"sendDesign ldId");
        try {
            Long ldId = new Long(ldIdStr);
            log.debug((Object)("ldId = " + ldId));
            LDAuthoringServiceLocalHome home = LDAuthoringServiceUtil.getLocalHome();
            log.debug((Object)("  got LDAuthoringServiceLocalHome: " + home));
            LDAuthoringServiceLocal service = home.create();
            log.debug((Object)("  got LDAuthoringServiceLocal: " + service));
            String wddxPacket = service.learningDesignRequestWDDX(ldId, username);
            log.debug((Object)("  got wddxPacket: " + wddxPacket));
            Map exportDesign = (Map)WDDXProcessor.deserialize(wddxPacket);
            log.debug((Object)("  got deserialized wddxPacket: " + exportDesign));
            exportDesign = this.resetFieldsForExport(exportDesign);
            log.debug((Object)"  got field values reset for export");
            String designName = (String)exportDesign.get("title");
            log.debug((Object)("  got design title: " + designName));
            String version = (String)exportDesign.get("lamsVersion");
            log.debug((Object)(" got design version: " + version));
            String exportPacket = WDDXProcessor.serialize(exportDesign);
            log.debug((Object)"  got exportPacket");
            DownloadFile.export(res, context, designName.trim(), exportType, exportPacket);
        }
        catch (SystemException e) {
            log.error((Object)e.getMessage());
            throw new FileManagerException(e);
        }
    }

    private Map resetFieldsForExport(Map wddxData) {
        wddxData.put("lamsVersion", NewVersion.getVersion());
        wddxData.put("LDId", new Long(-1L));
        wddxData.put("readOnly", new Boolean(false));
        wddxData.put("readAccessStatus", new Boolean(true));
        wddxData.put("readAccessDesc", "Private");
        wddxData.put("readAccess", new Integer(-1));
        wddxData.put("writeAccessStatus", new Boolean(true));
        wddxData.put("writeAccessDesc", "Private");
        wddxData.put("writeAccess", new Integer(-1));
        return wddxData;
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

