/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat.web;

import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.chat.ChatTaskException;
import com.webmcq.ld.tool.chat.interfaces.ChatGroupData;
import com.webmcq.ld.tool.chat.interfaces.ChatService;
import com.webmcq.ld.tool.chat.interfaces.ChatServiceUtil;
import com.webmcq.ld.tool.chat.interfaces.ChatUserData;
import com.webmcq.ld.tool.chat.web.ChatGroupForm;
import com.webmcq.ld.tool.chat.web.ChatUserForm;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ChatGroupAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$chat$web$ChatGroupAction == null ? (class$com$webmcq$ld$tool$chat$web$ChatGroupAction = ChatGroupAction.class$("com.webmcq.ld.tool.chat.web.ChatGroupAction")) : class$com$webmcq$ld$tool$chat$web$ChatGroupAction));
    private static final String ATTR_MODE = "mode";
    private static final String ATTR_USER = "user";
    private static final String ATTR_COMMAND = "command";
    private static final String FORWARD_VIEW = "view";
    private static final String FORWARD_CHAT = "chatGroup";
    private static final String FORWARD_INSTRUCTIONS = "instructions";
    static /* synthetic */ Class class$com$webmcq$ld$tool$chat$web$ChatGroupAction;

    public ActionForward instructions(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        log.debug((Object)FORWARD_INSTRUCTIONS);
        HttpSession session = req.getSession(true);
        if (session == null) {
            log.error((Object)"HttpSession does not exist");
            throw new SystemException("HttpSession does not exist");
        }
        String mode = req.getParameter(ATTR_MODE);
        if (mode == null || "".equals(mode.trim())) {
            log.error((Object)"mode was null or empty");
            mode = "run";
        } else if (FORWARD_VIEW.equals(mode)) {
            req.setAttribute("viewOnly", (Object)mode);
        } else if ("checkup".equals(mode)) {
            req.setAttribute("viewOnly", (Object)mode);
        }
        log.debug((Object)("mode: " + mode));
        session.setAttribute(ATTR_MODE, (Object)mode);
        ChatGroupForm chatGroupForm = null;
        chatGroupForm = form == null ? new ChatGroupForm() : (form instanceof ChatGroupForm ? (ChatGroupForm)form : new ChatGroupForm());
        String sessionIdParam = req.getParameter("sessionId");
        if (sessionIdParam == null || "".equals(sessionIdParam.trim())) {
            log.error((Object)"sessionIdParam does not exist");
            throw new SystemException("sessionIdParam does not exist");
        }
        log.debug((Object)("sessionIdParam: " + sessionIdParam));
        long sessionId = Long.parseLong(sessionIdParam);
        log.debug((Object)("sessionId: " + sessionId));
        ChatService service = null;
        try {
            service = ChatServiceUtil.getHome().create();
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        catch (CreateException e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        if (service == null) {
            log.error((Object)"cannot create ChatService service");
            throw new SystemException("cannot create ChatService service");
        }
        ChatGroupData chatGroupData = service.getChatGroupData(sessionId);
        if (chatGroupData == null) {
            log.error((Object)"a chat group for this sesisonId does not exist");
            throw new SystemException("a chat group for this sesisonId does not exist");
        }
        try {
            BeanUtils.copyProperties((Object)((Object)chatGroupForm), (Object)chatGroupData);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        long chatGroupSid = chatGroupData.getSid();
        log.debug((Object)(" chatGroupSid: " + chatGroupSid));
        log.debug((Object)(" mapping Attibute: " + mapping.getAttribute()));
        session.setAttribute(mapping.getAttribute(), (Object)chatGroupForm);
        return mapping.findForward(FORWARD_INSTRUCTIONS);
    }

    public ActionForward startChat(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        long userId;
        String loginName;
        log.debug((Object)"startChat");
        HttpSession session = req.getSession(false);
        if (session == null) {
            log.error((Object)"HttpSession does not exist");
            throw new SystemException("HttpSession does not exist");
        }
        String mode = req.getParameter(ATTR_MODE);
        if (mode == null || "".equals(mode.trim())) {
            log.error((Object)"mode was null or empty");
            mode = "run";
        } else if (FORWARD_VIEW.equals(mode)) {
            req.setAttribute("viewOnly", (Object)mode);
        } else if ("checkup".equals(mode)) {
            req.setAttribute("viewOnly", (Object)mode);
        }
        log.debug((Object)("mode: " + mode));
        session.setAttribute(ATTR_MODE, (Object)mode);
        ChatGroupForm chatGroupForm = null;
        chatGroupForm = form == null ? new ChatGroupForm() : (form instanceof ChatGroupForm ? (ChatGroupForm)form : new ChatGroupForm());
        long sessionId = this.getTaskInstanceIdFromSession(req);
        ChatService service = null;
        try {
            service = ChatServiceUtil.getHome().create();
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new SystemException(e.getMessage());
        }
        catch (CreateException e) {
            log.error((Object)e);
            throw new SystemException(e.getMessage());
        }
        if (service == null) {
            log.error((Object)"cannot create ChatService service");
            throw new SystemException("cannot create ChatService service");
        }
        ChatGroupData chatGroupData = service.getChatGroupData(sessionId);
        if (chatGroupData == null) {
            log.error((Object)"a chat group for this sesisonId does not exist");
            throw new SystemException("a chat group for this sesisonId does not exist");
        }
        try {
            BeanUtils.copyProperties((Object)((Object)chatGroupForm), (Object)chatGroupData);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        long chatGroupSid = chatGroupData.getSid();
        log.debug((Object)(" chatGroupSid: " + chatGroupSid));
        log.debug((Object)(" mapping Attibute: " + mapping.getAttribute()));
        if (form == null) {
            log.error((Object)"ChatGroupForm is null");
            throw new SystemException("ChatGroupForm is null");
        }
        log.debug((Object)(" mapping Attibute: " + mapping.getAttribute()));
        session.setAttribute(mapping.getAttribute(), (Object)form);
        session.setAttribute("isReusable", (Object)(chatGroupData.getIsReusable() != 1 ? "false" : "true"));
        ActionForward dest = null;
        if ("run".equals(mode.trim()) || "resume".equals(mode.trim())) {
            chatGroupForm.setIsFinishButtonEnabled(true);
        } else {
            if ("checkup".equals(mode.trim())) {
                log.debug((Object)("mode: " + mode));
                return this.forwardToChatHistoryPage(mapping, session);
            }
            if (FORWARD_VIEW.equals(mode)) {
                if (chatGroupData.getIsReusable() != 1) {
                    return this.forwardToChatHistoryPage(mapping, session);
                }
                chatGroupForm.setIsFinishButtonEnabled(false);
            }
        }
        session.setAttribute(mapping.getAttribute(), (Object)chatGroupForm);
        if (service == null) {
            log.error((Object)"cannot create the ChatServiceBean service");
            throw new SystemException("cannot create the ChatServiceBean service");
        }
        try {
            loginName = WebUtil.getUsername(req);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        log.debug((Object)("got user's login name: " + loginName));
        try {
            userId = UserServiceDelegate.findUserId(loginName);
            log.debug((Object)("got userId: " + userId));
        }
        catch (UserNotFoundException e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        ChatUserData chatUserData = service.getChatUserDataByUserId(chatGroupSid, userId);
        if (chatUserData == null) {
            log.debug((Object)("chatUserData is null: " + userId));
            log.debug((Object)"it means that the user data has not been created yet.");
            log.debug((Object)"trying to create a new user...");
            chatUserData = service.createNewChatUser(chatGroupSid, userId, loginName);
        }
        log.debug((Object)("  chatUserData: " + chatUserData));
        if (chatUserData == null) {
            log.error((Object)"failed to find or create chatUserData");
            throw new SystemException("failed to find or to create chatUserData");
        }
        ChatUserForm chatUserForm = new ChatUserForm();
        try {
            BeanUtils.copyProperties((Object)((Object)chatUserForm), (Object)chatUserData);
            log.debug((Object)(" copied to the ChatUserForm: " + (Object)((Object)chatUserForm)));
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
            throw new SystemException(e);
        }
        session.setAttribute(ATTR_USER, (Object)chatUserForm);
        log.debug((Object)"setting the ChatUserForm as a session attribute");
        dest = mapping.findForward(FORWARD_CHAT);
        log.debug((Object)("forwarding to :" + dest));
        return dest;
    }

    public ActionForward completeSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"completeSession");
            HttpSession session = req.getSession(false);
            if (session == null) {
                log.debug((Object)"HttpSession does not exist");
                throw new ChatTaskException("HttpSession does not exist");
            }
            if (form == null) {
                log.debug((Object)"no form found");
                throw new ChatTaskException("no form found");
            }
            ChatGroupForm chatGroupForm = (ChatGroupForm)form;
            long sessionId = Long.parseLong(chatGroupForm.getSessionId());
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            log.debug((Object)("userId: " + userId));
            ChatService service = ChatServiceUtil.getHome().create();
            DisplayTaskData displayTaskData = service.completeSession(userId, sessionId);
            return this.displayTask(displayTaskData, mapping, form, req, res);
        }
        catch (CreateException e) {
            log.error((Object)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new SystemException(e.getMessage());
        }
        catch (ChatTaskException e) {
            log.error((Object)e);
            throw new SystemException(e.getMessage());
        }
        catch (SystemException e) {
            return mapping.findForward("error");
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new SystemException(e.getMessage());
        }
    }

    private ActionForward forwardToChatHistoryPage(ActionMapping mapping, HttpSession session) {
        session.setAttribute(ATTR_COMMAND, (Object)"GET_GROUP_ARCHIVE");
        return mapping.findForward(FORWARD_VIEW);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

