/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat.flashserver;

import com.webmcq.ld.tool.chat.flashserver.ChatDaemonThread;
import com.webmcq.ld.tool.chat.flashserver.ChatUser;
import com.webmcq.ld.tool.chat.flashserver.FlashPacket;
import com.webmcq.ld.tool.chat.flashserver.RequestHandler;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.NoSuchElementException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class LoginRequestHandler
extends RequestHandler {
    protected static final Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$chat$flashserver$LoginRequestHandler == null ? (class$com$webmcq$ld$tool$chat$flashserver$LoginRequestHandler = LoginRequestHandler.class$("com.webmcq.ld.tool.chat.flashserver.LoginRequestHandler")) : class$com$webmcq$ld$tool$chat$flashserver$LoginRequestHandler));
    static /* synthetic */ Class class$com$webmcq$ld$tool$chat$flashserver$LoginRequestHandler;

    public LoginRequestHandler(ChatDaemonThread server) {
        super(server);
    }

    public FlashPacket process(FlashPacket packet, SelectionKey key, SocketChannel socket) {
        log.debug((Object)"LOGIN_REQUEST");
        String username = packet.getUsername();
        String password = packet.getPassword();
        if (username != null && "".equals(username = username.trim())) {
            username = null;
        }
        if (password != null && "".equals(password = password.trim())) {
            password = null;
        }
        ChatUser chatUser = null;
        try {
            if (username == null || password == null) {
                throw new FailedLoginException("username or password is emty");
            }
            chatUser = this.userRegistry.authenticateUser(username, password, this.server);
            log.debug((Object)("username was found and authenticated: " + username));
            FlashPacket response = this.successfulLogin(packet, chatUser.getUserId());
            key.attach(chatUser);
            return response;
        }
        catch (FailedLoginException e) {
            log.error((Object)e);
            FlashPacket response = this.wrongPasswordError(packet, e);
            return response;
        }
        catch (LoginException e) {
            log.error((Object)e);
            FlashPacket response = this.loginError(packet, e);
            return response;
        }
        catch (NoSuchElementException e) {
            try {
                log.debug((Object)"the username not found");
                log.debug((Object)"*trying to register the new user*");
                chatUser = this.userRegistry.registerUser(username, password);
            }
            catch (LoginException le) {
                log.error((Object)e);
                FlashPacket response = this.regitrationFailedError(packet, le);
                return response;
            }
            log.debug((Object)"the new user was registered successfully");
            FlashPacket response = this.successfulLogin(packet, chatUser.getUserId());
            key.attach(chatUser);
            return response;
        }
    }

    protected FlashPacket loginError(FlashPacket packet, Exception e) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("LOGIN_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("401");
        response.setBodyText(e.getMessage());
        return response;
    }

    protected FlashPacket wrongPasswordError(FlashPacket packet, Exception e) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("LOGIN_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("401");
        response.setBodyText(e.getMessage());
        return response;
    }

    protected FlashPacket regitrationFailedError(FlashPacket packet, Exception e) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("LOGIN_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("301");
        response.setBodyText(e.getMessage());
        return response;
    }

    protected FlashPacket successfulLogin(FlashPacket packet, long userId) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("LOGIN_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        String userIdString = String.valueOf(userId);
        response.setUserId(userIdString);
        response.setStatus("SUCCESS");
        response.setStatusCode("200");
        response.setUsername(null);
        response.setPassword(null);
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

