/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat.flashserver;

import com.webmcq.ld.tool.chat.flashserver.ChatDaemonThread;
import com.webmcq.ld.tool.chat.flashserver.ChatRoom;
import com.webmcq.ld.tool.chat.flashserver.ChatUser;
import com.webmcq.ld.tool.chat.flashserver.FlashPacket;
import com.webmcq.ld.tool.chat.flashserver.GroupMember;
import com.webmcq.ld.tool.chat.flashserver.RequestHandler;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class JoinRequestHandler
extends RequestHandler {
    protected static final Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$chat$flashserver$JoinRequestHandler == null ? (class$com$webmcq$ld$tool$chat$flashserver$JoinRequestHandler = JoinRequestHandler.class$("com.webmcq.ld.tool.chat.flashserver.JoinRequestHandler")) : class$com$webmcq$ld$tool$chat$flashserver$JoinRequestHandler));
    static /* synthetic */ Class class$com$webmcq$ld$tool$chat$flashserver$JoinRequestHandler;

    public JoinRequestHandler(ChatDaemonThread server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlashPacket process(FlashPacket packet, SelectionKey key, SocketChannel socket) {
        log.debug((Object)"it is JoinRequest");
        String chatgroup = packet.getChatroom();
        String nickname = packet.getFrom();
        if (chatgroup != null && "".equals(chatgroup = chatgroup.trim())) {
            chatgroup = null;
        }
        if (nickname != null && "".equals(nickname = nickname.trim())) {
            nickname = null;
        }
        long chatRoomId = -1L;
        long memberId = -1L;
        GroupMember member = null;
        ChatRoom chatRoom = null;
        FlashPacket response = null;
        if (chatgroup == null || nickname == null) {
            response = this.missingParameterError(packet, chatgroup, nickname);
            return response;
        }
        log.debug((Object)" - check whether the chat room already exists");
        chatRoom = this.roomRegistry.findChatRoom(chatgroup);
        log.debug((Object)(" #### chatRoom: " + chatRoom));
        if (chatRoom == null) {
            chatRoom = new ChatRoom(this.roomRegistry, chatgroup);
            this.roomRegistry.putChatRoom(chatgroup, chatRoom);
            log.debug((Object)("room created: " + chatRoom));
        }
        ChatUser user = (ChatUser)key.attachment();
        log.debug((Object)("got the user object: " + user));
        log.debug((Object)" finding the member object for the user in this room");
        member = user.findMembership(chatgroup);
        if (member != null) {
            log.debug((Object)"  member object is found");
            memberId = member.getMemberId();
            log.debug((Object)("  memberId: " + memberId));
            String oldNickname = member.getNickname();
            log.debug((Object)" checking whether the nicknames are the same");
            if (oldNickname.equals(nickname)) {
                log.debug((Object)"  nicknames matched");
                log.debug((Object)" Trying to save the packet to the archive");
                chatRoom.savePacket(packet);
                response = this.joinSuccess(packet, member);
                return response;
            }
            response = this.nicknameDiffersError(packet, oldNickname);
            log.debug((Object)"nickname differed");
            return response;
        }
        log.debug((Object)" - member object was not found");
        log.debug((Object)" - must create one for the room");
        ChatRoom chatRoom2 = chatRoom;
        synchronized (chatRoom2) {
            member = chatRoom.findMember(nickname);
            if (member != null) {
                log.debug((Object)("the nickname to register is already in use: " + nickname));
                response = this.nickNameInUseError(packet, nickname);
                return response;
            }
            member = new GroupMember(chatRoom, user, nickname);
            log.debug((Object)("created a new member: " + nickname));
            chatRoom.putMember(nickname, member);
            user.addMembership(chatgroup, member);
            log.debug((Object)("member is now linked properly: " + member));
        }
        log.debug((Object)" Trying the save the packet to the archive");
        chatRoom.savePacket(packet);
        log.debug((Object)"preparing the success resonpse");
        response = this.joinSuccess(packet, member);
        return response;
    }

    protected FlashPacket joinSuccess(FlashPacket packet, GroupMember member) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("JOIN_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("SUCCESS");
        response.setStatusCode("200");
        long memberId = member.getMemberId();
        long roomId = member.getChatRoom().getRoomId();
        String memberIdString = String.valueOf(memberId);
        String roomIdString = String.valueOf(roomId);
        response.setMemberId(memberIdString);
        response.setChatroomId(roomIdString);
        return response;
    }

    protected FlashPacket nicknameDiffersError(FlashPacket packet, String oldNickname) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("JOIN_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("401");
        response.setBodyText("nickname is different from what is registered: " + oldNickname);
        return response;
    }

    protected FlashPacket nickNameInUseError(FlashPacket packet, String nickname) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("JOIN_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("402");
        response.setBodyText("nickname is in use by another user: " + nickname);
        return response;
    }

    protected FlashPacket missingParameterError(FlashPacket packet, String chatgroup, String nickname) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("JOIN_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("403");
        response.setBodyText("chatroom or nickname is missing: (" + chatgroup + "," + nickname + ")");
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

