/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat.flashserver;

import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.interfaces.ConfigurationService;
import com.webmcq.ld.service.interfaces.ConfigurationServiceUtil;
import com.webmcq.ld.tool.chat.flashserver.ChatRoomRegistry;
import com.webmcq.ld.tool.chat.flashserver.ChatUser;
import com.webmcq.ld.tool.chat.flashserver.FlashPacket;
import com.webmcq.ld.tool.chat.flashserver.GroupMember;
import com.webmcq.ld.tool.chat.flashserver.NoHeaderOutputStream;
import com.webmcq.ld.tool.chat.flashserver.RequestHandler;
import com.webmcq.ld.tool.chat.servlet.ChatArchive;
import com.webmcq.ld.util.WDDXProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class ChatRoom {
    protected static final Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$chat$flashserver$ChatRoom == null ? (class$com$webmcq$ld$tool$chat$flashserver$ChatRoom = ChatRoom.class$("com.webmcq.ld.tool.chat.flashserver.ChatRoom")) : class$com$webmcq$ld$tool$chat$flashserver$ChatRoom));
    protected ChatRoomRegistry roomRegistry = null;
    protected String roomName = null;
    protected long roomId = -1L;
    protected Map members = new HashMap();
    protected File messageFile = null;
    private LinkedList allMessages = new LinkedList();
    private static long count = 0L;
    static /* synthetic */ Class class$com$webmcq$ld$tool$chat$flashserver$ChatRoom;

    public ChatRoom(ChatRoomRegistry roomRegistry, String roomName) {
        this.roomRegistry = roomRegistry;
        this.roomName = roomName;
        this.roomId = this.nextId();
        String lamsHome = null;
        try {
            ConfigurationService service = ConfigurationServiceUtil.getHome().create();
            lamsHome = service.get(ConfigurationKeys.LAMS_HOME);
            service.remove();
            if (lamsHome == null) {
                log.error((Object)"LAMS_HOME not configured");
                log.error((Object)"using ./chat/");
                lamsHome = "chat";
            }
            log.info((Object)("hostName: '" + lamsHome + "'"));
        }
        catch (NamingException e) {
            log.error((Object)e);
        }
        catch (CreateException e) {
            log.error((Object)e);
        }
        catch (RemoveException e) {
            log.error((Object)e);
        }
        catch (RemoteException e) {
            log.error((Object)e);
        }
        String msgArchivePath = lamsHome + "/chat/archive";
        File archiveDir = new File(msgArchivePath);
        boolean isCreated = archiveDir.mkdirs();
        if (isCreated) {
            log.debug((Object)("directory created: " + archiveDir));
        } else {
            log.debug((Object)("directory was not created: " + archiveDir));
        }
        String filePath = roomName + ".pkt";
        try {
            this.messageFile = new File(archiveDir, filePath);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (this.messageFile == null) {
            log.error((Object)"messageFile not created");
        }
    }

    public LinkedList getAllChatRoomMessages() {
        return this.allMessages;
    }

    private long nextId() {
        return count++;
    }

    public void putMember(String nickname, GroupMember member) {
        this.members.put(nickname, member);
    }

    public void addMember(String nickname, GroupMember member) throws NameAlreadyBoundException {
        if (this.members.containsKey(nickname)) {
            throw new NameAlreadyBoundException("nickname in use");
        }
        this.members.put(nickname, member);
    }

    public GroupMember removeMember(String nickname) {
        GroupMember member = (GroupMember)this.members.remove(nickname);
        return member;
    }

    public GroupMember findMember(String nickname) {
        GroupMember member = (GroupMember)this.members.get(nickname);
        return member;
    }

    public GroupMember createNewNember(String nickname, ChatUser user) {
        return new GroupMember(this, user, nickname);
    }

    public String getRoomName() {
        return this.roomName;
    }

    public void sendToAll(FlashPacket packet) {
        log.debug((Object)("sendToAll: " + packet));
        Collection values = this.members.values();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            GroupMember member = (GroupMember)i.next();
            String nickname = member.getNickname();
            log.debug((Object)("  send to: " + nickname));
            String presence = member.getPresence();
            if (!presence.equals("chat")) {
                log.debug((Object)("    the user is not in CHAT: " + nickname));
                continue;
            }
            packet.setTo(nickname);
            ChatUser user = member.getUser();
            try {
                user.addMessageToSend(WDDXProcessor.serialize(packet));
            }
            catch (IOException ioe) {
                log.error((Object)("java.io.IOException: " + ioe));
            }
        }
    }

    public void announceNewMember(GroupMember member) {
        log.debug((Object)("announceNewMember: " + member));
        String roomIdString = String.valueOf(this.roomId);
        long memberId = member.getMemberId();
        String memberIdString = String.valueOf(memberId);
        String nickname = member.getNickname();
        String presence = member.getPresence();
        FlashPacket packet = new FlashPacket();
        packet.setType("ADD_USER");
        packet.setChatroom(this.roomName);
        packet.setChatroomId(roomIdString);
        packet.setMemberId(memberIdString);
        packet.setFrom(nickname);
        packet.setPresence(presence);
        packet.setBodyText(nickname + " has joined");
        this.sendToAll(packet);
    }

    public void announceMemberLeaving(FlashPacket packet) {
        log.debug((Object)("announceMemberLeaving: " + packet));
        packet.setType("REMOVE_USER");
        this.sendToAll(packet);
    }

    public synchronized void sendMemberRoster(GroupMember member, SelectionKey key, SocketChannel socket) {
        log.debug((Object)("sendMemberRoster: " + member));
        ChatUser user = member.getUser();
        String roomIdString = String.valueOf(this.roomId);
        FlashPacket packet = new FlashPacket();
        packet.setType("ADD_USER");
        packet.setChatroom(this.roomName);
        packet.setChatroomId(roomIdString);
        Iterator i = this.members.values().iterator();
        while (i.hasNext()) {
            log.debug((Object)"next roster entry...");
            GroupMember other = (GroupMember)i.next();
            if (other.equals(member)) {
                log.debug((Object)"  skip to send it to self");
                continue;
            }
            String nickname = other.getNickname();
            packet.setFrom(nickname);
            log.debug((Object)("  sending the presence of: " + nickname));
            String memberIdString = String.valueOf(other.getMemberId());
            packet.setMemberId(memberIdString);
            String presence = other.getPresence();
            if (presence != "chat") continue;
            packet.setPresence(presence);
            log.debug((Object)("  packet = " + packet));
            try {
                RequestHandler.writeResponse(WDDXProcessor.serialize(packet), key, socket);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    public long getRoomId() {
        return this.roomId;
    }

    public Map getMembers() {
        return this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void savePacket(FlashPacket packet) {
        log.debug((Object)("savePacket: " + packet));
        this.allMessages.add(packet);
        if (this.messageFile == null) {
            return;
        }
        File file = this.messageFile;
        synchronized (file) {
            block22: {
                FileOutputStream out = null;
                ObjectOutputStream oos = null;
                boolean append = true;
                out = new FileOutputStream(this.messageFile, append);
                oos = this.messageFile.length() > 0L ? new NoHeaderOutputStream(out) : new ObjectOutputStream(out);
                oos.writeObject(packet);
                oos.flush();
                Object var7_8 = null;
                try {
                    if (oos != null) {
                        oos.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    break block22;
                }
                catch (IOException e2) {
                    log.error((Object)e2);
                }
                break block22;
                {
                    catch (FileNotFoundException e) {
                        log.error((Object)e);
                        Object var7_9 = null;
                        try {
                            if (oos != null) {
                                oos.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                            break block22;
                        }
                        catch (IOException e2) {
                            log.error((Object)e2);
                        }
                        break block22;
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                        Object var7_10 = null;
                        try {
                            if (oos != null) {
                                oos.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                            break block22;
                        }
                        catch (IOException e2) {
                            log.error((Object)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e2) {
                        log.error((Object)e2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public ChatArchive getChatRoomArchive(String chatgroup) {
        ChatArchive archive = new ChatArchive(chatgroup);
        List messages = this.getMessages();
        archive.setMessages(messages);
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List getMessages() {
        log.debug((Object)"readPackets");
        ArrayList<FlashPacket> messages = new ArrayList<FlashPacket>();
        if (this.messageFile == null) {
            return messages;
        }
        File file = this.messageFile;
        synchronized (file) {
            block27: {
                FileInputStream in = null;
                ObjectInputStream ois = null;
                in = new FileInputStream(this.messageFile);
                ois = new ObjectInputStream(in);
                FlashPacket packet = null;
                while (in.available() > 0) {
                    Object object = ois.readObject();
                    packet = (FlashPacket)object;
                    messages.add(packet);
                }
                Object var8_10 = null;
                try {
                    if (ois != null) {
                        ois.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    break block27;
                }
                catch (IOException e2) {
                    log.error((Object)e2);
                }
                break block27;
                {
                    catch (FileNotFoundException e) {
                        log.error((Object)e);
                        Object var8_11 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (in != null) {
                                in.close();
                            }
                            break block27;
                        }
                        catch (IOException e2) {
                            log.error((Object)e2);
                        }
                        break block27;
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                        Object var8_12 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (in != null) {
                                in.close();
                            }
                            break block27;
                        }
                        catch (IOException e2) {
                            log.error((Object)e2);
                        }
                        break block27;
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)e);
                        Object var8_13 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            if (in != null) {
                                in.close();
                            }
                            break block27;
                        }
                        catch (IOException e2) {
                            log.error((Object)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e2) {
                        log.error((Object)e2);
                    }
                    throw throwable;
                }
            }
        }
        return messages;
    }

    public void sendAFewPreviousChats(GroupMember member, SelectionKey key, SocketChannel socket) {
        int n;
        ChatUser user = member.getUser();
        ArrayList messages = (ArrayList)this.getMessages();
        FlashPacket packet = null;
        for (int i = n = messages.size(); i >= 0 && i > n - 5; --i) {
            packet = (FlashPacket)messages.get(i);
            try {
                RequestHandler.writeResponse(WDDXProcessor.serialize(packet), key, socket);
                continue;
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

