/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.service;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.LearningSessionException;
import com.webmcq.ld.controller.ToolUrl;
import com.webmcq.ld.controller.dao.LearningSessionNotFoundException;
import com.webmcq.ld.controller.dto.ActivityInstanceData;
import com.webmcq.ld.controller.dto.LearnerData;
import com.webmcq.ld.controller.dto.SyncPointData;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.interfaces.StaffService;
import com.webmcq.ld.service.interfaces.StaffServiceHome;
import com.webmcq.ld.util.EJBHomeFactory;
import com.webmcq.ld.util.exception.SystemException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class StaffServiceDelegate {
    static /* synthetic */ Class class$com$webmcq$ld$service$interfaces$StaffServiceHome;

    public static LearnerData[] getAllLearners(long learningSessionId) throws ControllerException, SystemException, UserNotFoundException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            LearnerData[] data = service.getAllLearners(learningSessionId);
            StaffServiceDelegate.remove(service);
            return data;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static void start(int lsessionId) throws LearningSessionNotFoundException, ControllerException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            service.start(lsessionId);
            StaffServiceDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static void setActivityInstanceLock(long learningSessionId, long activityId, boolean lock) throws SystemException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            service.setActivityInstanceLock(learningSessionId, activityId, lock);
            StaffServiceDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static void setLearningSessionAvailability(long learningSessionId, boolean available) throws SystemException, LearningSessionException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            service.setLearningSessionAvailability(learningSessionId, available);
            StaffServiceDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static void setTaskInstanceLock(long learningSessionId, long taskId, boolean lock) throws SystemException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            service.setTaskInstanceLock(learningSessionId, taskId, lock);
            StaffServiceDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static SyncPointData[] getAllSyncPoints(long learningSessionId) throws SystemException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            SyncPointData[] data = service.getAllSyncPoints(learningSessionId);
            StaffServiceDelegate.remove(service);
            return data;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static ActivityInstanceData getActivityInfo(long learningSessionId, long activityId) throws SystemException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            ActivityInstanceData data = service.getActivityInfo(learningSessionId, activityId);
            StaffServiceDelegate.remove(service);
            return data;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static void updateStaffUrl(ToolUrl toolUrl) throws ControllerException, SystemException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            service.updateStaffUrl(toolUrl);
            StaffServiceDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    private static StaffService getService() throws SystemException {
        try {
            StaffServiceHome home = (StaffServiceHome)EJBHomeFactory.getInstance().lookup("ejb/service/StaffService", class$com$webmcq$ld$service$interfaces$StaffServiceHome == null ? (class$com$webmcq$ld$service$interfaces$StaffServiceHome = StaffServiceDelegate.class$("com.webmcq.ld.service.interfaces.StaffServiceHome")) : class$com$webmcq$ld$service$interfaces$StaffServiceHome);
            return home.create();
        }
        catch (NamingException e) {
            throw new SystemException(e);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
        catch (CreateException e) {
            throw new SystemException(e);
        }
    }

    private static void remove(StaffService service) throws SystemException {
        try {
            service.remove();
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
        catch (RemoveException e) {
            throw new SystemException(e);
        }
    }

    public static long createLearningSession(String username, int ldId, String title, String description, String sessionType) throws UserNotFoundException, ControllerException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            long id = service.createLearningSession(username, ldId, title, description, sessionType);
            StaffServiceDelegate.remove(service);
            return id;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static long createLearningSession(String username, int ldId, long classId, String title, String description, String sessionType) throws UserNotFoundException, ControllerException {
        try {
            StaffService service = StaffServiceDelegate.getService();
            long id = service.createLearningSession(username, ldId, classId, title, description, sessionType);
            StaffServiceDelegate.remove(service);
            return id;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static boolean removeLearningSession(long lsId) {
        try {
            StaffService service = StaffServiceDelegate.getService();
            service.removeLearningSession(lsId);
            StaffServiceDelegate.remove(service);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

