/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.service;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.activities.MultiTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.LearningSessionException;
import com.webmcq.ld.controller.SyncTaskInstance;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.ToolProxy;
import com.webmcq.ld.controller.ToolUrl;
import com.webmcq.ld.controller.dao.LearningSessionDAO;
import com.webmcq.ld.controller.dao.LearningSessionNotFoundException;
import com.webmcq.ld.controller.dao.TaskInstanceDAO;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dao.ToolNotFoundException;
import com.webmcq.ld.controller.dao.ToolProxyDAO;
import com.webmcq.ld.controller.dao.ToolUrlDAO;
import com.webmcq.ld.controller.design.LearningDesignServiceDelegate;
import com.webmcq.ld.controller.dto.ActivityInstanceData;
import com.webmcq.ld.controller.dto.ActivityInstanceTaskData;
import com.webmcq.ld.controller.dto.ControllerDTOFactory;
import com.webmcq.ld.controller.dto.LearnerData;
import com.webmcq.ld.controller.dto.LearningSessionData;
import com.webmcq.ld.controller.dto.SyncPointData;
import com.webmcq.ld.controller.learner.Group;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import org.apache.log4j.Logger;

public abstract class StaffServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$service$StaffServiceBean == null ? (class$com$webmcq$ld$service$StaffServiceBean = StaffServiceBean.class$("com.webmcq.ld.service.StaffServiceBean")) : class$com$webmcq$ld$service$StaffServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$service$StaffServiceBean;

    public ToolUrl[] getMonitorTasks(long learningSessionId) throws SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getMonitorTasks");
            sess = new PersistenceSession();
            ToolUrlDAO dao = new ToolUrlDAO(sess);
            List toolUrlList = dao.findBySessionId(new Long(learningSessionId));
            ToolUrl[] toolUrlArray = toolUrlList.toArray(new ToolUrl[toolUrlList.size()]);
            return toolUrlArray;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            throw new SystemException(e);
        }
        finally {
            sess.close();
        }
    }

    public String getJournalReviewTask(long learningSessionId) throws ControllerException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession learningSession = lsDao.find(learningSessionId);
            ToolProxyDAO dao = new ToolProxyDAO(sess);
            ToolProxy tool = dao.findByToolType("journalmonitor");
            sess.flush();
            String string = this.buildUrl(learningSession, tool);
            return string;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            String string = "";
            return string;
        }
        catch (ToolNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            String string = "";
            return string;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    private String buildUrl(LearningSession learningSession, ToolProxy tool) {
        log.debug((Object)("learner url: " + tool.getLearnerUrl()));
        StringBuffer url = new StringBuffer(200);
        url.append(tool.getLearnerUrl());
        if (learningSession != null) {
            url.append("&sequenceId=");
            url.append(learningSession.getSid());
            url.append("&sequenceTitle=");
            url.append(learningSession.getTitle());
        } else {
            url.append("&sequenceId=&sequenceTitle=");
        }
        log.debug((Object)("Returning url " + url));
        return url.toString();
    }

    public LearningSessionData[][] getAllSessions(long userId) throws SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getAllSessionTitles");
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            List archivedList = lsDao.findByOwner(userId, 1);
            List activeList = lsDao.findByOwner(userId, 0);
            LearningSessionData[][] sessions = new LearningSessionData[][]{ControllerDTOFactory.buildLearningSessionDatas(activeList), ControllerDTOFactory.buildLearningSessionDatas(archivedList)};
            LearningSessionData[][] learningSessionDataArray = sessions;
            return learningSessionDataArray;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void archive(long learningSessionId) throws LearningSessionNotFoundException, SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"archive");
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession learningSession = lsDao.find(learningSessionId);
            learningSession.setArchived(1);
            lsDao.update(learningSession);
            sess.flush();
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void removeLearningSession(long learningSessionId) throws SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"removeLearningSession");
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            try {
                lsDao.find(learningSessionId);
                lsDao.remove(learningSessionId);
                sess.flush();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            log.debug((Object)e);
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void start(int lsessionId) throws LearningSessionNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsession = lsDao.find(lsessionId);
            log.debug((Object)("NOW:" + lsession.getOrganisationId()));
            lsession.start(sess);
            lsDao.update(lsession);
            sess.flush();
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void updateStaffUrl(ToolUrl toolUrl) throws ControllerException {
        if (toolUrl == null || toolUrl.getTaskInstanceId() == null) {
            return;
        }
        log.debug((Object)("updateStaffUrl: toolUrl" + toolUrl.toString()));
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            ToolUrlDAO tuDao = new ToolUrlDAO(sess);
            ToolUrl dbValue = tuDao.findByTaskInstanceId(toolUrl.getTaskInstanceId());
            if (dbValue == null) {
                dbValue = new ToolUrl();
                Long sessionId = toolUrl.getSequenceSessionId();
                if (sessionId == null) {
                    TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
                    TaskInstance taskInstance = tiDao.find(toolUrl.getTaskInstanceId());
                    LearningSession learningSession = taskInstance.getLearningSession();
                    sessionId = new Long(learningSession.getSid());
                    dbValue.setSequenceSessionId(sessionId);
                    dbValue.setTaskInstanceId(toolUrl.getTaskInstanceId());
                    dbValue.setToolType(toolUrl.getToolType());
                    dbValue.setUrl(toolUrl.getUrl());
                    dbValue.setUrlTitle(toolUrl.getUrlTitle());
                    log.debug((Object)"saving value in database 1");
                    sess.persistece().save((Object)dbValue);
                }
                dbValue.setSequenceSessionId(sessionId);
                dbValue.setTaskInstanceId(toolUrl.getTaskInstanceId());
            } else {
                log.debug((Object)("dbValue found: " + dbValue));
                dbValue.setToolType(toolUrl.getToolType());
                dbValue.setUrl(toolUrl.getUrl());
                dbValue.setUrlTitle(toolUrl.getUrlTitle());
                log.debug((Object)"saving value in database 2");
                tuDao.update(dbValue);
            }
            sess.flush();
        }
        catch (HibernateException e) {
            this.getSessionContext().setRollbackOnly();
            throw new SystemException(e);
        }
        catch (TaskInstanceNotFoundException e) {
            log.error((Object)"updateStaffUrl", (Throwable)e);
            this.getSessionContext().setRollbackOnly();
            throw new ControllerException(e);
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public LearnerData[] getAllLearners(long learningSessionId) throws ControllerException, SystemException, UserNotFoundException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getAllLearners");
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession learningSession = lsDao.find(learningSessionId);
            Group group = learningSession.getLearners();
            Learner[] learners = group.getLearners();
            LearnerData[] learnerDataArray = ControllerDTOFactory.buildLearnerData(learners, learningSessionId);
            return learnerDataArray;
        }
        catch (LearningSessionException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ControllerException(e);
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void setActivityInstanceLock(long learningSessionId, long activityId, boolean lock) throws SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"lockActivityInstance");
            sess = new PersistenceSession();
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void setTaskInstanceLock(long learningSessionId, long taskId, boolean lock) throws SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"setTaskInstanceLock");
            sess = new PersistenceSession();
            TaskInstanceDAO dao = new TaskInstanceDAO(sess);
            TaskInstance[] tasks = dao.find(learningSessionId, taskId);
            if (tasks.length == 0) {
                return;
            }
            if (tasks[0].isLocked() == lock) {
                return;
            }
            for (int i = 0; i < tasks.length; ++i) {
                tasks[i].setLocked(lock);
                dao.update(tasks[i]);
            }
            sess.flush();
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public SyncPointData[] getAllSyncPoints(long learningSessionId) throws SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getAllSyncPoints");
            sess = new PersistenceSession();
            TaskInstanceDAO tidao = new TaskInstanceDAO(sess);
            SyncTaskInstance[] tasks = tidao.findAllSyncTasks(learningSessionId);
            SyncPointData[] syncPointDataArray = ControllerDTOFactory.buildSyncPointData(tasks);
            return syncPointDataArray;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public ActivityInstanceData getActivityInfo(long learningSessionId, long activityId) throws LearningSessionException, SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getActivityInfo");
            sess = new PersistenceSession();
            ActivityDefnVO activity = LearningDesignServiceDelegate.getActivity(activityId);
            if (activity == null) {
                ActivityInstanceData activityInstanceData = null;
                return activityInstanceData;
            }
            ActivityInstanceData actData = new ActivityInstanceData(activity.getSid(), activity.getTitle(), activity.getDescription(), true);
            Set tasks = activity.getTasks();
            TaskInstanceDAO tidao = new TaskInstanceDAO(sess);
            ToolUrlDAO tudao = new ToolUrlDAO(sess);
            Iterator iter = tasks.iterator();
            while (iter.hasNext()) {
                AbstractTaskVO taskDef = (AbstractTaskVO)iter.next();
                if (taskDef.theTaskType() == 2) {
                    ActivityInstanceTaskData multiTaskData = this.getTaskInfo(learningSessionId, taskDef, tidao, tudao);
                    MultiTaskVO mTask = (MultiTaskVO)taskDef;
                    Iterator subs = mTask.getSubTasks().iterator();
                    AbstractTaskVO sub = (AbstractTaskVO)subs.next();
                    ActivityInstanceTaskData taskData = this.getTaskInfo(learningSessionId, sub, tidao, tudao);
                    multiTaskData.setSubtask1(taskData);
                    sub = (AbstractTaskVO)subs.next();
                    taskData = this.getTaskInfo(learningSessionId, sub, tidao, tudao);
                    multiTaskData.setSubtask2(taskData);
                    actData.addTaskInstance(multiTaskData);
                    continue;
                }
                if (taskDef.theTaskType() != 1) continue;
                ActivityInstanceTaskData taskData = this.getTaskInfo(learningSessionId, taskDef, tidao, tudao);
                actData.addTaskInstance(taskData);
            }
            ActivityInstanceData activityInstanceData = actData;
            return activityInstanceData;
        }
        catch (LearningSessionException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    private ActivityInstanceTaskData getTaskInfo(long learningSessionId, AbstractTaskVO task, TaskInstanceDAO dao, ToolUrlDAO tudao) throws SystemException {
        try {
            TaskInstance[] taskInstances = dao.find(learningSessionId, (long)task.getSid());
            ActivityInstanceTaskData taskData = new ActivityInstanceTaskData(0L, task.getSid(), task.getTitle(), task.getDescription(), true, null);
            taskData.setTasktype(task.theObjectType());
            if (task instanceof SimpleTaskVO) {
                taskData.setTooltype(((SimpleTaskVO)task).getToolType());
            }
            for (int i = 0; i < taskInstances.length; ++i) {
                ToolUrl url = tudao.find(learningSessionId, taskInstances[i].getSid());
                taskData.addToolUrl(url);
            }
            return taskData;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
    }

    public void setLearningSessionAvailability(long learningSessionId, boolean available) throws LearningSessionException, SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"setLearningSessionAvailability");
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession learningSession = lsDao.find(learningSessionId);
            learningSession.setAvailable(!available);
            lsDao.update(learningSession);
            sess.flush();
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw new LearningSessionException(e);
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public long createLearningSession(String username, int ldId, String title, String description, String sessionType) throws UserNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"createLearningSession");
            LearningDesignServiceDelegate.findLearningDesign(ldId);
            ShwaaUserData user = UserServiceDelegate.find(username);
            LearningSession lsession = new LearningSession(user, ldId, title, description, sessionType);
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            lsDao.insert(lsession);
            sess.flush();
            log.debug((Object)("learning session created: " + lsession));
            long l = lsession.getSid();
            return l;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public long createLearningSession(String username, int ldId, long classId, String title, String description, String sessionType) throws UserNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"createLearningSession");
            LearningDesignServiceDelegate.findLearningDesign(ldId);
            ShwaaUserData user = UserServiceDelegate.find(username);
            LearningSession lsession = new LearningSession(user, ldId, title, description, sessionType);
            lsession.setOrganisation(classId);
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            lsDao.insert(lsession);
            sess.flush();
            log.debug((Object)("learning session created: " + lsession));
            long l = lsession.getSid();
            return l;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

