/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.web;

import com.webmcq.ld.controller.preview.dto.LearningDesignData;
import com.webmcq.ld.controller.preview.dto.TaskData;
import com.webmcq.ld.controller.util.WDDXUtil;
import com.webmcq.ld.service.PreviewServiceDelegate;
import com.webmcq.ld.util.WebUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class PreviewAction
extends DispatchAction {
    private final String PREVIEW_SESSION = "preview.session";

    public ActionForward select(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            long designId = WebUtil.readLongParam(req, "ldid");
            PreviewServiceDelegate service = new PreviewServiceDelegate(designId);
            req.getSession().setAttribute("preview.session", (Object)service);
            LearningDesignData data = service.getLearningDesignData();
            String packet = WDDXUtil.createACKMessage("preview-select", data, designId);
            res.getWriter().print(packet);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward getTask(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            long sessionId = WebUtil.readLongParam(req, "sessionId");
            long nextTaskId = WebUtil.readLongParam(req, "nextTaskId");
            PreviewServiceDelegate service = (PreviewServiceDelegate)req.getSession().getAttribute("preview.session");
            TaskData data = service.next(sessionId, nextTaskId, nextTaskId);
            String packet = WDDXUtil.createACKMessage("getTask", data, sessionId);
            res.getWriter().print(packet);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward remove(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            PreviewServiceDelegate service = (PreviewServiceDelegate)req.getSession().getAttribute("preview.session");
            service.remove();
            req.getSession().removeAttribute("preview.session");
            String packet = WDDXUtil.createACKMessage("remove", 0L);
            res.getWriter().print(packet);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward goToTool(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String toolName = WebUtil.readStrParam(req, "tool");
            return mapping.findForward(toolName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }
}

