/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.web;

import com.webmcq.ld.controller.dto.ClientSessionData;
import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ConfigurationServiceDelegate;
import com.webmcq.ld.service.UserServiceDelegate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.log4j.Logger;

public class ClientSessionDataManager {
    private static final String LOCK_NAME = "ClientSessionDataManager.MapAccess";
    private static Logger log = Logger.getLogger((String)(class$com$webmcq$ld$controller$web$ClientSessionDataManager == null ? (class$com$webmcq$ld$controller$web$ClientSessionDataManager = ClientSessionDataManager.class$("com.webmcq.ld.controller.web.ClientSessionDataManager")) : class$com$webmcq$ld$controller$web$ClientSessionDataManager).getName());
    private static ClientSessionDataManager realMe = null;
    private HashMap clientSessionsByUsername = new HashMap();
    private HashMap clientSessionsBySessionId = new HashMap();
    private int count = 0;
    private boolean allowMultipleLogins = false;
    static /* synthetic */ Class class$com$webmcq$ld$controller$web$ClientSessionDataManager;

    private ClientSessionDataManager() {
        String multipleString;
        Integer timeout = ConfigurationServiceDelegate.getAsInteger(ConfigurationKeys.INACTIVE_TIME);
        if (timeout != null) {
            ClientSessionData.setInactiveTimeout(timeout);
        }
        if ((multipleString = ConfigurationServiceDelegate.get(ConfigurationKeys.ALLOW_MULTIPLE_LOGINS)) != null && Boolean.valueOf(multipleString).equals(Boolean.TRUE)) {
            this.allowMultipleLogins = true;
            log.warn((Object)"Allow multiple logins is set to true. Presumably the test harness is running?");
        } else {
            this.allowMultipleLogins = false;
        }
    }

    public static ClientSessionDataManager getInstance() {
        if (realMe == null) {
            realMe = new ClientSessionDataManager();
        }
        return realMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSessionData getDetails(String username) {
        ClientSessionData results = null;
        String string = LOCK_NAME;
        synchronized (LOCK_NAME) {
            if (username != null) {
                results = this.getUserDetails(username);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDetails(Collection names) {
        Map results = null;
        String string = LOCK_NAME;
        synchronized (LOCK_NAME) {
            results = names == null ? this.getDetailsAllUsers() : this.getUserDetails(names);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return results;
        }
    }

    private Map getDetailsAllUsers() {
        HashSet<String> doneSessionIds = new HashSet<String>();
        HashMap<String, ClientSessionData> results = new HashMap<String, ClientSessionData>();
        Iterator iter = this.clientSessionsByUsername.values().iterator();
        while (iter.hasNext()) {
            ClientSessionData element = (ClientSessionData)iter.next();
            results.put(element.getUsername(), element);
            if (element.getSessionId() == null) continue;
            doneSessionIds.add(element.getSessionId());
        }
        int anonCount = 1;
        iter = this.clientSessionsBySessionId.values().iterator();
        while (iter.hasNext()) {
            ClientSessionData element = (ClientSessionData)iter.next();
            if (doneSessionIds.contains(element.getSessionId())) continue;
            results.put("Anonymous " + anonCount, element);
            ++anonCount;
        }
        return results;
    }

    private ClientSessionData getUserDetails(String username) {
        ClientSessionData data = (ClientSessionData)this.clientSessionsByUsername.get(username);
        return data;
    }

    private Map getUserDetails(Collection names) {
        HashMap<String, ClientSessionData> results = new HashMap<String, ClientSessionData>();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String username = (String)iter.next();
            ClientSessionData data = (ClientSessionData)this.clientSessionsByUsername.get(username);
            if (data == null) continue;
            results.put(username, data);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserAccess(HttpSession session, String username, String accessType) {
        if (username == null || accessType == null) {
            return;
        }
        HttpSession sessionToInvalidate = null;
        String string = LOCK_NAME;
        synchronized (LOCK_NAME) {
            log.debug((Object)("ClientSessionDataManager is trying to get the ClientSessionData for user-" + username + " from ClientSessionDataByUsername Map"));
            ClientSessionData data = (ClientSessionData)this.clientSessionsByUsername.get(username);
            if (data == null) {
                long uid = 0L;
                uid = UserServiceDelegate.retrieveUserId(username);
                log.debug((Object)("ClientSessionDataManager failed to get the ClientSessionData for user-" + username + " from ClientSessionDataByUsername Map"));
                log.debug((Object)("ClientSessionDataManager is trying to get the ClientSessionData for user-" + username + " from ClientSessionDataById Map"));
                data = (ClientSessionData)this.clientSessionsBySessionId.get(session.getId());
                if (data == null) {
                    log.debug((Object)("ClientSessionDataManager failed to get the ClientSessionData for user-" + username + " from ClientSessionDataById Map"));
                    data = new ClientSessionData(session, username, uid, accessType);
                    this.clientSessionsByUsername.put(data.getUsername(), data);
                    log.debug((Object)("ClientSessionDataManager put the ClientSessionData for user-" + username + " into ClientSessionDataByUsername Map"));
                    this.clientSessionsBySessionId.put(data.getSessionId(), data);
                    log.debug((Object)("ClientSessionDataManager put the ClientSessionData for user-" + username + " into ClientSessionDataById Map"));
                } else {
                    log.debug((Object)("ClientSessionDataManager got the ClientSessionData for user-" + username + " from ClientSessionDataById Map"));
                    data.setUsername(username);
                    data.setUserID(uid);
                    data.setLastInteraction(accessType);
                    this.clientSessionsByUsername.put(data.getUsername(), data);
                    log.debug((Object)("ClientSessionDataManager put the ClientSessionData for user-" + username + " into ClientSessionDataByUsername Map"));
                }
            } else {
                String currentSessionId;
                log.debug((Object)("ClientSessionDataManager got the ClientSessionData for user-" + username + " from ClientSessionDataByUsername Map"));
                data.setLastInteraction(accessType);
                if (!this.allowMultipleLogins && (currentSessionId = data.getSessionId()) != null && !currentSessionId.equals(session.getId())) {
                    sessionToInvalidate = data.getSession();
                    log.debug((Object)("ClientSessionDataManager remove ClientSessionData-" + currentSessionId + " from ClientSessionDataById Map"));
                    this.clientSessionsBySessionId.remove(currentSessionId);
                    data.setSessionDetails(session);
                }
                this.clientSessionsBySessionId.put(session.getId(), data);
                log.debug((Object)("ClientSessionDataManager put the ClientSessionData-" + session.getId() + " into ClientSessionDataById Map"));
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (sessionToInvalidate != null) {
                this.invalidateOldSession(sessionToInvalidate, username);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent se) {
        if (se == null) {
            return;
        }
        HttpSession session = se.getSession();
        if (session == null) {
            log.error((Object)("Session was created but no session details given. HttpSessionEvent Source:" + (se.getSource() != null ? se.getSource().toString() : "null")));
            return;
        }
        log.debug((Object)("Session created " + session.getId()));
        String string = LOCK_NAME;
        synchronized (LOCK_NAME) {
            ClientSessionData data = (ClientSessionData)this.clientSessionsBySessionId.get(session.getId());
            if (data != null) {
                log.error((Object)("HttpSessionListener reports session (id=" + session.getId() + ") just created, but we already have a record of that id. " + " Something may be seriously wrong. Deleting the old user session record" + " but this may cause odd errors on the progress interface. Current details" + " for this session id are " + data.toString()));
                this.clientSessionsBySessionId.remove(session.getId());
                this.clientSessionsByUsername.remove(data.getUsername());
                data = null;
            }
            data = new ClientSessionData(session);
            this.clientSessionsBySessionId.put(data.getSessionId(), data);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        if (se == null) {
            return;
        }
        HttpSession session = se.getSession();
        if (session == null) {
            log.error((Object)("Session was destroyed but no session details given. HttpSessionEvent Source:" + (se.getSource() != null ? se.getSource().toString() : "null")));
            return;
        }
        ClientSessionData data = null;
        String string = LOCK_NAME;
        synchronized (LOCK_NAME) {
            log.debug((Object)("ClientSessionDataManager is trying to get the ClientSessionData-" + session.getId() + " from ClientSessionDataById Map"));
            data = (ClientSessionData)this.clientSessionsBySessionId.get(session.getId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session destroyed id=" + session.getId() + " username " + (data != null ? data.getUsername() : "unknown")));
            }
            if (data != null) {
                log.debug((Object)("ClientSessionDataManager is trying to remove the ClientSessionData-" + session.getId() + " from ClientSessionDataById Map"));
                this.clientSessionsBySessionId.remove(session.getId());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (data != null) {
                if (data.getUsername() != null) {
                    log.debug((Object)("ClientSessionDataManager set HttpSession of ClientSessionData for user-" + data.getUsername() + " to null"));
                    data.setSessionDetails(null);
                } else {
                    log.debug((Object)"ClientSessionDataManager set ClientSessionData to null");
                    data = null;
                }
            }
            return;
        }
    }

    public void invalidateOldSession(HttpSession session, String username) {
        log.info((Object)("Invalidating an older session for user " + username + " as the user has logged in again"));
        session.invalidate();
    }

    public void cleanupOldSessions(long timeSinceCreation) {
        long numObjectsDeleted = 0L;
        long checkTime = System.currentTimeMillis() - timeSinceCreation;
        if (checkTime <= 0L) {
            log.error((Object)("cleanupOldSessions: time for cleanup is negative or zero. Unable to clean up. Input value was " + timeSinceCreation + " check time calculated as " + checkTime));
            return;
        }
        Iterator iter = this.clientSessionsByUsername.values().iterator();
        while (iter.hasNext()) {
            ClientSessionData element = (ClientSessionData)iter.next();
            if (element.getSession() != null || element.getSessionCreationTime() != null && element.getSessionCreationTime() >= checkTime) continue;
            iter.remove();
            element = null;
            ++numObjectsDeleted;
        }
        log.info((Object)("cleanupOldSessions: deleted " + numObjectsDeleted + " session details more than a week old"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

