/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.tool.grouping;

import com.webmcq.ld.content.GroupingDefnContent;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.tool.grouping.Group;
import com.webmcq.ld.controller.tool.grouping.GroupingAlgorithm;
import com.webmcq.ld.controller.tool.grouping.RandomGrouping;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.tool.ToolException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Grouping {
    private long sid;
    private long taskInstanceId;
    private String mainGroupName;
    private long groupingId;
    private long definitionId;
    private String outputDestination;
    private List memberGroups;
    private GroupingAlgorithm grouper;

    private Grouping() {
    }

    public Grouping(long taskInstanceId, String mainGroupName, long groupingId, long definitionId, String outputDestination) {
        this.taskInstanceId = taskInstanceId;
        this.mainGroupName = mainGroupName;
        this.groupingId = groupingId;
        this.definitionId = definitionId;
        this.outputDestination = outputDestination;
        this.memberGroups = new ArrayList();
    }

    public boolean isMember(long userId) {
        for (int i = 0; i < this.memberGroups.size(); ++i) {
            Group group = (Group)this.memberGroups.get(i);
            if (!group.isMember(userId)) continue;
            return true;
        }
        return false;
    }

    public Group getGroup(long userId) {
        for (int i = 0; i < this.memberGroups.size(); ++i) {
            Group group = (Group)this.memberGroups.get(i);
            if (!group.isMember(userId)) continue;
            return group;
        }
        return null;
    }

    public void doGrouping(List users) throws ToolException {
        this.getGrouper().doGrouping(this, this.getDefinition(), users);
    }

    public GroupingAlgorithm getGrouper() {
        if (this.grouper == null) {
            this.grouper = new RandomGrouping();
        }
        return this.grouper;
    }

    public int getNumberOfGroups() {
        return this.memberGroups.size();
    }

    public void addGroup(Group group) {
        this.memberGroups.add(group);
    }

    public Iterator getGroups() {
        return this.memberGroups.iterator();
    }

    public GroupingDefnContent getDefinition() throws ToolException {
        try {
            GroupingDefnContent content = (GroupingDefnContent)ContentServiceDelegate.getContent(this.definitionId);
            if (content == null) {
                throw new ToolException("grouping definition (content '" + this.definitionId + " ') not found: null");
            }
            return content;
        }
        catch (ControllerException e) {
            throw new ToolException(e);
        }
    }

    public List getMemberGroups() {
        return this.memberGroups;
    }

    public long getSid() {
        return this.sid;
    }

    public long getTaskInstanceId() {
        return this.taskInstanceId;
    }

    private void setMemberGroups(List list) {
        this.memberGroups = list;
    }

    private void setSid(long l) {
        this.sid = l;
    }

    private void setTaskInstanceId(long l) {
        this.taskInstanceId = l;
    }

    public String getMainGroupName() {
        return this.mainGroupName;
    }

    private void setMainGroupName(String string) {
        this.mainGroupName = string;
    }

    public long getDefinitionId() {
        return this.definitionId;
    }

    private void setDefinitionId(long l) {
        this.definitionId = l;
    }

    public String getOutputDestination() {
        return this.outputDestination;
    }

    private void setOutputDestination(String string) {
        this.outputDestination = string;
    }

    public long getGroupingId() {
        return this.groupingId;
    }

    private void setGroupingId(long l) {
        this.groupingId = l;
    }
}

