/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.session;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.MultiTask;
import com.webmcq.ld.controller.OptionalTask;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceDAO;
import com.webmcq.ld.controller.design.LearningDesign;
import com.webmcq.ld.controller.session.TaskInstanceFactory;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.Iterator;

public class LearningDesignSession {
    private LearningDesign learningDesign;
    private LearningSession learningSession;

    public LearningDesignSession(LearningDesign learningDesign, LearningSession learningSession) {
        this.learningDesign = learningDesign;
        this.learningSession = learningSession;
    }

    public void init(PersistenceSession sess) throws ControllerException {
        Task task = this.learningDesign.nextTask(null, sess);
        TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
        while (task != null) {
            this.initTask(task, sess, tiDao);
            task = this.learningDesign.nextTask(task);
        }
    }

    private void initTask(Task task, PersistenceSession sess, TaskInstanceDAO tiDao) throws ControllerException, SystemException {
        switch (task.getType()) {
            case 2: {
                MultiTask multitask = (MultiTask)task;
                TaskInstanceFactory.initMultiTask(this.learningSession, multitask, sess, tiDao);
                break;
            }
            case 5: {
                OptionalTask optiontask = (OptionalTask)task;
                TaskInstanceFactory.initOptionalTask(this.learningSession, optiontask, sess, tiDao);
                break;
            }
            case 1: {
                TaskInstanceFactory.initSimpleTask(this.learningSession, task, sess, tiDao);
                break;
            }
            case 4: {
                TaskInstanceFactory.initGroupingTask(this.learningSession, task, sess, tiDao);
                break;
            }
            case 3: {
                TaskInstanceFactory.initSyncTask(this.learningSession, task, sess, tiDao);
                break;
            }
        }
    }

    private void initTask(Task task) throws ControllerException, SystemException {
        switch (task.getType()) {
            case 2: {
                MultiTask multitask = (MultiTask)task;
                this.initTask(multitask.getTask1());
                this.initTask(multitask.getTask2());
                break;
            }
            case 5: {
                OptionalTask optiontask = (OptionalTask)task;
                Iterator i = optiontask.getSubTasks().iterator();
                while (i.hasNext()) {
                    this.initTask((Task)i.next());
                }
                break;
            }
            case 1: {
                if (task.isGroupTask()) break;
                TaskInstanceFactory.initTask(this.learningSession, task);
                break;
            }
        }
    }

    public void init() throws ControllerException {
        Task task = this.learningDesign.nextTask(null);
        while (task != null) {
            this.initTask(task);
            task = this.learningDesign.nextTask(task);
        }
    }

    public TaskInstance getTaskInstance(PersistenceSession sess, Task task, Learner learner) throws ControllerException {
        return TaskInstanceFactory.createTaskInstance(sess, this.learningSession, task, learner);
    }
}

