/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.learner;

import com.webmcq.ld.controller.SimpleMessage;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WorkSpace {
    private long sid;
    private long userId;
    private String username;
    private List messagesToSend;

    private WorkSpace() {
    }

    public WorkSpace(String username, long userId) {
        this.sid = -1L;
        this.userId = userId;
        this.username = username;
        this.messagesToSend = new ArrayList();
    }

    public void addMessage(SimpleMessage msg) {
        this.messagesToSend.add(msg);
    }

    public long getSid() {
        return this.sid;
    }

    public long getUserId() {
        return this.userId;
    }

    public ShwaaUserData getUser() {
        try {
            return UserServiceDelegate.find(this.userId);
        }
        catch (UserNotFoundException e) {
            return null;
        }
    }

    private void setSid(long sid) {
        this.sid = sid;
    }

    private void setUserId(long userId) {
        this.userId = userId;
    }

    public List getMessagesToSend() {
        return this.messagesToSend;
    }

    public SimpleMessage getMessageToSend() {
        if (this.messagesToSend.size() != 0) {
            return (SimpleMessage)this.messagesToSend.remove(0);
        }
        return null;
    }

    public SimpleMessage getMessageToSend(long sessionId) {
        Iterator iter = this.messagesToSend.iterator();
        while (iter.hasNext()) {
            SimpleMessage msg = (SimpleMessage)iter.next();
            if (msg.getSessionId() != sessionId) continue;
            this.messagesToSend.remove(msg);
            return msg;
        }
        return null;
    }

    public void setMessagesToSend(List messagesToSend) {
        this.messagesToSend = messagesToSend;
    }

    public String toString() {
        return "<WorkSpace>sid: '" + this.sid + "' '" + this.username + "'</WorkSpace>";
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

