/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.dto;

import javax.servlet.http.HttpSession;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class ClientSessionData {
    private static Logger log = Logger.getLogger((String)(class$com$webmcq$ld$controller$dto$ClientSessionData == null ? (class$com$webmcq$ld$controller$dto$ClientSessionData = ClientSessionData.class$("com.webmcq.ld.controller.dto.ClientSessionData")) : class$com$webmcq$ld$controller$dto$ClientSessionData).getName());
    public static int inactiveTimeout = 90000;
    public static final int STATUS_NO_SESSION = 0;
    public static final int STATUS_INACTIVE = 1;
    public static final int STATUS_ACTIVE = 2;
    public static final String POLL_INTERACTION = "Poll";
    public static final String REQUEST_LEARNER_INTERACTION = "Request Learner Client";
    public static final String REQUEST_MONITOR_INTERACTION = "Request Monitor Client";
    public static final String REQUEST_AUTHOR_INTERACTION = "Request Author Client";
    private String username = null;
    private long userID;
    private Long lastApplicationInteractionTime = null;
    private String lastApplicationInteractionDescription = null;
    private HttpSession session = null;
    private Long sessionCreationTime = null;
    private String sessionId = null;
    static /* synthetic */ Class class$com$webmcq$ld$controller$dto$ClientSessionData;

    public ClientSessionData(HttpSession session, String username, long uid, String interactionType) {
        this.session = session;
        this.sessionCreationTime = new Long(session.getCreationTime());
        this.sessionId = session.getId();
        this.username = username;
        this.userID = uid;
        this.lastApplicationInteractionTime = new Long(System.currentTimeMillis());
        this.lastApplicationInteractionDescription = interactionType;
    }

    public ClientSessionData(HttpSession session) {
        this.session = session;
        this.sessionCreationTime = new Long(session.getCreationTime());
        this.sessionId = session.getId();
    }

    public String getLastInteractionDescription() {
        return this.lastApplicationInteractionDescription;
    }

    public Long getLastApplicationInteractionTime() {
        return this.lastApplicationInteractionTime;
    }

    public String getUsername() {
        return this.username;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Long getSessionCreationTime() {
        return this.sessionCreationTime;
    }

    public Long getLastAccessedTime() {
        if (this.session != null) {
            return new Long(this.session.getLastAccessedTime());
        }
        return null;
    }

    public int getActiveStatus() {
        int retValue = 2;
        if (this.session == null) {
            retValue = 0;
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime > this.session.getLastAccessedTime() + (long)inactiveTimeout) {
                retValue = 1;
            }
        }
        return retValue;
    }

    public static int getInactiveTimeout() {
        return inactiveTimeout;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static void setInactiveTimeout(int inactiveTimeout) {
        log.debug((Object)("Setting inactive timeout to " + inactiveTimeout));
        ClientSessionData.inactiveTimeout = inactiveTimeout;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setSessionDetails(HttpSession session) {
        this.session = session;
        if (session != null) {
            this.sessionCreationTime = new Long(session.getCreationTime());
            this.sessionId = session.getId();
        }
    }

    public void setLastInteraction(String lastInteractionDescription) {
        if (lastInteractionDescription != null) {
            this.lastApplicationInteractionDescription = lastInteractionDescription;
            this.lastApplicationInteractionTime = new Long(System.currentTimeMillis());
        } else {
            this.lastApplicationInteractionDescription = null;
            this.lastApplicationInteractionTime = null;
        }
    }

    private void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    private void setLastInteractionDescription(String lastInteractionDescription) {
        this.lastApplicationInteractionDescription = lastInteractionDescription;
    }

    private void setLastApplicationInteractionTime(Long lastInteractionTime) {
        this.lastApplicationInteractionTime = lastInteractionTime;
    }

    private void setSessionCreationTime(Long sessionCreationTime) {
        this.sessionCreationTime = sessionCreationTime;
    }

    private void setSession(HttpSession session) {
        this.session = session;
    }

    public long getUserID() {
        return this.userID;
    }

    public void setUserID(long uid) {
        this.userID = uid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

