/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.design;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.activities.LDActItem;
import com.webmcq.ld.activities.LearningDesignDefnVO;
import com.webmcq.ld.activities.OptionalActivityDefnVO;
import com.webmcq.ld.activities.runtime.LDRuntimeServiceException;
import com.webmcq.ld.activities.runtime.interfaces.LDRuntimeService;
import com.webmcq.ld.activities.runtime.interfaces.LDRuntimeServiceHome;
import com.webmcq.ld.activities.runtimeaccess.RuntimeServiceDelegate;
import com.webmcq.ld.activities.runtimeaccess.builder.BuilderException;
import com.webmcq.ld.activities.runtimeaccess.tree.DesignItem;
import com.webmcq.ld.controller.AbstractActivity;
import com.webmcq.ld.controller.Activity;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.LearningSessionException;
import com.webmcq.ld.controller.OptionalActivity;
import com.webmcq.ld.controller.SingleActivity;
import com.webmcq.ld.controller.design.LearningDesignException;
import com.webmcq.ld.util.EJBHomeFactory;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class LearningDesignServiceDelegate {
    static /* synthetic */ Class class$com$webmcq$ld$activities$runtime$interfaces$LDRuntimeServiceHome;

    public static LearningDesignDefnVO findLearningDesign(int ldId) throws ControllerException {
        try {
            RuntimeServiceDelegate delegate = new RuntimeServiceDelegate();
            DesignItem item = delegate.getLearningDesign(ldId);
            if (item != null) {
                return (LearningDesignDefnVO)item.getPersistedItem();
            }
            return null;
        }
        catch (BuilderException e) {
            throw new ControllerException("learning design definition '" + ldId + "' not accessable");
        }
    }

    public static Activity getActivity(AbstractTaskVO task) throws ControllerException {
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            LDActItem defn = service.getActivityContainingTask(task);
            LearningDesignServiceDelegate.remove(service);
            if (defn == null) {
                return null;
            }
            if (defn instanceof ActivityDefnVO) {
                SingleActivity singleAct = new SingleActivity(0L, (ActivityDefnVO)defn);
                return singleAct;
            }
            if (defn instanceof OptionalActivityDefnVO) {
                OptionalActivity optAct = new OptionalActivity(0L, (OptionalActivityDefnVO)defn);
                return optAct;
            }
            return null;
        }
        catch (LDRuntimeServiceException e) {
            throw new ControllerException(e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public static void setLearningDesignAsUsed(long learningDesignId) throws ControllerException {
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            service.setLearningDesignAsUsed(new Long(learningDesignId));
            LearningDesignServiceDelegate.remove(service);
        }
        catch (LDRuntimeServiceException e) {
            throw new ControllerException(e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public static Vector getNextTaskSet(long LDId, AbstractTaskVO task) throws ControllerException {
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            Vector tasks = service.getNextTask((int)LDId, task);
            LearningDesignServiceDelegate.remove(service);
            return tasks;
        }
        catch (LDRuntimeServiceException e) {
            throw new ControllerException(e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public static Vector getNextTaskSet(long LDId, AbstractTaskVO task, PersistenceSession sess) throws ControllerException {
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            Vector tasks = service.getNextTask((int)LDId, task, sess);
            LearningDesignServiceDelegate.remove(service);
            return tasks;
        }
        catch (LDRuntimeServiceException e) {
            throw new ControllerException(e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public static Vector getNextTaskSetFromOptional(long LDId, AbstractTaskVO task) throws ControllerException {
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            Vector tasks = service.getNextTaskAfterInternals((int)LDId, task);
            LearningDesignServiceDelegate.remove(service);
            return tasks;
        }
        catch (LDRuntimeServiceException e) {
            throw new ControllerException(e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public static Vector getNextTaskSetFromOptional(long LDId, AbstractTaskVO task, PersistenceSession sess) throws ControllerException {
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            Vector tasks = service.getNextTaskAfterInternals((int)LDId, task, sess);
            LearningDesignServiceDelegate.remove(service);
            return tasks;
        }
        catch (LDRuntimeServiceException e) {
            throw new ControllerException(e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public static AbstractTaskVO getTask(long taskId) {
        AbstractTaskVO returnTask = null;
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            returnTask = service.getTask(new Long(taskId));
            LearningDesignServiceDelegate.remove(service);
        }
        catch (Exception e) {
            throw new EJBException("Error finding the task " + taskId, e);
        }
        return returnTask;
    }

    public static Activity[] getFutureActivities(long ldId, Activity currentActivity) throws ControllerException {
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            ArrayList activities = null;
            activities = currentActivity == null ? service.getAllActs(ldId) : service.getFutureActs(ldId, currentActivity.getSid());
            LearningDesignServiceDelegate.remove(service);
            return LearningDesignServiceDelegate.convert(ldId, activities);
        }
        catch (LDRuntimeServiceException e) {
            throw new ControllerException(e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public static Activity getNextActivity(long ldid, Activity activty) throws LearningDesignException, SystemException {
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            LDActItem ldAct = activty == null ? service.getFirstActivity((int)ldid) : service.getActAfterAct(ldid, activty.getSid());
            AbstractActivity nextAct = null;
            if (ldAct != null) {
                if (ldAct instanceof ActivityDefnVO) {
                    nextAct = new SingleActivity(ldid, (ActivityDefnVO)ldAct);
                } else if (ldAct instanceof OptionalActivityDefnVO) {
                    nextAct = new OptionalActivity(ldid, (OptionalActivityDefnVO)ldAct);
                } else {
                    throw new LearningDesignException("unexpected LDActItem type: '" + ldAct.getClass() + "'");
                }
            }
            LearningDesignServiceDelegate.remove(service);
            return nextAct;
        }
        catch (LDRuntimeServiceException e) {
            throw new LearningDesignException(e);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    private static Activity[] convert(long ldid, List activities) throws ControllerException {
        ArrayList<AbstractActivity> converted = new ArrayList<AbstractActivity>();
        Iterator iter = activities.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof ActivityDefnVO) {
                converted.add(new SingleActivity(ldid, (ActivityDefnVO)obj));
                continue;
            }
            if (obj instanceof OptionalActivityDefnVO) {
                converted.add(new OptionalActivity(ldid, (OptionalActivityDefnVO)obj));
                continue;
            }
            throw new ControllerException("unknown activity type: " + obj);
        }
        return converted.toArray(new Activity[0]);
    }

    public static ActivityDefnVO getActivity(long id) throws LearningSessionException, SystemException {
        try {
            LDRuntimeService service = LearningDesignServiceDelegate.getService();
            ActivityDefnVO activity = service.getActivity(new Long(id));
            LearningDesignServiceDelegate.remove(service);
            return activity;
        }
        catch (LDRuntimeServiceException e) {
            throw new LearningSessionException(e);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    private static LDRuntimeService getService() {
        try {
            LDRuntimeServiceHome home = (LDRuntimeServiceHome)EJBHomeFactory.getInstance().lookup("ejb/activities/LDRuntimeService", class$com$webmcq$ld$activities$runtime$interfaces$LDRuntimeServiceHome == null ? (class$com$webmcq$ld$activities$runtime$interfaces$LDRuntimeServiceHome = LearningDesignServiceDelegate.class$("com.webmcq.ld.activities.runtime.interfaces.LDRuntimeServiceHome")) : class$com$webmcq$ld$activities$runtime$interfaces$LDRuntimeServiceHome);
            return home.create();
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private static void remove(LDRuntimeService service) {
        try {
            service.remove();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

