/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.dao;

import com.webmcq.ld.controller.learner.WorkSpace;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.BaseDAO;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.sql.SQLException;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Logger;

public class WorkSpaceDAO
extends BaseDAO {
    private final String TABLENAME = "c_workspace";
    private static Logger log = Logger.getLogger((String)(class$com$webmcq$ld$controller$dao$WorkSpaceDAO == null ? (class$com$webmcq$ld$controller$dao$WorkSpaceDAO = WorkSpaceDAO.class$("com.webmcq.ld.controller.dao.WorkSpaceDAO")) : class$com$webmcq$ld$controller$dao$WorkSpaceDAO).getName());
    static /* synthetic */ Class class$com$webmcq$ld$controller$dao$WorkSpaceDAO;

    public WorkSpaceDAO(PersistenceSession sess) {
        super(sess);
    }

    public void update(WorkSpace workspace) throws SystemException {
        super.update(workspace, workspace.getSid());
    }

    public WorkSpace findByUser(long userId) throws UserNotFoundException, SystemException {
        try {
            log.debug((Object)("Looking for workspace for user " + userId));
            String SELECTBYUSERID = "from c_workspace in class com.webmcq.ld.controller.learner.WorkSpace where c_workspace.userId = ?";
            List list = this.sess.persistece().find(SELECTBYUSERID, (Object)new Long(userId), (Type)Hibernate.LONG);
            if (list.size() == 0) {
                return this.createWorkspaceForValidUser(userId);
            }
            return (WorkSpace)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    public WorkSpace findByUser(String username) throws UserNotFoundException, SystemException {
        try {
            log.debug((Object)("Looking for workspace for user " + username));
            String SELECTBYUSERID = "from c_workspace in class com.webmcq.ld.controller.learner.WorkSpace where c_workspace.username = ?";
            List list = this.sess.persistece().find(SELECTBYUSERID, (Object)username, (Type)Hibernate.STRING);
            if (list.size() == 0) {
                return this.createWorkspaceForValidUser(username);
            }
            return (WorkSpace)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    private WorkSpace createWorkspaceForValidUser(long userId) throws SQLException, HibernateException, UserNotFoundException {
        ShwaaUserData user = UserServiceDelegate.find(userId);
        return this.createWorkspaceForValidUser(user);
    }

    private WorkSpace createWorkspaceForValidUser(String username) throws SQLException, HibernateException, UserNotFoundException {
        ShwaaUserData user = UserServiceDelegate.find(username);
        return this.createWorkspaceForValidUser(user);
    }

    private WorkSpace createWorkspaceForValidUser(ShwaaUserData user) throws SQLException, HibernateException, UserNotFoundException {
        WorkSpace workspace = new WorkSpace(user.getLogin(), user.getUid());
        this.sess.persistece().save((Object)workspace);
        log.debug((Object)("new workspace is " + workspace));
        return workspace;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

