/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.dao;

import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.dao.LearnerDAO;
import com.webmcq.ld.controller.dao.LearningSessionNotFoundException;
import com.webmcq.ld.controller.dto.LearningSessionData;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.BaseDAO;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Logger;

public class LearningSessionDAO
extends BaseDAO {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$dao$LearningSessionDAO == null ? (class$com$webmcq$ld$controller$dao$LearningSessionDAO = LearningSessionDAO.class$("com.webmcq.ld.controller.dao.LearningSessionDAO")) : class$com$webmcq$ld$controller$dao$LearningSessionDAO));
    static /* synthetic */ Class class$com$webmcq$ld$controller$dao$LearningSessionDAO;
    static /* synthetic */ Class class$com$webmcq$ld$controller$LearningSession;

    public LearningSessionDAO() {
    }

    public LearningSessionDAO(PersistenceSession sess) {
        super(sess);
    }

    public void insert(LearningSession lsession) throws SystemException {
        try {
            super.update(lsession);
        }
        catch (JDBCException e) {
            throw new SystemException(e);
        }
    }

    public void update(LearningSession lsession) throws SystemException {
        try {
            super.update(lsession);
        }
        catch (JDBCException e) {
            throw new SystemException(e);
        }
    }

    public void updateCurrentLearningSession(LearningSession lsession) throws JDBCException {
        try {
            super.update(lsession);
        }
        catch (JDBCException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("JDBC Exception occured: Error Code[" + e.getErrorCode() + "]" + (Object)((Object)e)));
            }
            throw e;
        }
    }

    public List findAll() throws SystemException {
        List list = super.findAll(class$com$webmcq$ld$controller$LearningSession == null ? (class$com$webmcq$ld$controller$LearningSession = LearningSessionDAO.class$("com.webmcq.ld.controller.LearningSession")) : class$com$webmcq$ld$controller$LearningSession);
        log.debug((Object)(list.size() + " learning sessions found"));
        return list;
    }

    public LearningSession find(long lsessionId) throws LearningSessionNotFoundException, SystemException {
        LearningSession lsess = (LearningSession)super.find(class$com$webmcq$ld$controller$LearningSession == null ? (class$com$webmcq$ld$controller$LearningSession = LearningSessionDAO.class$("com.webmcq.ld.controller.LearningSession")) : class$com$webmcq$ld$controller$LearningSession, lsessionId);
        if (lsess == null) {
            throw new LearningSessionNotFoundException(lsessionId);
        }
        log.debug((Object)("learning session found: '" + lsess.getSid() + "'"));
        return lsess;
    }

    public List findByOwner(long ownerId) throws SystemException {
        return this.findByOwner(ownerId, 0);
    }

    public List findByOwner(long ownerId, int archived) throws SystemException {
        try {
            List list = this.sess.persistece().find("from lsess in class com.webmcq.ld.controller.LearningSession where lsess.ownerId = ? and lsess.archived = ?  order by lsess.sid asc", new Object[]{new Long(ownerId), new Integer(archived)}, new Type[]{Hibernate.LONG, Hibernate.INTEGER});
            log.debug((Object)("learning sessions found: '" + list.size() + "'"));
            return list;
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public List findByUser(long userId) throws SystemException {
        LearnerDAO dao = new LearnerDAO(this.sess);
        ArrayList<LearningSession> sessions = new ArrayList<LearningSession>();
        List learnerEntries = dao.find(userId);
        if (learnerEntries.size() > 0) {
            Iterator iterator = learnerEntries.iterator();
            while (iterator.hasNext()) {
                Learner learner = (Learner)iterator.next();
                sessions.add(learner.getLearningSession());
            }
        }
        return sessions;
    }

    private List findByOrganisation(PersistenceSession session, long orgId, int status, int archived) throws SystemException {
        try {
            List list = session.persistece().find("from lsess in class com.webmcq.ld.controller.LearningSession where lsess.organisationId = ? and lsess.status = ? and lsess.archived = ?", new Object[]{new Long(orgId), new Integer(status), new Integer(archived)}, new Type[]{Hibernate.LONG, Hibernate.INTEGER, Hibernate.INTEGER});
            session.flush();
            log.debug((Object)("findByOrganisation: learning sessions found: '" + list.size() + "'"));
            return list;
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByOrganisation(long[] orgIds, int status, int archived) throws SystemException {
        PersistenceSession sessPrv = null;
        try {
            sessPrv = new PersistenceSession();
            ArrayList list = new ArrayList();
            for (int i = 0; i < orgIds.length; ++i) {
                list.addAll(this.findByOrganisation(sessPrv, orgIds[i], status, archived));
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            sessPrv.close();
        }
    }

    private LearningSessionData buildLearningSessionData(ResultSet rs) throws SQLException {
        LearningSessionData oneLsData = new LearningSessionData();
        oneLsData.setSid(rs.getLong(1));
        oneLsData.setTitle(rs.getString(2));
        oneLsData.setDescription(rs.getString(3));
        oneLsData.setStatus(rs.getInt(4));
        oneLsData.setOrganisationId(rs.getLong(5));
        oneLsData.setStartedTime(rs.getTimestamp(6));
        oneLsData.setArchived(rs.getInt(7));
        oneLsData.setLearningDesignId(rs.getLong(8));
        oneLsData.setAvailable(rs.getBoolean(9));
        oneLsData.setLearnerCount(0);
        return oneLsData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LearningSessionData[] findByOrganisation(Session sess, long userId, int status, int archived) throws SystemException, HibernateException, NamingException {
        LearningSessionData[] listLearningSessionData = new LearningSessionData[]{};
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String queryString = "select a.sid, a.title, a.description, a.status, a.organisation_id, a.started_time, a.archived, a.learning_design_id, a.available from u_user_organisation b, u_organisation c, c_learning_session a where b.user_id=? and c.account_organisation=0 and c.sid = b.organisation_id and c.sid = a.organisation_id and a.status=? and a.archived=?";
        try {
            try {
                conn = sess.connection();
                stmt = conn.prepareStatement(queryString);
                stmt.setLong(1, userId);
                stmt.setInt(2, status);
                stmt.setInt(3, archived);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    rs.last();
                    int numberOfId = rs.getRow();
                    listLearningSessionData = new LearningSessionData[numberOfId];
                    rs.first();
                    int iIndex = 0;
                    listLearningSessionData[iIndex] = this.buildLearningSessionData(rs);
                    while (rs.next()) {
                        listLearningSessionData[++iIndex] = this.buildLearningSessionData(rs);
                    }
                }
                Object var14_14 = null;
            }
            catch (HibernateException eHi) {
                throw new SystemException(eHi);
            }
            catch (SQLException sqle) {
                throw new SystemException(sqle);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException sqle2) {
                throw new SystemException(sqle2);
            }
        }
        try {}
        catch (SQLException sqle2) {
            throw new SystemException(sqle2);
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt == null) return listLearningSessionData;
        stmt.close();
        return listLearningSessionData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] findSessionOrganisationsId(long userId) throws SystemException {
        long[] orgId = new long[1];
        PersistenceSession sess = new PersistenceSession();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String queryString = "select c.sid from u_user_organisation b, u_organisation c where b.user_id=? and c.account_organisation=0 and c.sid = b.organisation_id";
        try {
            try {
                conn = sess.persistece().connection();
                stmt = conn.prepareStatement(queryString);
                stmt.setLong(1, userId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    rs.last();
                    int numberOfId = rs.getRow();
                    orgId = new long[numberOfId];
                    rs.first();
                    int iIndex = 0;
                    orgId[iIndex] = rs.getLong(1);
                    while (rs.next()) {
                        orgId[++iIndex] = rs.getLong(1);
                    }
                }
                sess.flush();
            }
            catch (HibernateException eHi) {
                throw new SystemException(eHi);
            }
            catch (SQLException sqle) {
                throw new SystemException(sqle);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                sess.close();
                throw throwable;
            }
            catch (SQLException sqle2) {
                throw new SystemException(sqle2);
            }
        }
        try {}
        catch (SQLException sqle2) {
            throw new SystemException(sqle2);
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        sess.close();
        return orgId;
    }

    public void remove(long learningSessionId) throws SystemException {
        super.remove(class$com$webmcq$ld$controller$LearningSession == null ? (class$com$webmcq$ld$controller$LearningSession = LearningSessionDAO.class$("com.webmcq.ld.controller.LearningSession")) : class$com$webmcq$ld$controller$LearningSession, learningSessionId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

