/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.SingleTaskInstance;
import com.webmcq.ld.controller.SyncPoint;
import com.webmcq.ld.controller.SyncTask;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.design.TaskManager;
import com.webmcq.ld.controller.learner.Group;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SyncTaskInstance
extends SingleTaskInstance {
    private String syncType;
    private Long staffId;
    private SyncPoint syncPoint;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$SyncTaskInstance == null ? (class$com$webmcq$ld$controller$SyncTaskInstance = SyncTaskInstance.class$("com.webmcq.ld.controller.SyncTaskInstance")) : class$com$webmcq$ld$controller$SyncTaskInstance));
    static /* synthetic */ Class class$com$webmcq$ld$controller$SyncTaskInstance;

    private SyncTaskInstance() {
    }

    public SyncTaskInstance(LearningSession lsession, Group group, SyncTask task) {
        super(lsession, group, task);
        this.syncType = task.getSyncType();
        this.syncPoint = "synchronize_both".equals(task.getSyncType()) ? new SyncPoint(true, true) : ("synchronize_teacher".equals(task.getSyncType()) ? new SyncPoint(false, true) : new SyncPoint(true, false));
    }

    public Task getTask() {
        return TaskManager.getSyncTask(this.getTaskSid());
    }

    public boolean isConditionMet() {
        if (this.syncPoint.isTeacherSyncOn()) {
            return false;
        }
        return !this.syncPoint.isClassSyncOn() || this.getParticipants().size() >= this.getGroup().size();
    }

    public Long getStaffId() {
        return this.staffId;
    }

    public String getSyncType() {
        return this.syncType;
    }

    private void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    public void setSyncType(String syncType) {
        this.syncType = syncType;
    }

    public SyncPoint getSyncPoint() {
        return this.syncPoint;
    }

    private void setSyncPoint(SyncPoint point) {
        this.syncPoint = point;
    }

    public void turnTeacherSyncOff(long userId) {
        this.syncPoint.setTeacherSyncOn(false);
        this.setStaffId(new Long(userId));
    }

    public void turnClassSyncOff() {
        this.syncPoint.setClassSyncOn(false);
    }

    public boolean isClassSyncPoint() {
        if ("synchronize_both".equals(this.syncType)) {
            return true;
        }
        return "synchronize".equals(this.syncType);
    }

    public boolean isTeacherSyncPoint() {
        if ("synchronize_both".equals(this.syncType)) {
            return true;
        }
        return "synchronize_teacher".equals(this.syncType);
    }

    public DisplayTaskData releaseLearners(PersistenceSession sess, long userId) throws ControllerException {
        DisplayTaskData displayTaskData = null;
        Iterator iter = this.getWaitingLearners().iterator();
        while (iter.hasNext()) {
            Learner learner = (Learner)iter.next();
            if (learner.getUserId() != userId) continue;
            this.complete(learner);
        }
        return displayTaskData;
    }

    private List getWaitingLearners() {
        ArrayList<Learner> learners = new ArrayList<Learner>();
        Iterator iter = this.getParticipants().keySet().iterator();
        while (iter.hasNext()) {
            Long userId = (Long)iter.next();
            Learner learner = this.getParticipant(userId);
            if (this.getCompletedLearners().contains(new Long(learner.getSid()))) continue;
            learners.add(learner);
        }
        log.debug((Object)("the number of waiting learners: " + learners.size()));
        return learners;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

