/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.GroupDefnVO;
import com.webmcq.ld.activities.GroupingTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.controller.Activity;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.design.LearningDesignServiceDelegate;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public abstract class AbstractTask
implements Task {
    private AbstractTaskVO task;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$Task == null ? (class$com$webmcq$ld$controller$Task = AbstractTask.class$("com.webmcq.ld.controller.Task")) : class$com$webmcq$ld$controller$Task));
    static /* synthetic */ Class class$com$webmcq$ld$controller$Task;

    public AbstractTask(AbstractTaskVO task) {
        this.task = task;
    }

    public boolean isGroupTask() {
        Set taskGroups = this.task.getGroupsForTask();
        if (taskGroups == null || taskGroups.size() == 0) {
            log.debug((Object)"isGroupTask: class task detected");
            return false;
        }
        log.debug((Object)"isGroupTask: group task detected");
        return true;
    }

    public GroupDefnVO getGroupDefinition() throws ControllerException {
        if (!this.isGroupTask()) {
            throw new ControllerException("not a group task");
        }
        Set taskGroups = this.task.getGroupsForTask();
        return (GroupDefnVO)taskGroups.iterator().next();
    }

    public boolean isGroupingTask() {
        if (this.task instanceof GroupingTaskVO) {
            log.debug((Object)"isGroupingTask: grouping task detected");
            return true;
        }
        log.debug((Object)"isGroupingTask: not grouping task");
        return false;
    }

    public GroupDefnVO getGroupingDefinition() throws ControllerException {
        if (!this.isGroupingTask()) {
            throw new ControllerException("not a grouping task");
        }
        GroupingTaskVO grouping = (GroupingTaskVO)this.task;
        return grouping.getGroupDefn();
    }

    public long getSid() {
        return this.task.getSid();
    }

    public int getType() {
        return this.task.theTaskType();
    }

    public AbstractTaskVO getTask() {
        return this.task;
    }

    public long getContentId() throws ControllerException {
        try {
            SimpleTaskVO sTask = (SimpleTaskVO)this.task;
            return sTask.getInputContentSid();
        }
        catch (Exception e) {
            throw new ControllerException("failed to get content id: " + e.getMessage());
        }
    }

    public abstract boolean isSingleTask();

    public Long getInputContentId() throws ControllerException {
        throw new ControllerException("not supported");
    }

    public Long getOutputContentId() throws ControllerException {
        throw new ControllerException("not supported");
    }

    public String getTitle() {
        return this.getTask().getTitle();
    }

    public Activity getActivity() throws ControllerException {
        return LearningDesignServiceDelegate.getActivity(this.getTask());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("sid", (Object)this.task.getSid()).append("title", (Object)this.task.getTitle()).append("taskType", this.task.theTaskType()).append("objectType", (Object)this.task.theObjectType()).append("description", (Object)this.task.getDescription()).toString();
    }

    public long getNextTaskId() {
        return this.task.getNextTaskId();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

