/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.runtimeaccess.tree;

import com.webmcq.ld.activities.LdItem;
import com.webmcq.ld.activities.runtimeaccess.tree.DesignNode;
import com.webmcq.ld.activities.runtimeaccess.tree.IDesignItemAccess;
import com.webmcq.ld.activities.runtimeaccess.tree.TransitionLeaf;
import java.io.Serializable;
import java.lang.reflect.Method;

public abstract class DesignItem
implements Serializable,
IDesignItemAccess {
    static final long serialVersionUID = 7040341029969449024L;
    protected Long sid;
    protected String title;
    protected String description;
    protected LdItem persistedItem;
    protected DesignNode parent;
    protected TransitionLeaf followingTransition = null;

    public DesignItem(LdItem persistedItem, DesignNode parent) {
        if (persistedItem != null) {
            this.persistedItem = persistedItem;
            this.parent = parent;
            this.sid = persistedItem.getSid();
            this.title = this.reflectTitle(persistedItem);
            this.description = this.reflectDescription(persistedItem);
        }
    }

    public Long getSid() {
        return this.sid;
    }

    public LdItem getPersistedItem() {
        return this.persistedItem;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public Class getPersistedItemClass() {
        if (this.persistedItem != null) {
            return this.persistedItem.getClass();
        }
        return null;
    }

    public DesignNode getParent() {
        return this.parent;
    }

    public String toString() {
        return this.getClass().getName() + " title: " + this.getTitle() + " description: " + this.getDescription() + " persistedItem: " + (this.persistedItem != null ? this.persistedItem.toString() : "null");
    }

    public abstract boolean mayContainItems();

    public abstract void add(DesignItem var1);

    public abstract DesignItem remove(DesignItem var1);

    public abstract DesignItem remove(Long var1);

    public abstract DesignItem getChild(Long var1);

    public TransitionLeaf getFollowingTransition() {
        return this.followingTransition;
    }

    public void setFollowingTransition(TransitionLeaf followingTransition) {
        this.followingTransition = followingTransition;
    }

    private String reflectTitle(LdItem persistedItem) {
        try {
            Object[] parameterTypes = new Class[]{};
            Method call = persistedItem.getClass().getMethod("getTitle", (Class<?>[])parameterTypes);
            return (String)call.invoke((Object)persistedItem, parameterTypes);
        }
        catch (Exception e) {
            return "Unknown " + persistedItem.getClass().getName();
        }
    }

    private String reflectDescription(LdItem persistedItem) {
        try {
            Object[] parameterTypes = new Class[]{};
            Method call = persistedItem.getClass().getMethod("getDescription", (Class<?>[])parameterTypes);
            return (String)call.invoke((Object)persistedItem, parameterTypes);
        }
        catch (Exception e) {
            return "Unknown " + persistedItem.getClass().getName();
        }
    }
}

