/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.authoring;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.activities.GroupDefnVO;
import com.webmcq.ld.activities.GroupingTaskVO;
import com.webmcq.ld.activities.LearningDesignDefnVO;
import com.webmcq.ld.activities.LibraryDefnVO;
import com.webmcq.ld.activities.MultiTaskVO;
import com.webmcq.ld.activities.OptionalActivityDefnVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.activities.TransitionDefnVO;
import com.webmcq.ld.activities.authoring.ContentConverter;
import com.webmcq.ld.activities.authoring.ContentDelegate;
import com.webmcq.ld.activities.authoring.HashtableUtils;
import com.webmcq.ld.activities.dao.LearningDesignDefnDAO;
import com.webmcq.ld.activities.dao.LibraryDefnDAO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserMembershipData;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import net.sf.hibernate.HibernateException;
import org.apache.log4j.Logger;

public class LDWDDXValueObjectFactory {
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectFactory == null ? (class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectFactory = LDWDDXValueObjectFactory.class$("com.webmcq.ld.activities.authoring.LDWDDXValueObjectFactory")) : class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectFactory).getName());
    public static final Long NUMERIC_NULL_VALUE_LONG = new Long(-1L);
    public static final Integer NUMERIC_NULL_VALUE_INTEGER = new Integer(-1);
    static LDWDDXValueObjectFactory factory = null;
    private ContentDelegate contentUtil = null;
    private Map orgNames = new HashMap();
    static /* synthetic */ Class class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectFactory;

    private LDWDDXValueObjectFactory() {
    }

    public static LDWDDXValueObjectFactory getInstance() {
        if (factory == null) {
            factory = new LDWDDXValueObjectFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable newLearningDesignValueObject(Long ldId, UserData user) throws RuntimeException, EJBException, Exception {
        PersistenceSession session = new PersistenceSession();
        Hashtable result = null;
        LearningDesignDefnVO ld = null;
        try {
            try {
                ld = this.findLearningDesignVO(session, ldId);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to return activity sequence due to exception " + e.getMessage()), (Throwable)e);
                throw new Exception("Unable to return activity sequence" + e.getMessage());
            }
            if (ld == null) {
                throw new Exception("Activity sequence " + ldId + "not found");
            }
            if (!ld.hasReadAccess(user.getSid())) {
                throw new Exception("User does not have read access to the activity sequence " + ldId + ".");
            }
            result = this.buildLDValueObject(ld, user);
            session.flush();
            Hashtable hashtable = result;
            return hashtable;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private LearningDesignDefnVO findLearningDesignVO(PersistenceSession session, Long sid) throws Exception {
        logger.debug((Object)("Looking for learning design " + sid));
        LearningDesignDefnVO ld = null;
        LearningDesignDefnDAO ldDAO = new LearningDesignDefnDAO(session);
        ld = ldDAO.find(sid);
        return ld;
    }

    public List findAllLearningDesignVO(PersistenceSession session, boolean validOnly, Long userId, Long homeOrgId) throws Exception {
        List result = null;
        try {
            LearningDesignDefnDAO ldDAO = new LearningDesignDefnDAO(session);
            result = ldDAO.findAllLD(validOnly, userId, homeOrgId);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to list learning designs", (Throwable)e);
            throw new Exception("Unable to list learning designs: " + e.getMessage());
        }
        return result;
    }

    public List findAllLearningDesignVO(boolean validOnly, UserData user, Long homeOrgId) throws Exception {
        PersistenceSession session = new PersistenceSession();
        try {
            List designs;
            List list = designs = this.findAllLearningDesignVO(session, validOnly, user.getSid(), homeOrgId);
            return list;
        }
        catch (Exception e) {
            throw new FinderException(e.getMessage());
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable newLearningDesignListValueObject(boolean validOnly, UserData user, Long homeOrgId) throws RuntimeException, EJBException, Exception {
        Hashtable<String, Object> hashtable;
        block3: {
            PersistenceSession session = new PersistenceSession();
            try {
                List coll = this.findAllLearningDesignVO(session, validOnly, user.getSid(), homeOrgId);
                Hashtable<String, Object> ldValueObject = new Hashtable<String, Object>();
                ldValueObject.put("objectType", HashtableUtils.getValue("LearningDesignList"));
                Vector ldIdTitleList = new Vector();
                int i = 0;
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    LearningDesignDefnVO element = (LearningDesignDefnVO)iter.next();
                    Hashtable<String, Object> ldEntry = new Hashtable<String, Object>();
                    ldEntry.put("LDId", element.getSid());
                    ldEntry.put("description", HashtableUtils.getValue(element.getDescription()));
                    ldEntry.put("title", HashtableUtils.getValue(element.getTitle()));
                    this.processReadWriteAccess(ldEntry, element, user);
                    ldIdTitleList.add(ldEntry);
                    ++i;
                }
                ldValueObject.put("list", ldIdTitleList);
                session.flush();
                hashtable = ldValueObject;
                Object var13_12 = null;
                if (session == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var13_13 = null;
                    if (session == null) break block4;
                    session.flush();
                    session.close();
                }
                throw throwable;
            }
            session.flush();
            session.close();
        }
        return hashtable;
    }

    private Hashtable buildLDValueObject(LearningDesignDefnVO ld, UserData user) throws Exception {
        Integer subsequentTransitionId;
        Iterator<Object> iter;
        Set coll;
        this.contentUtil = new ContentDelegate(ld.getContentSids());
        Hashtable<String, Object> ldValueObject = new Hashtable<String, Object>();
        ldValueObject.put("maxId", new Integer(ld.getMaxId()));
        ldValueObject.put("objectType", HashtableUtils.getValue(ld.theObjectType()));
        ldValueObject.put("description", HashtableUtils.getValue(ld.getDescription()));
        ldValueObject.put("title", HashtableUtils.getValue(ld.getTitle()));
        ldValueObject.put("LDId", ld.getSid());
        ldValueObject.put("firstActivity", HashtableUtils.getIdInteger(ld.getFirstActivityId()));
        this.processReadWriteAccess(ldValueObject, ld, user);
        logger.debug((Object)("help text is " + ld.getHelpText()));
        if (ld.getHelpText() != null) {
            logger.debug((Object)"Adding help text to structure");
            ldValueObject.put("helpText", ld.getHelpText());
        }
        ContentConverter converter = new ContentConverter();
        Vector<Hashtable> contentOutput = new Vector<Hashtable>();
        try {
            Map currentContents = this.contentUtil.getCurrentContentsAsMapBySid();
            coll = currentContents.values();
            iter = coll.iterator();
            while (iter.hasNext()) {
                Content aContent = (Content)iter.next();
                Hashtable aContentOutput = converter.createContentHashtable(aContent);
                contentOutput.add(aContentOutput);
            }
        }
        catch (NullPointerException ne) {
            logger.debug((Object)ne);
        }
        ldValueObject.put("content", contentOutput);
        Vector<Hashtable> acttranOutput = new Vector<Hashtable>();
        try {
            coll = ld.getActivities();
            iter = coll.iterator();
            while (iter.hasNext()) {
                ActivityDefnVO act = (ActivityDefnVO)iter.next();
                subsequentTransitionId = ld.calculateSingleSubsequentTransitionId(new Integer(act.getId()));
                Hashtable actOutput = this.createActivityHashtable(act, subsequentTransitionId);
                acttranOutput.add(actOutput);
            }
        }
        catch (NullPointerException ne) {
            logger.debug((Object)ne);
        }
        try {
            coll = ld.getTransitions();
            iter = coll.iterator();
            while (iter.hasNext()) {
                Hashtable tranOutput = this.createTransitionHashtable((TransitionDefnVO)iter.next());
                acttranOutput.add(tranOutput);
            }
        }
        catch (NullPointerException ne) {
            logger.debug((Object)ne);
        }
        try {
            coll = ld.getOptionalActivities();
            iter = coll.iterator();
            while (iter.hasNext()) {
                OptionalActivityDefnVO optAct = (OptionalActivityDefnVO)iter.next();
                subsequentTransitionId = ld.calculateSingleSubsequentTransitionId(new Integer(optAct.getId()));
                Hashtable tranOutput = this.createOptionalActivityHashtable(optAct, subsequentTransitionId);
                acttranOutput.add(tranOutput);
            }
        }
        catch (NullPointerException ne) {
            logger.debug((Object)ne);
        }
        ldValueObject.put("activitiesTransitions", acttranOutput);
        return ldValueObject;
    }

    private void processReadWriteAccess(Hashtable ldValueObject, LearningDesignDefnVO ld, UserData user) {
        String name;
        Long userId = user.getSid();
        ldValueObject.put("readOnly", new Boolean(ld.isReadOnly()));
        ldValueObject.put("readAccessStatus", new Boolean(ld.hasReadAccess(userId)));
        ldValueObject.put("readAccess", new Long(ld.getReadAccess()));
        if (ld.getReadAccess() == -1L) {
            ldValueObject.put("readAccessDesc", "Private");
        } else if (ld.getReadAccess() == 0L) {
            ldValueObject.put("readAccessDesc", "Globally available");
        } else {
            name = this.findOrgName(user, new Long(ld.getReadAccess()));
            ldValueObject.put("readAccessDesc", name);
        }
        ldValueObject.put("writeAccessStatus", new Boolean(ld.hasWriteAccess(userId)));
        ldValueObject.put("writeAccess", new Long(ld.getWriteAccess()));
        if (ld.getWriteAccess() == -1L) {
            ldValueObject.put("writeAccessDesc", "Private");
        } else if (ld.getWriteAccess() == 0L) {
            ldValueObject.put("writeAccessDesc", "Globally available");
        } else {
            name = this.findOrgName(user, new Long(ld.getWriteAccess()));
            ldValueObject.put("writeAccessDesc", name);
        }
    }

    private String findOrgName(UserData user, Long orgId) {
        String name = (String)this.orgNames.get(orgId);
        if (name == null) {
            if (user.getMemberships() != null) {
                Iterator iter = user.getMemberships().iterator();
                while (name == null && iter.hasNext()) {
                    UserMembershipData element = (UserMembershipData)iter.next();
                    if (!element.getOrgId().equals(orgId)) continue;
                    name = element.getOrgName();
                }
            }
            if (name == null) {
                logger.warn((Object)("processReadWriteAccess: Unable to find name of organisation: user doesn't have membership of this organisation. Org id=" + orgId + " user " + user.getSid()));
                name = "Unknown Organisation";
            }
            this.orgNames.put(orgId, name);
        }
        return name;
    }

    private Hashtable createActivityHashtable(ActivityDefnVO act, Integer subsequentTransitionId) throws Exception {
        Hashtable<String, Object> actOutput = new Hashtable<String, Object>();
        actOutput.put("description", HashtableUtils.getValue(act.getDescription()));
        actOutput.put("id", new Integer(act.getId()));
        actOutput.put("title", HashtableUtils.getValue(act.getTitle()));
        actOutput.put("objectType", HashtableUtils.getValue(act.theObjectType()));
        actOutput.put("libId", HashtableUtils.getValue(act.getLibraryActivityId()));
        actOutput.put("tasksTransitions", this.createTaskTransitionVector(act));
        actOutput.put("sid", HashtableUtils.getIdLong(act.getSid()));
        actOutput.put("x", HashtableUtils.getIdInteger(act.getXcoord()));
        actOutput.put("y", HashtableUtils.getIdInteger(act.getYcoord()));
        actOutput.put("firstTask", HashtableUtils.getIdInteger(act.getFirstTaskId()));
        if (subsequentTransitionId != null) {
            actOutput.put("nextTransition", subsequentTransitionId);
        } else {
            actOutput.put("nextTransition", NUMERIC_NULL_VALUE_INTEGER);
        }
        return actOutput;
    }

    private Hashtable createTransitionHashtable(TransitionDefnVO tran) {
        Hashtable<String, Object> tranOutput = new Hashtable<String, Object>();
        tranOutput.put("fromTasks", new Integer(tran.getFromTaskActivityId()));
        tranOutput.put("toTasks", new Integer(tran.getToTaskActivityId()));
        tranOutput.put("id", new Integer(tran.getId()));
        tranOutput.put("completionType", HashtableUtils.getValue(tran.getCompletion()));
        tranOutput.put("objectType", HashtableUtils.getValue(tran.theObjectType()));
        tranOutput.put("sid", HashtableUtils.getIdLong(tran.getSid()));
        return tranOutput;
    }

    private Hashtable createOptionalActivityHashtable(OptionalActivityDefnVO optAct, Integer subsequentTransitionId) throws Exception {
        Hashtable<String, Object> actOutput = new Hashtable<String, Object>();
        actOutput.put("description", HashtableUtils.getValue(optAct.getDescription()));
        actOutput.put("id", new Integer(optAct.getId()));
        actOutput.put("title", HashtableUtils.getValue(optAct.getTitle()));
        actOutput.put("objectType", HashtableUtils.getValue(optAct.theObjectType()));
        actOutput.put("sid", HashtableUtils.getIdLong(optAct.getSid()));
        actOutput.put("minNumberComplete", HashtableUtils.getIdInteger(optAct.getMinNumberComplete()));
        actOutput.put("x", HashtableUtils.getIdInteger(optAct.getXcoordStart()));
        actOutput.put("y", HashtableUtils.getIdInteger(optAct.getYcoordStart()));
        actOutput.put("xEnd", HashtableUtils.getIdInteger(optAct.getXcoordEnd()));
        actOutput.put("yEnd", HashtableUtils.getIdInteger(optAct.getYcoordEnd()));
        Set activities = optAct.getActivities();
        Vector<Integer> activityIds = new Vector<Integer>();
        if (activities != null) {
            Iterator iter = activities.iterator();
            while (iter.hasNext()) {
                ActivityDefnVO act = (ActivityDefnVO)iter.next();
                activityIds.add(new Integer(act.getId()));
            }
        }
        actOutput.put("activities", activityIds);
        if (subsequentTransitionId != null) {
            actOutput.put("nextTransition", subsequentTransitionId);
        } else {
            actOutput.put("nextTransition", NUMERIC_NULL_VALUE_INTEGER);
        }
        return actOutput;
    }

    private Hashtable createTask(AbstractTaskVO task, Integer subsequentTransitionId) throws Exception {
        if (task.theTaskType() == 2) {
            return this.createMultiTaskHashtable((MultiTaskVO)task, subsequentTransitionId);
        }
        return this.createSimpleTaskHashtable((SimpleTaskVO)task, subsequentTransitionId);
    }

    private void addSharedTaskValues(Hashtable taskOutput, AbstractTaskVO task, Integer subsequentTransitionId) {
        GroupDefnVO gdefn;
        GroupingTaskVO gtask;
        Iterator iter;
        taskOutput.put("objectType", HashtableUtils.getValue(task.theObjectType()));
        taskOutput.put("id", new Integer(task.getId()));
        taskOutput.put("description", HashtableUtils.getValue(task.getDescription()));
        taskOutput.put("title", HashtableUtils.getValue(task.getTitle()));
        taskOutput.put("completion", HashtableUtils.getValue(task.getCompletion()));
        taskOutput.put("sid", HashtableUtils.getIdLong(task.getSid()));
        if (subsequentTransitionId != null) {
            taskOutput.put("nextTransition", subsequentTransitionId);
        } else {
            taskOutput.put("nextTransition", NUMERIC_NULL_VALUE_INTEGER);
        }
        Set groupingDefns = task.getGroupsForTask();
        Object groupingLink = "c";
        if (groupingDefns != null && (iter = groupingDefns.iterator()).hasNext() && (gtask = (gdefn = (GroupDefnVO)iter.next()).getGroupingTask()) != null) {
            groupingLink = new Integer(gtask.getId());
        }
        taskOutput.put("grouping", groupingLink);
    }

    private Hashtable createMultiTaskHashtable(MultiTaskVO task, Integer subsequentTransitionId) throws Exception {
        Hashtable<String, Object> taskOutput = new Hashtable<String, Object>();
        this.addSharedTaskValues(taskOutput, task, subsequentTransitionId);
        taskOutput.put("taskOrder", HashtableUtils.getValue(task.getTaskOrderOnScreen()));
        Set subTasks = task.getSubTasks();
        Vector<Hashtable> subTasksOut = new Vector<Hashtable>();
        if (subTasks != null) {
            Iterator iter = subTasks.iterator();
            while (iter.hasNext()) {
                subTasksOut.add(this.createTask((AbstractTaskVO)iter.next(), null));
            }
        }
        taskOutput.put("subTasks", subTasksOut);
        taskOutput.put("inputContentTask", HashtableUtils.getIdInteger(task.getInputContentTask()));
        taskOutput.put("outputContentTask", HashtableUtils.getIdInteger(task.getOutputContentTask()));
        taskOutput.put("taskOrder", HashtableUtils.getValue(task.getTaskOrderOnScreen()));
        return taskOutput;
    }

    private Hashtable createSimpleTaskHashtable(SimpleTaskVO task, Integer subsequentTransitionId) throws Exception {
        Hashtable<String, Object> taskOutput = new Hashtable<String, Object>();
        this.addSharedTaskValues(taskOutput, task, subsequentTransitionId);
        taskOutput.put("toolType", HashtableUtils.getValue(task.getToolType()));
        Map currentContents = this.contentUtil.getCurrentContentsAsMapBySid();
        Content content = null;
        Long sid = null;
        Long contentSid = null;
        try {
            sid = task.getInputContentSid();
            content = (Content)currentContents.get(sid);
            contentSid = null;
            if (content != null) {
                contentSid = new Long(content.getCreationToolKey());
            }
            taskOutput.put("inputContent", HashtableUtils.getIdLong(contentSid));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Unable to determine internal learning design id for content " + content + " for task " + task.toString() + " sending -1 (ie no content id)."));
            taskOutput.put("inputContent", NUMERIC_NULL_VALUE_LONG);
        }
        try {
            sid = task.getOutputContentSid();
            content = (Content)currentContents.get(sid);
            contentSid = null;
            if (content != null) {
                contentSid = new Long(content.getCreationToolKey());
            }
            taskOutput.put("outputContent", HashtableUtils.getIdLong(contentSid));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Unable to determine internal learning design id for content " + content + " for task " + task.toString() + " sending -1 (ie no content id)."));
            taskOutput.put("outputContent", NUMERIC_NULL_VALUE_LONG);
        }
        return taskOutput;
    }

    private Vector createTaskTransitionVector(ActivityDefnVO act) throws Exception {
        Iterator iter;
        Vector<Hashtable> ttOutput = new Vector<Hashtable>();
        Set coll = act.getTasks();
        if (coll != null && !coll.isEmpty()) {
            iter = coll.iterator();
            while (iter.hasNext()) {
                AbstractTaskVO task = (AbstractTaskVO)iter.next();
                Integer subsequentTransitionId = act.calculateSingleSubsequentTransitionId(new Integer(task.getId()));
                Hashtable taskOutput = null;
                try {
                    taskOutput = this.createTask(task, subsequentTransitionId);
                }
                catch (Exception e) {
                    throw new Exception("Error creating task " + task.toString() + " " + e.getMessage());
                }
                ttOutput.add(taskOutput);
            }
        }
        if ((coll = act.getTransitions()) != null && !coll.isEmpty()) {
            iter = coll.iterator();
            while (iter.hasNext()) {
                Hashtable taskOutput = this.createTransitionHashtable((TransitionDefnVO)iter.next());
                ttOutput.add(taskOutput);
            }
        }
        return ttOutput;
    }

    public Hashtable newLibraryValueObject(Long libId, UserData user) throws RuntimeException, EJBException, Exception {
        PersistenceSession session = new PersistenceSession();
        Hashtable result = null;
        try {
            LibraryDefnVO lib = LDWDDXValueObjectFactory.findCreateLibrary(session, libId, user.getSid());
            result = this.buildLibraryValueObject(lib, user);
            session.flush();
            Hashtable hashtable = result;
            return hashtable;
        }
        catch (NamingException ne) {
            logger.error((Object)"Unable to find library.", (Throwable)ne);
            throw new Exception("Unable to find library. Internal error " + ne.getMessage());
        }
        catch (FinderException fe) {
            throw new Exception("Unable to find library - not found in database.");
        }
        catch (Exception e) {
            logger.error((Object)"Unable to find library.", (Throwable)e);
            throw new Exception("Unable to return library - probably an internal error " + e.getMessage());
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public LibraryDefnVO newLibraryVO(Long libId, UserData user) throws RuntimeException, EJBException, Exception {
        PersistenceSession session = new PersistenceSession();
        LibraryDefnVO lib = null;
        try {
            lib = LDWDDXValueObjectFactory.findCreateLibrary(session, libId, user.getSid());
            session.flush();
            LibraryDefnVO libraryDefnVO = lib;
            return libraryDefnVO;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to find library.", (Throwable)e);
            throw new Exception("Unable to return library - probably an internal error " + e.getMessage());
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static LibraryDefnVO findCreateLibrary(PersistenceSession session, Long id, Long userId) throws ClassCastException, HibernateException, SQLException, EJBException {
        LibraryDefnVO library = null;
        try {
            Iterator it;
            LibraryDefnDAO libDAO = new LibraryDefnDAO(session);
            List libs = libDAO.findAll();
            if (libs != null && (it = libs.iterator()).hasNext()) {
                library = (LibraryDefnVO)it.next();
            }
            if (library == null) {
                library = new LibraryDefnVO();
                session.persistece().save((Object)library);
                session.flush();
            }
        }
        catch (ClassCastException cce) {
            logger.error((Object)"Class cast exception generated while trying to find or create new library ", (Throwable)cce);
            cce.printStackTrace();
            throw cce;
        }
        logger.debug((Object)("Returning library " + library.toString()));
        return library;
    }

    private Hashtable buildLibraryValueObject(LibraryDefnVO lib, UserData user) throws Exception {
        Hashtable<String, Object> libValueObject = new Hashtable<String, Object>();
        libValueObject.put("objectType", HashtableUtils.getValue(lib.theObjectType()));
        libValueObject.put("description", HashtableUtils.getValue(lib.getDescription()));
        libValueObject.put("title", HashtableUtils.getValue(lib.getTitle()));
        libValueObject.put("sid", HashtableUtils.getIdLong(lib.getSid()));
        Vector<Hashtable> libPackages = new Vector<Hashtable>();
        Set coll = lib.getLibraryPackages();
        if (coll != null) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                LearningDesignDefnVO libPackage = (LearningDesignDefnVO)iter.next();
                if (!libPackage.hasReadAccess(user.getSid())) continue;
                logger.debug((Object)("Adding library package: " + libPackage));
                Hashtable output = this.buildLDValueObject(libPackage, user);
                libPackages.add(output);
            }
        }
        libValueObject.put("packages", libPackages);
        return libValueObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

