/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.util.ParsingUtil;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MultiTaskVO
extends AbstractTaskVO {
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$MultiTaskVO == null ? (class$com$webmcq$ld$activities$MultiTaskVO = MultiTaskVO.class$("com.webmcq.ld.activities.MultiTaskVO")) : class$com$webmcq$ld$activities$MultiTaskVO).getName());
    static final long serialVersionUID = -5916700305547325858L;
    public static final String TASK_OBJECT_TYPE = "Multitask";
    protected Set subTasks;
    protected Integer inputContentTask;
    protected Integer outputContentTask;
    protected String taskOrderOnScreen;
    static /* synthetic */ Class class$com$webmcq$ld$activities$MultiTaskVO;

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append(super.toString());
        buf.append(" subtasks:\n");
        Set subTasks = this.getSubTasks();
        if (subTasks != null) {
            Iterator it = subTasks.iterator();
            while (it.hasNext()) {
                AbstractTaskVO t = (AbstractTaskVO)it.next();
                buf.append(t.toString());
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public int theTaskType() {
        return 2;
    }

    public Set getSubTasks() {
        return this.subTasks;
    }

    public void setSubTasks(Set subTasks) {
        this.subTasks = subTasks;
    }

    public String theObjectType() {
        return TASK_OBJECT_TYPE;
    }

    public Integer getInputContentTask() {
        return this.inputContentTask;
    }

    public Integer getOutputContentTask() {
        return this.outputContentTask;
    }

    public String getTaskOrderOnScreen() {
        return this.taskOrderOnScreen;
    }

    public void setInputContentTask(Integer inputContentTask) {
        this.inputContentTask = inputContentTask;
    }

    public void setOutputContentTask(Integer outputContentTask) {
        this.outputContentTask = outputContentTask;
    }

    public void setTaskOrderOnScreen(String taskOrderOnScreen) {
        this.taskOrderOnScreen = taskOrderOnScreen;
    }

    public AbstractTaskVO selectTaskById(int id) {
        Set theTasks = this.getSubTasks();
        Iterator it = theTasks.iterator();
        while (it.hasNext()) {
            AbstractTaskVO task = (AbstractTaskVO)it.next();
            if (task.getId() != id) continue;
            return task;
        }
        return null;
    }

    public boolean equals(Object pOther) {
        if (pOther instanceof MultiTaskVO) {
            MultiTaskVO lTest = (MultiTaskVO)pOther;
            boolean lEquals = super.equals(pOther);
            if (this.inputContentTask == null) {
                lEquals = lEquals && lTest.inputContentTask == null;
            } else {
                boolean bl = lEquals = lEquals && this.inputContentTask.equals(lTest.inputContentTask);
            }
            if (this.outputContentTask == null) {
                lEquals = lEquals && lTest.outputContentTask == null;
            } else {
                boolean bl = lEquals = lEquals && this.outputContentTask.equals(lTest.outputContentTask);
            }
            lEquals = this.taskOrderOnScreen == null ? lEquals && lTest.taskOrderOnScreen == null : lEquals && this.taskOrderOnScreen.equals(lTest.taskOrderOnScreen);
            return lEquals;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + (this.inputContentTask != null ? this.inputContentTask.hashCode() : 0);
        result = 37 * result + (this.outputContentTask != null ? this.outputContentTask.hashCode() : 0);
        return result;
    }

    public Vector getOrderedSubTasks() {
        Vector<AbstractTaskVO> returnValue = new Vector<AbstractTaskVO>();
        String order = this.getTaskOrderOnScreen();
        if (order == null) {
            Set subTasks = this.getSubTasks();
            if (subTasks.size() > 0) {
                logger.error((Object)("Subtasks exist but order is unknown. Using random order. Multitask is " + this.toString()));
                returnValue.addAll(subTasks);
            }
            return returnValue;
        }
        Vector orderVector = ParsingUtil.parseStringToInts(order);
        Iterator iter = orderVector.iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            AbstractTaskVO subTask = this.selectTaskById(id);
            if (subTask == null) {
                logger.error((Object)("Task referred to in subtask order doesn't exist in subtasks set. Multitask is " + this.toString()));
            }
            returnValue.add(subTask);
        }
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

