/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.web.servlets;

import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.chat.dto.ChatDTO;
import org.lamsfoundation.lams.tool.chat.dto.ChatMessageDTO;
import org.lamsfoundation.lams.tool.chat.dto.ChatSessionDTO;
import org.lamsfoundation.lams.tool.chat.dto.ChatUserDTO;
import org.lamsfoundation.lams.tool.chat.model.Chat;
import org.lamsfoundation.lams.tool.chat.model.ChatSession;
import org.lamsfoundation.lams.tool.chat.model.ChatUser;
import org.lamsfoundation.lams.tool.chat.service.ChatServiceProxy;
import org.lamsfoundation.lams.tool.chat.service.IChatService;
import org.lamsfoundation.lams.tool.chat.util.ChatException;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;
import org.lamsfoundation.lams.web.session.SessionManager;

public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -2829707715037631881L;
    private static Logger logger = Logger.getLogger(ExportServlet.class);
    private final String FILENAME = "chat_main.html";
    private IChatService chatService;

    protected String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.chatService == null) {
            this.chatService = ChatServiceProxy.getChatService(this.getServletContext());
        }
        try {
            if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.LEARNER);
                this.doLearnerExport(request, response, directoryName, cookies);
            } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.TEACHER);
                this.doTeacherExport(request, response, directoryName, cookies);
            }
        }
        catch (ChatException e) {
            logger.error((Object)"Cannot perform export for chat tool.");
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        this.writeResponseToFile(basePath + "/pages/export/exportPortfolio.jsp", directoryName, "chat_main.html", cookies);
        return "chat_main.html";
    }

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            logger.error((Object)"Tool content Id or and session Id are null. Unable to activity title");
        } else {
            IChatService service = ChatServiceProxy.getChatService(this.getServletContext());
            Chat chat = null;
            if (this.toolContentID != null) {
                chat = service.getChatByContentId(this.toolContentID);
            } else {
                ChatSession session = this.chatService.getSessionBySessionId(this.toolSessionID);
                if (session != null) {
                    chat = session.getChat();
                }
            }
            if (chat != null) {
                this.activityTitle = chat.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    private void doLearnerExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) throws ChatException {
        logger.debug((Object)("doExportTeacher: toolContentID:" + this.toolSessionID));
        if (this.toolSessionID == null) {
            String error = "Tool Session ID is missing. Unable to continue";
            logger.error((Object)error);
            throw new ChatException(error);
        }
        ChatSession chatSession = this.chatService.getSessionBySessionId(this.toolSessionID);
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        ChatUser chatUser = this.chatService.getUserByUserIdAndSessionId(new Long(user.getUserID().intValue()), this.toolSessionID);
        List messageList = this.chatService.getMessagesForUser(chatUser);
        ChatSessionDTO sessionDTO = new ChatSessionDTO(chatSession, messageList);
        if (chatSession.getChat().isReflectOnActivity()) {
            ChatUserDTO chatUserDTO = new ChatUserDTO(chatUser);
            NotebookEntry entry = this.chatService.getEntry(this.toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lachat11", chatUser.getUserId().intValue());
            if (entry != null) {
                chatUserDTO.finishedReflection = true;
                chatUserDTO.notebookEntry = entry.getEntry();
            } else {
                chatUserDTO.finishedReflection = false;
            }
            sessionDTO.getUserDTOs().add(chatUserDTO);
        }
        for (ChatMessageDTO msg : sessionDTO.getMessageDTOs()) {
            this.chatService.filterMessage(msg, chatSession.getChat());
        }
        ChatDTO chatDTO = new ChatDTO(chatSession.getChat());
        chatDTO.getSessionDTOs().add(sessionDTO);
        request.getSession().setAttribute("chatDTO", (Object)chatDTO);
    }

    private void doTeacherExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) throws ChatException {
        logger.debug((Object)("doExportTeacher: toolContentID:" + this.toolContentID));
        if (this.toolContentID == null) {
            String error = "Tool Content ID is missing. Unable to continue";
            logger.error((Object)error);
            throw new ChatException(error);
        }
        Chat chat = this.chatService.getChatByContentId(this.toolContentID);
        ChatDTO chatDTO = new ChatDTO(chat);
        for (ChatSession session : chat.getChatSessions()) {
            ChatSessionDTO sessionDTO = new ChatSessionDTO(session);
            if (session.getChat().isReflectOnActivity()) {
                for (ChatUser user : session.getChatUsers()) {
                    ChatUserDTO userDTO = new ChatUserDTO(user);
                    NotebookEntry entry = this.chatService.getEntry(session.getSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lachat11", user.getUserId().intValue());
                    if (entry != null) {
                        userDTO.finishedReflection = true;
                        userDTO.notebookEntry = entry.getEntry();
                    } else {
                        userDTO.finishedReflection = false;
                    }
                    sessionDTO.getUserDTOs().add(userDTO);
                }
            }
            chatDTO.getSessionDTOs().add(sessionDTO);
        }
        request.getSession().setAttribute("chatDTO", (Object)chatDTO);
    }
}

