/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.web.actions;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.chat.dto.ChatDTO;
import org.lamsfoundation.lams.tool.chat.dto.ChatUserDTO;
import org.lamsfoundation.lams.tool.chat.model.Chat;
import org.lamsfoundation.lams.tool.chat.model.ChatSession;
import org.lamsfoundation.lams.tool.chat.model.ChatUser;
import org.lamsfoundation.lams.tool.chat.service.ChatServiceProxy;
import org.lamsfoundation.lams.tool.chat.service.IChatService;
import org.lamsfoundation.lams.tool.chat.util.ChatException;
import org.lamsfoundation.lams.tool.chat.web.forms.LearningForm;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class LearningAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(LearningAction.class);
    private IChatService chatService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NotebookEntry notebookEntry;
        ChatSession chatSession;
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)false);
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        if (this.chatService == null) {
            this.chatService = ChatServiceProxy.getChatService(this.getServlet().getServletContext());
        }
        if ((chatSession = this.chatService.getSessionBySessionId(toolSessionID)) == null) {
            throw new ChatException("Cannot retreive session with toolSessionID" + toolSessionID);
        }
        Chat chat = chatSession.getChat();
        ChatUser chatUser = this.getCurrentUser(toolSessionID);
        if (chat.isDefineLater()) {
            return mapping.findForward("defineLater");
        }
        request.setAttribute("MODE", (Object)mode.toString());
        log.debug((Object)chatSession.isRoomCreated());
        if (!chatSession.isRoomCreated()) {
            this.chatService.createJabberRoom(chatSession);
            this.chatService.saveOrUpdateChatSession(chatSession);
        }
        ChatDTO chatDTO = new ChatDTO(chat);
        request.setAttribute("chatDTO", (Object)chatDTO);
        request.setAttribute("XMPPDOMAIN", (Object)Configuration.get((String)ConfigurationKeys.XMPP_DOMAIN));
        request.setAttribute("CONFERENCEROOM", (Object)chatSession.getJabberRoom());
        ChatUserDTO chatUserDTO = new ChatUserDTO(chatUser);
        if (chatUser.isFinishedActivity() && (notebookEntry = this.chatService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lachat11", chatUser.getUserId().intValue())) != null) {
            chatUserDTO.notebookEntry = notebookEntry.getEntry();
        }
        request.setAttribute("chatUserDTO", (Object)chatUserDTO);
        if (!chat.isContentInUse()) {
            chat.setContentInUse(new Boolean(true));
            this.chatService.saveOrUpdateChat(chat);
        }
        if (chat.isRunOffline()) {
            return mapping.findForward("runOffline");
        }
        return mapping.findForward("learning");
    }

    private ChatUser getCurrentUser(Long toolSessionId) {
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        ChatUser chatUser = this.chatService.getUserByUserIdAndSessionId(new Long(user.getUserID().intValue()), toolSessionId);
        if (chatUser == null) {
            ChatSession chatSession = this.chatService.getSessionBySessionId(toolSessionId);
            chatUser = this.chatService.createChatUser(user, chatSession);
        }
        return chatUser;
    }

    public ActionForward finishActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LearningForm lrnForm = (LearningForm)form;
        ChatUser chatUser = this.chatService.getUserByUID(lrnForm.getChatUserUID());
        if (chatUser != null) {
            chatUser.setFinishedActivity(true);
            this.chatService.saveOrUpdateChatUser(chatUser);
        } else {
            log.error((Object)("finishActivity(): couldn't find ChatUser with uid: " + lrnForm.getChatUserUID()));
        }
        ToolSessionManager sessionMgrService = ChatServiceProxy.getChatSessionManager(this.getServlet().getServletContext());
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Long userID = new Long(user.getUserID().longValue());
        Long toolSessionID = chatUser.getChatSession().getSessionId();
        try {
            String nextActivityUrl = sessionMgrService.leaveToolSession(toolSessionID, userID);
            response.sendRedirect(nextActivityUrl);
        }
        catch (DataMissingException e) {
            throw new ChatException(e);
        }
        catch (ToolException e) {
            throw new ChatException(e);
        }
        catch (IOException e) {
            throw new ChatException(e);
        }
        return null;
    }

    public ActionForward openNotebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LearningForm lrnForm = (LearningForm)form;
        ChatUser chatUser = this.chatService.getUserByUID(lrnForm.getChatUserUID());
        ChatDTO chatDTO = new ChatDTO(chatUser.getChatSession().getChat());
        request.setAttribute("chatDTO", (Object)chatDTO);
        NotebookEntry notebookEntry = this.chatService.getEntry(chatUser.getChatSession().getSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lachat11", chatUser.getUserId().intValue());
        if (notebookEntry != null) {
            lrnForm.setEntryText(notebookEntry.getEntry());
        }
        return mapping.findForward("notebook");
    }

    public ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer userID;
        LearningForm lrnForm = (LearningForm)form;
        ChatUser chatUser = this.chatService.getUserByUID(lrnForm.getChatUserUID());
        Long toolSessionID = chatUser.getChatSession().getSessionId();
        NotebookEntry entry = this.chatService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lachat11", userID = Integer.valueOf(chatUser.getUserId().intValue()));
        if (entry == null) {
            this.chatService.createNotebookEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lachat11", userID, lrnForm.getEntryText());
        } else {
            entry.setEntry(lrnForm.getEntryText());
            entry.setLastModified(new Date());
            this.chatService.updateEntry(entry);
        }
        return this.finishActivity(mapping, form, request, response);
    }
}

