/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.chat.model.ChatAttachment;
import org.lamsfoundation.lams.tool.chat.service.ChatService;

public class Chat
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 579733009969321015L;
    static Logger log = Logger.getLogger((String)ChatService.class.getName());
    private Long uid;
    private Date createDate;
    private Date updateDate;
    private Long createBy;
    private String title;
    private String instructions;
    private boolean runOffline;
    private boolean lockOnFinished;
    private boolean reflectOnActivity;
    private String reflectInstructions;
    private boolean filteringEnabled;
    private String filterKeywords;
    private String onlineInstructions;
    private String offlineInstructions;
    private boolean contentInUse;
    private boolean defineLater;
    private Long toolContentId;
    private Set chatAttachments;
    private Set chatSessions;
    private IToolContentHandler toolContentHandler;

    public Chat() {
    }

    public Chat(Date createDate, Date updateDate, Long createBy, String title, String instructions, boolean runOffline, boolean lockOnFinished, boolean filteringEnabled, String filterKeywords, String onlineInstructions, String offlineInstructions, boolean contentInUse, boolean defineLater, Long toolContentId, Set chatAttachments, Set chatSessions) {
        this.createDate = createDate;
        this.updateDate = updateDate;
        this.createBy = createBy;
        this.title = title;
        this.instructions = instructions;
        this.runOffline = runOffline;
        this.lockOnFinished = lockOnFinished;
        this.filteringEnabled = filteringEnabled;
        this.filterKeywords = filterKeywords;
        this.onlineInstructions = onlineInstructions;
        this.offlineInstructions = offlineInstructions;
        this.contentInUse = contentInUse;
        this.defineLater = defineLater;
        this.toolContentId = toolContentId;
        this.chatAttachments = chatAttachments;
        this.chatSessions = chatSessions;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public boolean isRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean runOffline) {
        this.runOffline = runOffline;
    }

    public boolean isLockOnFinished() {
        return this.lockOnFinished;
    }

    public void setLockOnFinished(boolean lockOnFinished) {
        this.lockOnFinished = lockOnFinished;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentId) {
        this.toolContentId = toolContentId;
    }

    public Set getChatAttachments() {
        return this.chatAttachments;
    }

    public void setChatAttachments(Set chatAttachments) {
        this.chatAttachments = chatAttachments;
    }

    public Set getChatSessions() {
        return this.chatSessions;
    }

    public void setChatSessions(Set chatSessions) {
        this.chatSessions = chatSessions;
    }

    public boolean isFilteringEnabled() {
        return this.filteringEnabled;
    }

    public void setFilteringEnabled(boolean filteringEnabled) {
        this.filteringEnabled = filteringEnabled;
    }

    public String getFilterKeywords() {
        return this.filterKeywords;
    }

    public void setFilterKeywords(String filterKeywords) {
        this.filterKeywords = filterKeywords;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append(" [");
        buffer.append("title").append("='").append(this.getTitle()).append("' ");
        buffer.append("instructions").append("='").append(this.getInstructions()).append("' ");
        buffer.append("toolContentId").append("='").append(this.getToolContentId()).append("' ");
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Chat)) {
            return false;
        }
        Chat castOther = (Chat)other;
        return this.getUid() == castOther.getUid() || this.getUid() != null && castOther.getUid() != null && this.getUid().equals(castOther.getUid());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getUid() == null ? 0 : this.getUid().hashCode());
        return result;
    }

    public static Chat newInstance(Chat fromContent, Long toContentId, IToolContentHandler chatToolContentHandler) {
        Chat toContent = new Chat();
        fromContent.toolContentHandler = chatToolContentHandler;
        toContent = (Chat)fromContent.clone();
        toContent.setToolContentId(toContentId);
        toContent.setCreateDate(new Date());
        return toContent;
    }

    protected Object clone() {
        Chat chat = null;
        try {
            chat = (Chat)super.clone();
            chat.setUid(null);
            if (this.chatAttachments != null) {
                Iterator iter = this.chatAttachments.iterator();
                HashSet<ChatAttachment> set = new HashSet<ChatAttachment>();
                while (iter.hasNext()) {
                    ChatAttachment originalFile = (ChatAttachment)iter.next();
                    ChatAttachment newFile = (ChatAttachment)originalFile.clone();
                    set.add(newFile);
                }
                chat.chatAttachments = set;
            }
            chat.chatSessions = new HashSet();
        }
        catch (CloneNotSupportedException cnse) {
            log.error((Object)("Error cloning " + Chat.class));
        }
        return chat;
    }

    public IToolContentHandler getToolContentHandler() {
        return this.toolContentHandler;
    }

    public void setToolContentHandler(IToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }
}

