/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.tool.chat.dao.IChatUserDAO;
import org.lamsfoundation.lams.tool.chat.model.ChatUser;

public class ChatUserDAO
extends BaseDAO
implements IChatUserDAO {
    public static final String SQL_QUERY_FIND_BY_USER_ID_SESSION_ID = "from " + ChatUser.class.getName() + " as f" + " where user_id=? and f.chatSession.sessionId=?";
    public static final String SQL_QUERY_FIND_BY_LOGIN_NAME_SESSION_ID = "from " + ChatUser.class.getName() + " as f where login_name=? and f.chatSession.sessionId=?";
    public static final String SQL_QUERY_FIND_BY_JABBER_ID_JABBER_ROOM = "from " + ChatUser.class.getName() + " as f where jabber_id=? and f.chatSession.jabberRoom=?";
    private static final String SQL_QUERY_FIND_BY_UID = "from " + ChatUser.class.getName() + " where uid=?";
    private static final String SQL_QUERY_FIND_BY_NICKNAME_AND_SESSION = "from " + ChatUser.class.getName() + " as f where jabber_nickname=? and f.chatSession.sessionId=?";

    public ChatUser getByUserIdAndSessionId(Long userId, Long toolSessionId) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_FIND_BY_USER_ID_SESSION_ID, new Object[]{userId, toolSessionId});
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (ChatUser)list.get(0);
    }

    public ChatUser getByLoginNameAndSessionId(String loginName, Long toolSessionId) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_FIND_BY_LOGIN_NAME_SESSION_ID, new Object[]{loginName, toolSessionId});
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (ChatUser)list.get(0);
    }

    public ChatUser getByJabberIDAndJabberRoom(String jabberID, String jabberRoom) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_FIND_BY_JABBER_ID_JABBER_ROOM, new Object[]{jabberID, jabberRoom});
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (ChatUser)list.get(0);
    }

    public void saveOrUpdate(ChatUser chatUser) {
        this.getHibernateTemplate().saveOrUpdate((Object)chatUser);
        this.getHibernateTemplate().flush();
    }

    public ChatUser getByUID(Long uid) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_FIND_BY_UID, new Object[]{uid});
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (ChatUser)list.get(0);
    }

    public ChatUser getByJabberNicknameAndSessionID(String jabberNickname, Long sessionID) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_FIND_BY_NICKNAME_AND_SESSION, new Object[]{jabberNickname, sessionID});
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (ChatUser)list.get(0);
    }
}

