/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.dao.hibernate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.tool.chat.dao.IChatMessageDAO;
import org.lamsfoundation.lams.tool.chat.model.ChatMessage;
import org.lamsfoundation.lams.tool.chat.model.ChatSession;
import org.lamsfoundation.lams.tool.chat.model.ChatUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatMessageDAO
extends BaseDAO
implements IChatMessageDAO {
    public static final String SQL_QUERY_FIND_USER_MESSAGE_HISTORY = "from " + ChatMessage.class.getName() + " as f where " + "f.chatSession.uid=? and f.hidden='false' and (f.type='groupchat' or (f.type='chat' and (f.fromUser.uid=? or f.toUser.uid=?)))";
    public static final String SQL_QUERY_FIND_MESSAGE_BY_UID = "from " + ChatMessage.class.getName() + " where uid=?";
    public static final String SQL_QUERY_FIND_MESSAGE_BY_SESSION_ORDER_BY_DATE_ASC = "from " + ChatMessage.class.getName() + " as f where f.chatSession=? order by f.sendDate desc";
    public static final String SQL_QUERY_FIND_MESSAGE_COUNT_BY_FROM_USER = "select f.fromUser.uid, count(*) from " + ChatMessage.class.getName() + " as f where f.chatSession.uid=? group by f.fromUser";
    public static final String SQL_QUERY_FIND_MESSAGE_COUNT_BY_SESSION = "select f.chatSession.uid, count(*) from " + ChatMessage.class.getName() + " as f where f.chatSession.chat.uid=? group by f.chatSession";

    @Override
    public void saveOrUpdate(ChatMessage chatMessage) {
        this.getHibernateTemplate().saveOrUpdate((Object)chatMessage);
        this.getHibernateTemplate().flush();
    }

    @Override
    public List getForUser(ChatUser chatUser) {
        return this.getHibernateTemplate().find(SQL_QUERY_FIND_USER_MESSAGE_HISTORY, new Object[]{chatUser.getChatSession().getUid(), chatUser.getUid(), chatUser.getUid()});
    }

    @Override
    public ChatMessage getByUID(Long uid) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_FIND_MESSAGE_BY_UID, new Object[]{uid});
        if (list != null && list.size() > 0) {
            return (ChatMessage)list.get(0);
        }
        return null;
    }

    @Override
    public List getLatest(ChatSession chatSession, int max) {
        try {
            Query query = this.getSession().createQuery(SQL_QUERY_FIND_MESSAGE_BY_SESSION_ORDER_BY_DATE_ASC);
            query.setLong(0, chatSession.getUid().longValue());
            query.setMaxResults(max);
            return query.list();
        }
        catch (HibernateException he) {
            this.logger.error((Object)"getLatest: hibernate exception");
            return null;
        }
    }

    @Override
    public Map<Long, Integer> getCountBySession(Long chatUID) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_FIND_MESSAGE_COUNT_BY_SESSION, new Object[]{chatUID});
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        for (Object[] row : list) {
            resultMap.put((Long)row[0], (Integer)row[1]);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getCountByFromUser(Long sessionUID) {
        List list = this.getHibernateTemplate().find(SQL_QUERY_FIND_MESSAGE_COUNT_BY_FROM_USER, new Object[]{sessionUID});
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        for (Object[] row : list) {
            resultMap.put((Long)row[0], (Integer)row[1]);
        }
        return resultMap;
    }
}

