/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.web.actions;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.chat.model.Chat;
import org.lamsfoundation.lams.tool.chat.model.ChatAttachment;
import org.lamsfoundation.lams.tool.chat.service.ChatServiceProxy;
import org.lamsfoundation.lams.tool.chat.service.IChatService;
import org.lamsfoundation.lams.tool.chat.web.forms.AuthoringForm;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.util.SessionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(AuthoringAction.class);
    public IChatService chatService;
    private static final String KEY_TOOL_CONTENT_ID = "toolContentID";
    private static final String KEY_CONTENT_FOLDER_ID = "contentFolderID";
    private static final String KEY_MODE = "mode";
    private static final String KEY_ONLINE_FILES = "onlineFiles";
    private static final String KEY_OFFLINE_FILES = "offlineFiles";
    private static final String KEY_UNSAVED_ONLINE_FILES = "unsavedOnlineFiles";
    private static final String KEY_UNSAVED_OFFLINE_FILES = "unsavedOfflineFiles";
    private static final String KEY_DELETED_FILES = "deletedFiles";

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Chat chat;
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)KEY_TOOL_CONTENT_ID));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)KEY_CONTENT_FOLDER_ID);
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)KEY_MODE, (boolean)true);
        if (this.chatService == null) {
            this.chatService = ChatServiceProxy.getChatService(this.getServlet().getServletContext());
        }
        if ((chat = this.chatService.getChatByContentId(toolContentID)) == null) {
            chat = this.chatService.copyDefaultContent(toolContentID);
            chat.setCreateDate(new Date());
            this.chatService.saveOrUpdateChat(chat);
        }
        if (mode != null && mode.isTeacher()) {
            chat.setDefineLater(true);
            this.chatService.saveOrUpdateChat(chat);
        }
        AuthoringForm authForm = (AuthoringForm)form;
        this.updateAuthForm(authForm, chat);
        SessionMap<String, Object> map = this.createSessionMap(chat, this.getAccessMode(request), contentFolderID, toolContentID);
        authForm.setSessionMapID(map.getSessionID());
        request.getSession().setAttribute(map.getSessionID(), map);
        request.setAttribute("sessionMap", map);
        return mapping.findForward("success");
    }

    public ActionForward updateContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AuthoringForm authForm = (AuthoringForm)form;
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        Chat chat = this.chatService.getChatByContentId((Long)map.get((Object)KEY_TOOL_CONTENT_ID));
        ToolAccessMode mode = (ToolAccessMode)map.get((Object)KEY_MODE);
        this.updateChat(chat, authForm, mode);
        HashSet<ChatAttachment> attachments = chat.getChatAttachments();
        if (attachments == null) {
            attachments = new HashSet<ChatAttachment>();
        }
        for (ChatAttachment att : this.getAttList(KEY_DELETED_FILES, map)) {
            attachments.remove(att);
        }
        attachments.addAll(this.getAttList(KEY_UNSAVED_ONLINE_FILES, map));
        attachments.addAll(this.getAttList(KEY_UNSAVED_OFFLINE_FILES, map));
        chat.setChatAttachments(attachments);
        chat.setUpdateDate(new Date());
        chat.setDefineLater(false);
        this.chatService.saveOrUpdateChat(chat);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        authForm.setSessionMapID(map.getSessionID());
        request.setAttribute("sessionMap", map);
        return mapping.findForward("success");
    }

    public ActionForward uploadOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward uploadOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    public ActionForward deleteOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward deleteOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    public ActionForward removeUnsavedOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.removeUnsaved(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward removeUnsavedOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.removeUnsaved(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    private ActionForward uploadFile(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        List<ChatAttachment> savedFiles;
        List<ChatAttachment> unsavedFiles;
        FormFile file;
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        if (StringUtils.equals((String)"OFFLINE", (String)type)) {
            file = authForm.getOfflineFile();
            unsavedFiles = this.getAttList(KEY_UNSAVED_OFFLINE_FILES, map);
            savedFiles = this.getAttList(KEY_OFFLINE_FILES, map);
        } else {
            file = authForm.getOnlineFile();
            unsavedFiles = this.getAttList(KEY_UNSAVED_ONLINE_FILES, map);
            savedFiles = this.getAttList(KEY_ONLINE_FILES, map);
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)file, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            request.setAttribute("sessionMap", map);
            this.saveErrors(request, errors);
            return mapping.findForward("success");
        }
        if (file.getFileName().length() != 0) {
            ChatAttachment newAtt = this.chatService.uploadFileToContent((Long)map.get((Object)KEY_TOOL_CONTENT_ID), file, type);
            Iterator<ChatAttachment> iter = savedFiles.iterator();
            while (iter.hasNext()) {
                ChatAttachment currAtt = iter.next();
                if (!StringUtils.equals((String)currAtt.getFileName(), (String)newAtt.getFileName()) || !StringUtils.equals((String)currAtt.getFileType(), (String)newAtt.getFileType())) continue;
                this.getAttList(KEY_DELETED_FILES, map).add(currAtt);
                iter.remove();
                break;
            }
            unsavedFiles.add(newAtt);
            request.setAttribute("sessionMap", map);
            request.setAttribute("unsavedChanges", (Object)new Boolean(true));
        }
        return mapping.findForward("success");
    }

    private ActionForward deleteFile(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        List<ChatAttachment> fileList = StringUtils.equals((String)"OFFLINE", (String)type) ? this.getAttList(KEY_OFFLINE_FILES, map) : this.getAttList(KEY_ONLINE_FILES, map);
        Iterator<ChatAttachment> iter = fileList.iterator();
        while (iter.hasNext()) {
            ChatAttachment att = iter.next();
            if (!att.getFileUuid().equals(authForm.getDeleteFileUuid())) continue;
            this.getAttList(KEY_DELETED_FILES, map).add(att);
            iter.remove();
            break;
        }
        request.setAttribute("sessionMap", map);
        request.setAttribute("unsavedChanges", (Object)new Boolean(true));
        return mapping.findForward("success");
    }

    private ActionForward removeUnsaved(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        List<ChatAttachment> unsavedFiles = StringUtils.equals((String)"OFFLINE", (String)type) ? this.getAttList(KEY_UNSAVED_OFFLINE_FILES, map) : this.getAttList(KEY_UNSAVED_ONLINE_FILES, map);
        Iterator<ChatAttachment> iter = unsavedFiles.iterator();
        while (iter.hasNext()) {
            ChatAttachment att = iter.next();
            if (!att.getFileUuid().equals(authForm.getDeleteFileUuid())) continue;
            this.chatService.deleteFromRepository(att.getFileUuid(), att.getFileVersionId());
            iter.remove();
            break;
        }
        request.setAttribute("sessionMap", map);
        request.setAttribute("unsavedChanges", (Object)new Boolean(true));
        return mapping.findForward("success");
    }

    private void updateChat(Chat chat, AuthoringForm authForm, ToolAccessMode mode) {
        chat.setTitle(authForm.getTitle());
        chat.setInstructions(authForm.getInstructions());
        if (mode.isAuthor()) {
            chat.setOfflineInstructions(authForm.getOfflineInstruction());
            chat.setOnlineInstructions(authForm.getOnlineInstruction());
            chat.setLockOnFinished(authForm.isLockOnFinished());
            chat.setReflectOnActivity(authForm.isReflectOnActivity());
            chat.setReflectInstructions(authForm.getReflectInstructions());
            chat.setFilteringEnabled(authForm.isFilteringEnabled());
            chat.setFilterKeywords(authForm.getFilterKeywords());
        }
    }

    private void updateAuthForm(AuthoringForm authForm, Chat chat) {
        authForm.setTitle(chat.getTitle());
        authForm.setInstructions(chat.getInstructions());
        authForm.setOnlineInstruction(chat.getOnlineInstructions());
        authForm.setOfflineInstruction(chat.getOfflineInstructions());
        authForm.setLockOnFinished(chat.isLockOnFinished());
        authForm.setReflectOnActivity(chat.isReflectOnActivity());
        authForm.setReflectInstructions(chat.getReflectInstructions());
        authForm.setFilteringEnabled(chat.isFilteringEnabled());
        authForm.setFilterKeywords(chat.getFilterKeywords());
    }

    private SessionMap<String, Object> createSessionMap(Chat chat, ToolAccessMode mode, String contentFolderID, Long toolContentID) {
        SessionMap map = new SessionMap();
        map.put((Object)KEY_MODE, (Object)mode);
        map.put((Object)KEY_CONTENT_FOLDER_ID, (Object)contentFolderID);
        map.put((Object)KEY_TOOL_CONTENT_ID, (Object)toolContentID);
        map.put((Object)KEY_ONLINE_FILES, new LinkedList());
        map.put((Object)KEY_OFFLINE_FILES, new LinkedList());
        map.put((Object)KEY_UNSAVED_ONLINE_FILES, new LinkedList());
        map.put((Object)KEY_UNSAVED_OFFLINE_FILES, new LinkedList());
        map.put((Object)KEY_DELETED_FILES, new LinkedList());
        for (ChatAttachment attachment : chat.getChatAttachments()) {
            String type = attachment.getFileType();
            if (type.equals("OFFLINE")) {
                this.getAttList(KEY_OFFLINE_FILES, (SessionMap<String, Object>)map).add(attachment);
            }
            if (!type.equals("ONLINE")) continue;
            this.getAttList(KEY_ONLINE_FILES, (SessionMap<String, Object>)map).add(attachment);
        }
        return map;
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter(KEY_MODE);
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    private List<ChatAttachment> getAttList(String key, SessionMap<String, Object> map) {
        List list = (List)map.get((Object)key);
        return list;
    }

    private SessionMap<String, Object> getSessionMap(HttpServletRequest request, AuthoringForm authForm) {
        return (SessionMap)request.getSession().getAttribute(authForm.getSessionMapID());
    }
}

