/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.hibernate.Hibernate;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.type.Type;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.RepositoryProxy;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.chat.dao.IChatAttachmentDAO;
import org.lamsfoundation.lams.tool.chat.dao.IChatDAO;
import org.lamsfoundation.lams.tool.chat.dao.IChatMessageDAO;
import org.lamsfoundation.lams.tool.chat.dao.IChatSessionDAO;
import org.lamsfoundation.lams.tool.chat.dao.IChatUserDAO;
import org.lamsfoundation.lams.tool.chat.dto.ChatMessageDTO;
import org.lamsfoundation.lams.tool.chat.model.Chat;
import org.lamsfoundation.lams.tool.chat.model.ChatAttachment;
import org.lamsfoundation.lams.tool.chat.model.ChatMessage;
import org.lamsfoundation.lams.tool.chat.model.ChatSession;
import org.lamsfoundation.lams.tool.chat.model.ChatUser;
import org.lamsfoundation.lams.tool.chat.service.IChatService;
import org.lamsfoundation.lams.tool.chat.util.ChatException;
import org.lamsfoundation.lams.tool.chat.util.ChatMessageFilter;
import org.lamsfoundation.lams.tool.chat.util.ChatToolContentHandler;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatService
implements ToolSessionManager,
ToolContentManager,
ToolContentImport102Manager,
IChatService {
    static Logger logger = Logger.getLogger((String)ChatService.class.getName());
    private IChatDAO chatDAO = null;
    private IChatSessionDAO chatSessionDAO = null;
    private IChatUserDAO chatUserDAO = null;
    private IChatMessageDAO chatMessageDAO = null;
    private IChatAttachmentDAO chatAttachmentDAO = null;
    private ILearnerService learnerService;
    private ILamsToolService toolService;
    private IToolContentHandler chatToolContentHandler = null;
    private IRepositoryService repositoryService = null;
    private IAuditService auditService = null;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;
    private IdentifierGenerator idGenerator;
    private Map<Long, ChatMessageFilter> messageFilters = new ConcurrentHashMap<Long, ChatMessageFilter>();

    public ChatService() {
        this.idGenerator = new UUIDHexGenerator();
        ((Configurable)this.idGenerator).configure((Type)Hibernate.STRING, new Properties(), null);
    }

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method createToolSession: toolSessionId = " + toolSessionId + " toolSessionName = " + toolSessionName + " toolContentId = " + toolContentId));
        }
        ChatSession session = new ChatSession();
        session.setSessionId(toolSessionId);
        session.setSessionName(toolSessionName);
        String jabberRoom = (String)((Object)this.idGenerator.generate(null, null)) + "@" + Configuration.get((String)ConfigurationKeys.XMPP_CONFERENCE);
        session.setJabberRoom(jabberRoom);
        session.setRoomCreated(false);
        Chat chat = this.chatDAO.getByContentId(toolContentId);
        session.setChat(chat);
        this.chatSessionDAO.saveOrUpdate(session);
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        this.chatSessionDAO.deleteBySessionID(toolSessionId);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return new TreeMap<String, ToolOutput>();
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return null;
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method copyToolContent: fromContentId=" + fromContentId + " toContentId=" + toContentId));
        }
        if (toContentId == null) {
            String error = "Failed to copy tool content: toContentID is null";
            throw new ToolException(error);
        }
        Chat fromContent = null;
        if (fromContentId != null) {
            fromContent = this.chatDAO.getByContentId(fromContentId);
        }
        if (fromContent == null) {
            fromContent = this.getDefaultContent();
        }
        Chat toContent = Chat.newInstance(fromContent, toContentId, this.chatToolContentHandler);
        this.chatDAO.saveOrUpdate(toContent);
    }

    public void setAsDefineLater(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Chat chat = this.chatDAO.getByContentId(toolContentId);
        if (chat == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        chat.setDefineLater(value);
        this.chatDAO.saveOrUpdate(chat);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Chat chat = this.chatDAO.getByContentId(toolContentId);
        if (chat == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        chat.setRunOffline(value);
        this.chatDAO.saveOrUpdate(chat);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        Chat chat = this.chatDAO.getByContentId(toolContentId);
        if (chat == null) {
            chat = this.getDefaultContent();
        }
        if (chat == null) {
            throw new DataMissingException("Unable to find default content for the chat tool");
        }
        chat = Chat.newInstance(chat, toolContentId, null);
        chat.setToolContentHandler(null);
        chat.setChatSessions(null);
        Set atts = chat.getChatAttachments();
        for (ChatAttachment att : atts) {
            att.setChat(null);
        }
        try {
            this.exportContentService.registerFileClassForExport(ChatAttachment.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)chat, this.chatToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(ChatAttachment.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.chatToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof Chat)) {
                throw new ImportToolContentException("Import Chat tool content failed. Deserialized object is " + toolPOJO);
            }
            Chat chat = (Chat)toolPOJO;
            chat.setToolContentId(toolContentId);
            chat.setCreateBy(new Long(newUserUid.longValue()));
            this.chatDAO.saveOrUpdate(chat);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId) throws ToolException {
        return new TreeMap<String, ToolOutputDefinition>();
    }

    @Override
    public Long getDefaultContentIdBySignature(String toolSignature) {
        Long toolContentId = null;
        toolContentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (toolContentId == null) {
            String error = "Could not retrieve default content id for this tool";
            logger.error((Object)error);
            throw new ChatException(error);
        }
        return toolContentId;
    }

    @Override
    public Chat getDefaultContent() {
        Long defaultContentID = this.getDefaultContentIdBySignature("lachat11");
        Chat defaultContent = this.getChatByContentId(defaultContentID);
        if (defaultContent == null) {
            String error = "Could not retrieve default content record for this tool";
            logger.error((Object)error);
            throw new ChatException(error);
        }
        return defaultContent;
    }

    @Override
    public Chat copyDefaultContent(Long newContentID) {
        if (newContentID == null) {
            String error = "Cannot copy the Chat tools default content: + newContentID is null";
            logger.error((Object)error);
            throw new ChatException(error);
        }
        Chat defaultContent = this.getDefaultContent();
        Chat newContent = new Chat();
        newContent = Chat.newInstance(defaultContent, newContentID, this.chatToolContentHandler);
        this.chatDAO.saveOrUpdate(newContent);
        return newContent;
    }

    @Override
    public Chat getChatByContentId(Long toolContentID) {
        Chat chat = this.chatDAO.getByContentId(toolContentID);
        if (chat == null) {
            logger.debug((Object)("Could not find the content with toolContentID:" + toolContentID));
        }
        return chat;
    }

    @Override
    public ChatSession getSessionBySessionId(Long toolSessionId) {
        ChatSession chatSession = this.chatSessionDAO.getBySessionId(toolSessionId);
        if (chatSession == null) {
            logger.debug((Object)("Could not find the chat session with toolSessionID:" + toolSessionId));
        }
        return chatSession;
    }

    @Override
    public ChatSession getSessionByJabberRoom(String jabberRoom) {
        ChatSession chatSession = this.chatSessionDAO.getByJabberRoom(jabberRoom);
        if (chatSession == null) {
            logger.debug((Object)("Could not find the chat session with jabberRoom:" + jabberRoom));
        }
        return chatSession;
    }

    @Override
    public ChatUser getUserByUserIdAndSessionId(Long userId, Long toolSessionId) {
        return this.chatUserDAO.getByUserIdAndSessionId(userId, toolSessionId);
    }

    @Override
    public ChatUser getUserByLoginNameAndSessionId(String loginName, Long toolSessionId) {
        return this.chatUserDAO.getByLoginNameAndSessionId(loginName, toolSessionId);
    }

    @Override
    public ChatUser getUserByJabberIDAndJabberRoom(String jabberID, String jabberRoom) {
        return this.chatUserDAO.getByJabberIDAndJabberRoom(jabberID, jabberRoom);
    }

    @Override
    public ChatUser getUserByUID(Long uid) {
        return this.chatUserDAO.getByUID(uid);
    }

    @Override
    public ChatUser getUserByJabberNicknameAndSessionID(String jabberNickname, Long sessionID) {
        return this.chatUserDAO.getByJabberNicknameAndSessionID(jabberNickname, sessionID);
    }

    @Override
    public List getMessagesForUser(ChatUser chatUser) {
        return this.chatMessageDAO.getForUser(chatUser);
    }

    @Override
    public ChatAttachment uploadFileToContent(Long toolContentId, FormFile file, String type) {
        if (file == null || StringUtils.isEmpty((String)file.getFileName())) {
            throw new ChatException("Could not find upload file: " + file);
        }
        NodeKey nodeKey = this.processFile(file, type);
        ChatAttachment attachment = new ChatAttachment();
        attachment.setFileType(type);
        attachment.setFileUuid(nodeKey.getUuid());
        attachment.setFileVersionId(nodeKey.getVersion());
        attachment.setFileName(file.getFileName());
        attachment.setCreateDate(new Date());
        return attachment;
    }

    @Override
    public void deleteFromRepository(Long uuid, Long versionID) throws ChatException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, uuid, versionID);
        }
        catch (Exception e) {
            throw new ChatException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public void deleteInstructionFile(Long contentID, Long uuid, Long versionID, String type) {
        this.chatDAO.deleteInstructionFile(contentID, uuid, versionID, type);
    }

    @Override
    public void saveOrUpdateChat(Chat chat) {
        this.updateMessageFilters(chat);
        this.chatDAO.saveOrUpdate(chat);
    }

    @Override
    public void saveOrUpdateChatSession(ChatSession chatSession) {
        this.chatSessionDAO.saveOrUpdate(chatSession);
    }

    @Override
    public void saveOrUpdateChatUser(ChatUser chatUser) {
        this.chatUserDAO.saveOrUpdate(chatUser);
    }

    @Override
    public void saveOrUpdateChatMessage(ChatMessage chatMessage) {
        this.chatMessageDAO.saveOrUpdate(chatMessage);
    }

    @Override
    public synchronized ChatUser createChatUser(UserDTO user, ChatSession chatSession) {
        ChatUser chatUser = new ChatUser(user, chatSession);
        chatUser.setJabberId(this.createJabberId(user));
        chatUser.setJabberNickname(this.createJabberNickname(chatUser));
        this.saveOrUpdateChatUser(chatUser);
        return chatUser;
    }

    public String createJabberNickname(ChatUser chatUser) {
        String desiredJabberNickname;
        String jabberNickname = desiredJabberNickname = chatUser.getFirstName() + " " + chatUser.getLastName();
        boolean valid = false;
        int count = 1;
        while (!valid) {
            if (this.getUserByJabberNicknameAndSessionID(jabberNickname, chatUser.getChatSession().getSessionId()) == null) {
                valid = true;
                continue;
            }
            jabberNickname = desiredJabberNickname + " " + count;
            ++count;
        }
        return jabberNickname;
    }

    @Override
    public void createJabberRoom(ChatSession chatSession) {
        try {
            XMPPConnection.DEBUG_ENABLED = false;
            XMPPConnection con = new XMPPConnection(Configuration.get((String)ConfigurationKeys.XMPP_DOMAIN));
            con.login(Configuration.get((String)ConfigurationKeys.XMPP_ADMIN), Configuration.get((String)ConfigurationKeys.XMPP_PASSWORD));
            MultiUserChat muc = new MultiUserChat(con, chatSession.getJabberRoom());
            muc.create("nick");
            Form form = muc.getConfigurationForm();
            Form submitForm = form.createAnswerForm();
            Iterator fields = form.getFields();
            while (fields.hasNext()) {
                FormField field = (FormField)fields.next();
                if ("hidden".equals(field.getType()) || field.getVariable() == null) continue;
                submitForm.setDefaultAnswer(field.getVariable());
            }
            submitForm.setAnswer("muc#roomconfig_persistentroom", true);
            muc.sendConfigurationForm(submitForm);
            chatSession.setRoomCreated(true);
            con.close();
        }
        catch (XMPPException e) {
            logger.error((Object)e);
            logger.error((Object)e.getXMPPError());
        }
    }

    @Override
    public void processIncomingMessages(NodeList messageElems) {
        for (int i = 0; i < messageElems.getLength(); ++i) {
            Long userId;
            String jabberRoom;
            Node message = messageElems.item(i);
            NamedNodeMap nnm = message.getAttributes();
            Node from = nnm.getNamedItem("from");
            Node to = nnm.getNamedItem("to");
            Node type = nnm.getNamedItem("type");
            Node body = this.getBodyElement(message);
            ChatMessage chatMessage = new ChatMessage();
            String toNick = "";
            if (type.getNodeValue().equals("chat")) {
                int index = to.getNodeValue().lastIndexOf("/");
                if (index == -1) {
                    logger.debug((Object)("processIncomingMessages: malformed 'to' attribute :" + to.getNodeValue()));
                    return;
                }
                jabberRoom = to.getNodeValue().substring(0, index);
                toNick = to.getNodeValue().substring(index + 1);
            } else if (type.getNodeValue().equals("groupchat")) {
                jabberRoom = to.getNodeValue();
            } else {
                logger.debug((Object)("processIncomingMessages: unknown type: " + type.getNodeValue()));
                return;
            }
            ChatSession chatSession = this.getSessionByJabberRoom(jabberRoom);
            ChatUser toChatUser = this.getUserByJabberNicknameAndSessionID(toNick, chatSession.getSessionId());
            chatMessage.setChatSession(chatSession);
            chatMessage.setToUser(toChatUser);
            int index = from.getNodeValue().lastIndexOf("@");
            if (index == -1) {
                logger.debug((Object)("processIncomingMessages: malformed 'from' attribute :" + from.getNodeValue()));
                return;
            }
            String JidUsername = from.getNodeValue().substring(0, index);
            try {
                userId = new Long(JidUsername);
            }
            catch (NumberFormatException e) {
                logger.debug((Object)("processIncomingMessages: malformed JID username: " + JidUsername));
                return;
            }
            ChatUser fromUser = this.getUserByUserIdAndSessionId(userId, chatSession.getSessionId());
            chatMessage.setFromUser(fromUser);
            chatMessage.setType(type.getNodeValue());
            Node bodyText = body.getFirstChild();
            String bodyTextStr = "";
            if (bodyText != null) {
                bodyTextStr = bodyText.getNodeValue();
            }
            chatMessage.setBody(bodyTextStr);
            chatMessage.setSendDate(new Date());
            chatMessage.setHidden(Boolean.FALSE);
            this.saveOrUpdateChatMessage(chatMessage);
        }
    }

    @Override
    public List<Node> processIncomingPresence(Node presence) {
        NamedNodeMap nnm = presence.getAttributes();
        Node from = nnm.getNamedItem("from");
        Node to = nnm.getNamedItem("to");
        if (from == null || to == null) {
            logger.debug((Object)"malformed presence xml: no from or to attributes present");
            return null;
        }
        String jabberID = from.getNodeValue().split("/")[0];
        String jabberRoom = to.getNodeValue().split("/")[0];
        ChatUser chatUser = this.getUserByJabberIDAndJabberRoom(jabberID, jabberRoom);
        List chatMessageList = this.getMessagesForUser(chatUser);
        logger.debug((Object)("MESSAGE COUNT" + chatMessageList.size()));
        ArrayList<Node> xmlMessageList = new ArrayList<Node>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            for (ChatMessage message : chatMessageList) {
                Element messageElement = document.createElement("message");
                messageElement.setAttribute("from", jabberRoom + "/" + message.getFromUser().getJabberNickname());
                messageElement.setAttribute("to", jabberID + "/lams_chatclient");
                messageElement.setAttribute("type", message.getType());
                Element bodyElement = document.createElement("body");
                Text bodyText = document.createTextNode(message.getBody());
                bodyElement.appendChild(bodyText);
                Element xElement = document.createElement("x");
                xElement.setAttribute("xmlns", "jabber:x:delay");
                xElement.setAttribute("stamp", "TODO");
                xElement.setAttribute("from", jabberRoom + "/" + message.getFromUser().getJabberNickname());
                messageElement.appendChild(bodyElement);
                messageElement.appendChild(xElement);
                this.filterMessage(messageElement, chatUser.getChatSession().getChat());
                xmlMessageList.add(messageElement);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            logger.debug((Object)"parser configuration exception");
            return null;
        }
        return xmlMessageList;
    }

    private void printXMLNode(Node node, String tab) {
        System.out.print(tab + node.getNodeName() + ":");
        NamedNodeMap nnm = node.getAttributes();
        for (int j = 0; j < nnm.getLength(); ++j) {
            Node m = nnm.item(j);
            System.out.print(" " + m.getNodeName() + "=" + m.getNodeValue());
        }
        System.out.print(" => " + node.getNodeValue() + "\n");
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            this.printXMLNode(n, tab + "    ");
        }
    }

    @Override
    public void filterMessage(Node message, Chat chat) {
        Pattern pattern = this.getFilterPattern(chat);
        if (pattern == null) {
            return;
        }
        Node body = this.getBodyElement(message);
        if (body == null) {
            return;
        }
        Node bodyText = body.getFirstChild();
        if (bodyText == null) {
            return;
        }
        Matcher matcher = pattern.matcher(bodyText.getNodeValue());
        bodyText.setNodeValue(matcher.replaceAll("***"));
    }

    @Override
    public void filterMessage(Node message) {
        NamedNodeMap nnm = message.getAttributes();
        String from = nnm.getNamedItem("from").getNodeValue();
        int index = from.lastIndexOf("/");
        String jabberRoom = index != -1 ? from.substring(0, index) : from;
        Chat chat = this.getSessionByJabberRoom(jabberRoom).getChat();
        this.filterMessage(message, chat);
    }

    @Override
    public void filterMessage(ChatMessageDTO messageDTO, Chat chat) {
        Pattern pattern = this.getFilterPattern(chat);
        if (pattern == null) {
            return;
        }
        Matcher matcher = pattern.matcher(messageDTO.getBody());
        messageDTO.setBody(matcher.replaceAll("***"));
    }

    private Pattern getFilterPattern(Chat chat) {
        Pattern pattern;
        if (!chat.isFilteringEnabled()) {
            return null;
        }
        ChatMessageFilter filter = this.messageFilters.get(chat.getToolContentId());
        if (filter == null) {
            filter = this.updateMessageFilters(chat);
        }
        if ((pattern = filter.getPattern()) == null) {
            return null;
        }
        return pattern;
    }

    @Override
    public ChatMessageFilter updateMessageFilters(Chat chat) {
        ChatMessageFilter filter = new ChatMessageFilter(chat);
        this.messageFilters.put(chat.getToolContentId(), filter);
        return filter;
    }

    @Override
    public ChatMessage getMessageByUID(Long messageUID) {
        return this.chatMessageDAO.getByUID(messageUID);
    }

    @Override
    public List getLastestMessages(ChatSession chatSession, int max) {
        return this.chatMessageDAO.getLatest(chatSession, max);
    }

    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public void auditEditMessage(ChatMessage chatMessage, String messageBody) {
        this.auditService.logChange("lachat11", chatMessage.getFromUser().getUserId(), chatMessage.getFromUser().getLoginName(), chatMessage.getBody(), messageBody);
    }

    @Override
    public void auditHideShowMessage(ChatMessage chatMessage, boolean messageHidden) {
        if (messageHidden) {
            this.auditService.logHideEntry("lachat11", chatMessage.getFromUser().getUserId(), chatMessage.getFromUser().getLoginName(), chatMessage.toString());
        } else {
            this.auditService.logShowEntry("lachat11", chatMessage.getFromUser().getUserId(), chatMessage.getFromUser().getLoginName(), chatMessage.toString());
        }
    }

    private Node getBodyElement(Node message) {
        NodeList nl = message.getChildNodes();
        Node body = null;
        for (int j = 0; j < nl.getLength(); ++j) {
            Node msgChild = nl.item(j);
            if (msgChild.getNodeName() != "body") continue;
            body = msgChild;
            break;
        }
        return body;
    }

    private String createJabberId(UserDTO user) {
        try {
            XMPPConnection con = new XMPPConnection(Configuration.get((String)ConfigurationKeys.XMPP_DOMAIN));
            AccountManager manager = con.getAccountManager();
            if (manager.supportsAccountCreation()) {
                manager.createAccount(user.getUserID().toString(), user.getUserID().toString());
            }
        }
        catch (XMPPException e) {
            logger.error((Object)e);
        }
        return user.getUserID() + "@" + Configuration.get((String)ConfigurationKeys.XMPP_DOMAIN);
    }

    private NodeKey processFile(FormFile file, String type) {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.getChatToolContentHandler().uploadFile(file.getInputStream(), fileName, file.getContentType(), type);
            }
            catch (InvalidParameterException e) {
                throw new ChatException("InvalidParameterException occured while trying to upload File" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new ChatException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (RepositoryCheckedException e) {
                throw new ChatException("RepositoryCheckedException occured while trying to upload File" + e.getMessage());
            }
            catch (IOException e) {
                throw new ChatException("IOException occured while trying to upload File" + e.getMessage());
            }
        }
        return node;
    }

    private ITicket getRepositoryLoginTicket() throws ChatException {
        this.repositoryService = RepositoryProxy.getRepositoryService();
        SimpleCredentials credentials = new SimpleCredentials(ChatToolContentHandler.repositoryUser, ChatToolContentHandler.repositoryId);
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, ChatToolContentHandler.repositoryWorkspaceName);
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new ChatException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new ChatException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new ChatException("Login failed." + e.getMessage());
        }
    }

    public IChatAttachmentDAO getChatAttachmentDAO() {
        return this.chatAttachmentDAO;
    }

    public void setChatAttachmentDAO(IChatAttachmentDAO attachmentDAO) {
        this.chatAttachmentDAO = attachmentDAO;
    }

    public IChatDAO getChatDAO() {
        return this.chatDAO;
    }

    public void setChatDAO(IChatDAO chatDAO) {
        this.chatDAO = chatDAO;
    }

    public IToolContentHandler getChatToolContentHandler() {
        return this.chatToolContentHandler;
    }

    public void setChatToolContentHandler(IToolContentHandler chatToolContentHandler) {
        this.chatToolContentHandler = chatToolContentHandler;
    }

    public IChatSessionDAO getChatSessionDAO() {
        return this.chatSessionDAO;
    }

    public void setChatSessionDAO(IChatSessionDAO sessionDAO) {
        this.chatSessionDAO = sessionDAO;
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IChatUserDAO getChatUserDAO() {
        return this.chatUserDAO;
    }

    public void setChatUserDAO(IChatUserDAO userDAO) {
        this.chatUserDAO = userDAO;
    }

    public IChatMessageDAO getChatMessageDAO() {
        return this.chatMessageDAO;
    }

    public void setChatMessageDAO(IChatMessageDAO messageDAO) {
        this.chatMessageDAO = messageDAO;
    }

    public ILearnerService getLearnerService() {
        return this.learnerService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    @Override
    public Map<Long, Integer> getMessageCountBySession(Long chatUID) {
        return this.chatMessageDAO.getCountBySession(chatUID);
    }

    @Override
    public Map<Long, Integer> getMessageCountByFromUser(Long sessionUID) {
        return this.chatMessageDAO.getCountByFromUser(sessionUID);
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String entry) {
        return this.coreNotebookService.createNotebookEntry(id, idType, signature, userID, "", entry);
    }

    @Override
    public NotebookEntry getEntry(Long id, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(id, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        Chat chat = new Chat();
        chat.setContentInUse(Boolean.FALSE);
        chat.setCreateBy(new Long(user.getUserID().longValue()));
        chat.setCreateDate(now);
        chat.setDefineLater(Boolean.FALSE);
        chat.setFilterKeywords(null);
        chat.setFilteringEnabled(Boolean.FALSE);
        chat.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
        chat.setLockOnFinished(Boolean.FALSE);
        chat.setOfflineInstructions(null);
        chat.setOnlineInstructions(null);
        chat.setReflectInstructions(null);
        chat.setReflectOnActivity(Boolean.FALSE);
        chat.setRunOffline(Boolean.FALSE);
        chat.setTitle((String)importValues.get("title"));
        chat.setToolContentId(toolContentId);
        chat.setUpdateDate(now);
        try {
            Boolean isReusable = WDDXProcessor.convertToBoolean((Hashtable)importValues, (String)"isReusable");
            chat.setLockOnFinished(isReusable != null ? !isReusable.booleanValue() : true);
        }
        catch (WDDXProcessorConversionException e) {
            logger.error((Object)("Unable to content for activity " + chat.getTitle() + "properly due to a WDDXProcessorConversionException."), (Throwable)e);
            throw new ToolException("Invalid import data format for activity " + chat.getTitle() + "- WDDX caused an exception. Some data from the design will have been lost. See log for more details.");
        }
        this.chatDAO.saveOrUpdate(chat);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        Chat chat = this.getChatByContentId(toolContentId);
        if (chat == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        chat.setReflectOnActivity(Boolean.TRUE);
        chat.setReflectInstructions(description);
    }
}

