/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.chat.dto;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.lamsfoundation.lams.tool.chat.dto.ChatMessageDTO;
import org.lamsfoundation.lams.tool.chat.dto.ChatUserDTO;
import org.lamsfoundation.lams.tool.chat.model.ChatMessage;
import org.lamsfoundation.lams.tool.chat.model.ChatSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatSessionDTO
implements Comparable {
    Long sessionID;
    String sessionName;
    Set<ChatMessageDTO> messageDTOs;
    Set<ChatUserDTO> userDTOs;
    int numberOfPosts;
    int numberOfLearners;

    public ChatSessionDTO(ChatSession session) {
        this.sessionID = session.getSessionId();
        this.sessionName = session.getSessionName();
        this.messageDTOs = new TreeSet<ChatMessageDTO>();
        Iterator i = session.getChatMessages().iterator();
        while (i.hasNext()) {
            this.messageDTOs.add(new ChatMessageDTO((ChatMessage)i.next()));
        }
        this.userDTOs = new TreeSet<ChatUserDTO>();
    }

    public ChatSessionDTO(ChatSession session, List messages) {
        this.sessionID = session.getSessionId();
        this.sessionName = session.getSessionName();
        this.messageDTOs = new TreeSet<ChatMessageDTO>();
        Iterator i = messages.iterator();
        while (i.hasNext()) {
            this.messageDTOs.add(new ChatMessageDTO((ChatMessage)i.next()));
        }
        this.userDTOs = new TreeSet<ChatUserDTO>();
    }

    public ChatSessionDTO() {
        this.userDTOs = new TreeSet<ChatUserDTO>();
        this.messageDTOs = new TreeSet<ChatMessageDTO>();
    }

    public Long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(Long sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public Set<ChatMessageDTO> getMessageDTOs() {
        return this.messageDTOs;
    }

    public void setMessageDTOs(Set<ChatMessageDTO> chatMessages) {
        this.messageDTOs = chatMessages;
    }

    public int compareTo(Object o) {
        ChatSessionDTO toSession = (ChatSessionDTO)o;
        int returnValue = this.sessionName.compareTo(toSession.sessionName);
        if (returnValue == 0) {
            returnValue = this.sessionID.compareTo(toSession.sessionID);
        }
        return returnValue;
    }

    public Set<ChatUserDTO> getUserDTOs() {
        return this.userDTOs;
    }

    public void setUserDTOs(Set<ChatUserDTO> chatUsers) {
        this.userDTOs = chatUsers;
    }

    public int getNumberOfLearners() {
        return this.numberOfLearners;
    }

    public void setNumberOfLearners(int numberOfLearners) {
        this.numberOfLearners = numberOfLearners;
    }

    public int getNumberOfPosts() {
        return this.numberOfPosts;
    }

    public void setNumberOfPosts(int numberOfPosts) {
        this.numberOfPosts = numberOfPosts;
    }
}

