/****************************************************************
 * Copyright (C) 2005 LAMS Foundation (http://lamsfoundation.org)
 * =============================================================
 * License Information: http://lamsfoundation.org/licensing/lams/2.0/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2.0 
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * 
 * http://www.gnu.org/licenses/gpl.txt
 * ****************************************************************
 */

/* $$Id: ReflectionForm.java,v 1.1 2006/08/31 06:39:03 steven Exp $$ */	
package org.lamsfoundation.lams.tool.rsrc.web.form;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.ValidatorForm;

/**
 *
 * 	Reflection Form.
 *	@struts.form name="reflectionForm"
 *
 */
public class ReflectionForm extends ValidatorForm {
	private static final long serialVersionUID = -9054365604649146735L;
	private static Logger logger = Logger.getLogger(ReflectionForm.class.getName());
	
	private Integer userID;
	private String sessionMapID;
	private String entryText;

    /**
     * MessageForm validation method from STRUCT interface.
     * 
     */
    public ActionErrors validate(ActionMapping mapping,
                                 javax.servlet.http.HttpServletRequest request) {
        ActionErrors errors = new ActionErrors(); 
        try{
            if (StringUtils.isBlank(entryText)) {
               ActionMessage error = new ActionMessage("error.reflection.emtpy");
               errors.add(ActionMessages.GLOBAL_MESSAGE, error);
            }
            
        } catch (Exception e) {
            logger.error(e);
        }
        return errors;
    }

	public String getEntryText() {
		return entryText;
	}

	public void setEntryText(String entryText) {
		this.entryText = entryText;
	}

	public Integer getUserID() {
		return userID;
	}

	public void setUserID(Integer userUid) {
		this.userID = userUid;
	}

	public String getSessionMapID() {
		return sessionMapID;
	}

	public void setSessionMapID(String sessionMapID) {
		this.sessionMapID = sessionMapID;
	}

}
