/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.vocab;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public class Vocabulary {
    private static Hashtable _vocabTable = new Hashtable();
    private Document _docVocab;
    private File _fileVocab;
    private HashMap _pathListMap = new HashMap();
    private TreeMap _vocabLists = new TreeMap();
    private String _defaultLanguage;

    public static Vocabulary getVocabulary(File fileVocab) throws JDOMException, IOException {
        if (fileVocab == null) {
            return null;
        }
        Vocabulary vocab = (Vocabulary)_vocabTable.get(fileVocab);
        if (vocab == null) {
            vocab = new Vocabulary(fileVocab);
            _vocabTable.put(fileVocab, vocab);
        }
        return vocab;
    }

    public Vocabulary(File fileVocab) throws JDOMException, IOException {
        this._fileVocab = fileVocab;
        this._docVocab = this.loadVocabularyFile(fileVocab);
        this.loadLists();
        this.setDefaultLanguage(this.getRootAttributeValue("lang"));
    }

    protected void loadLists() {
        this._vocabLists.put(VocabularyList.LANG_LISTNAME, VocabularyList.getLangList());
        this._vocabLists.put(VocabularyList.TRUEFALSE_LISTNAME, VocabularyList.getTrueFalseList());
        this._vocabLists.put(VocabularyList.YESNO_LISTNAME, VocabularyList.getYesNoList());
        Iterator vocablist = this._docVocab.getRootElement().getChildren("vocabList").iterator();
        while (vocablist.hasNext()) {
            Element vocabElement = (Element)vocablist.next();
            String vocabName = vocabElement.getAttributeValue("name");
            if (vocabName == null) {
                System.err.println("Vocab warning: vocabList has no name attribute.");
                break;
            }
            String defaultValue = vocabElement.getAttributeValue("default");
            List items = vocabElement.getChildren("item");
            String[] s = new String[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                Element e = (Element)items.get(i);
                s[i] = e.getText();
            }
            this._vocabLists.put(vocabName, new VocabularyList(vocabName, s, defaultValue));
        }
        Iterator elementlist = this._docVocab.getRootElement().getChildren("element").iterator();
        while (elementlist.hasNext()) {
            Element childElement = (Element)elementlist.next();
            String listPath = childElement.getAttributeValue("path");
            String listName = childElement.getAttributeValue("list");
            if (listPath != null && listName != null) {
                this._pathListMap.put(listPath, listName);
                continue;
            }
            System.err.println("Warning: Vocabulary - bad <element> tag");
        }
    }

    protected Document loadVocabularyFile(File fileVocab) throws JDOMException, IOException {
        return XMLUtils.readXMLFile((File)fileVocab);
    }

    public Document getVocabularyDocument() {
        return this._docVocab;
    }

    public String getVocabularyName() {
        return this._fileVocab == null ? "(unknown)" : this._fileVocab.getName();
    }

    public VocabularyList getVocabularyList(SchemaNode schemaNode) {
        if (schemaNode == null) {
            return null;
        }
        XMLPath nodePath = schemaNode.getXMLPath();
        return this.getVocabularyList(nodePath);
    }

    public VocabularyList getVocabularyList(XMLPath xmlPath) {
        VocabularyList vocabularyList = null;
        String path = xmlPath.getPath();
        String listName = (String)this._pathListMap.get(path);
        if (listName == null) {
            Iterator it = this._pathListMap.keySet().iterator();
            while (it.hasNext()) {
                String itPath = (String)it.next();
                if (!path.endsWith(itPath)) continue;
                listName = (String)this._pathListMap.get(itPath);
                break;
            }
        }
        if (listName != null && listName != VocabularyList.NONE_LISTNAME) {
            vocabularyList = (VocabularyList)this._vocabLists.get(listName);
        }
        return vocabularyList;
    }

    public VocabularyList getVocabularyList(String listName) {
        return (VocabularyList)this._vocabLists.get(listName);
    }

    public File getVocabFile() {
        return this._fileVocab;
    }

    public Collection getVocabularyLists() {
        return this._vocabLists.values();
    }

    public String getDefaultLanguage() {
        return this._defaultLanguage;
    }

    public void setDefaultLanguage(String language) {
        VocabularyList langList;
        if (language == null) {
            language = Locale.getDefault().getLanguage();
        }
        if ((langList = (VocabularyList)this._vocabLists.get(VocabularyList.LANG_LISTNAME)) != null) {
            langList.setDefaultValue(language);
        }
        this._defaultLanguage = language;
    }

    protected String getRootAttributeValue(String attName) {
        if (this._docVocab != null && this._docVocab.hasRootElement()) {
            Element root = this._docVocab.getRootElement();
            Attribute att = root.getAttribute(attName);
            return att == null ? null : att.getValue();
        }
        return null;
    }

    public String toString() {
        return this.getVocabularyName();
    }
}

