/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit;

import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.Namespace;
import uk.ac.reload.diva.undo.UndoHandler;
import uk.ac.reload.diva.undo.UndoableAction;
import uk.ac.reload.diva.util.RandomGUID;
import uk.ac.reload.jdom.XMLActiveDocument;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.Messages;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaAttribute;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaModel;

public abstract class SchemaDocument
extends XMLActiveDocument {
    private SchemaController _schemaController;
    private UndoHandler _undoHandler;

    public void setSchemaController(SchemaController schemaController) {
        this._schemaController = schemaController;
    }

    public SchemaController getSchemaController() {
        return this._schemaController;
    }

    public Namespace getRootNamespace() {
        Namespace ns = super.getRootNamespace();
        if (ns != null) {
            return ns;
        }
        return this.getTargetNamespace();
    }

    public Namespace getTargetNamespace() {
        SchemaModel schemaModel = this._schemaController.getSchemaModel();
        return Namespace.getNamespace((String)schemaModel.getTargetNamespaceURI());
    }

    public Element getElement(SchemaElement schemaElement) {
        if (schemaElement == null) {
            return null;
        }
        SchemaElement[] schemaElements = schemaElement.getSchemaElements();
        Element element = this.getDocument().getRootElement();
        if (schemaElements.length <= 1) {
            return element;
        }
        for (int i = 1; i < schemaElements.length; ++i) {
            if ((element = element.getChild(schemaElements[i].getName(), schemaElements[i].getNamespace())) != null) continue;
            return null;
        }
        return element;
    }

    public Element[] getElements(SchemaElement schemaElement) {
        if (schemaElement == null) {
            return null;
        }
        Element element = this.getElement(schemaElement);
        if (element == null) {
            return null;
        }
        Element parent = element.getParent();
        if (parent == null) {
            return new Element[]{element};
        }
        List list = element.getParent().getChildren(element.getName(), element.getNamespace());
        Element[] elements = new Element[list.size()];
        if (!list.isEmpty()) {
            list.toArray(elements);
        }
        return elements;
    }

    public String[] getComments() {
        return null;
    }

    protected void addCommentsToDocument() {
        String[] comments = this.getComments();
        if (comments != null) {
            for (int i = 0; i < comments.length; ++i) {
                Comment comment = new Comment(comments[i]);
                this.getDocument().addContent(comment);
            }
        }
    }

    public void destroy() {
        super.destroy();
        this._schemaController = null;
        this._undoHandler = null;
    }

    public Element addElementUniqueBySchema(Object source, SchemaElement newSchemaElement, boolean doSelect) {
        if (newSchemaElement == null) {
            return null;
        }
        SchemaElement[] schemaElements = newSchemaElement.getSchemaElements();
        if (schemaElements.length < 2) {
            return this.getDocument().getRootElement();
        }
        Element element = this.getDocument().getRootElement();
        for (int i = 1; i < schemaElements.length; ++i) {
            Element childElement = element.getChild(schemaElements[i].getName(), schemaElements[i].getNamespace());
            if (childElement == null) {
                childElement = this.addElementBySchema(source, element, schemaElements[i], doSelect);
            }
            element = childElement;
        }
        return element;
    }

    public Element addElementUniqueBySchemaUndoable(Object source, SchemaElement newSchemaElement, boolean doSelect) {
        if (newSchemaElement == null) {
            return null;
        }
        SchemaElement[] schemaElements = newSchemaElement.getSchemaElements();
        if (schemaElements.length < 2) {
            return this.getDocument().getRootElement();
        }
        Element element = this.getDocument().getRootElement();
        for (int i = 1; i < schemaElements.length; ++i) {
            Element childElement = element.getChild(schemaElements[i].getName(), schemaElements[i].getNamespace());
            if (childElement == null) {
                childElement = this.addElementBySchemaUndoable(source, element, schemaElements[i], doSelect);
            }
            element = childElement;
        }
        return element;
    }

    public Element addElementBySchemaUndoable(Object source, Element parentElement, SchemaElement childSchemaElement, boolean doSelect) {
        if (childSchemaElement == null) {
            return null;
        }
        Element newElement = this.addElementBySchema(source, parentElement, childSchemaElement, doSelect);
        if (this._undoHandler != null && newElement != null) {
            UndoableAddAction addAction = new UndoableAddAction(parentElement, newElement);
            this._undoHandler.addUndoableAction((UndoableAction)addAction);
        }
        return newElement;
    }

    public Element addElementBySchema(Object source, Element parentElement, SchemaElement childSchemaElement, boolean doSelect) {
        int i;
        if (childSchemaElement == null) {
            return null;
        }
        Namespace ns = parentElement == null ? this.getRootNamespace() : childSchemaElement.getNamespace();
        Element newElement = new Element(childSchemaElement.getName(), ns);
        String defaultValue = this.getSchemaController().getDefaultValue(childSchemaElement);
        if (defaultValue != null) {
            newElement.setText(defaultValue);
        }
        if (childSchemaElement.hasSchemaAttributes()) {
            SchemaAttribute[] atts = childSchemaElement.getSchemaAttributes();
            for (i = 0; i < atts.length; ++i) {
                if (!"required".equals(atts[i].getUse())) continue;
                Attribute att = atts[i].createAttribute();
                if (att.getName().equals("identifier")) {
                    att.setValue(this.generateUniqueID(newElement));
                } else {
                    String attValue = this.getSchemaController().getDefaultValue(atts[i]);
                    if (attValue == null) {
                        attValue = "";
                    }
                    att.setValue(attValue);
                }
                newElement.setAttribute(att);
            }
        }
        if (parentElement != null) {
            int index = this.getInsertPositionOfElement(parentElement, childSchemaElement);
            this.addElementAtIndex(source, parentElement, newElement, index, doSelect);
        }
        SchemaElement[] schemaChildren = childSchemaElement.getChildren();
        for (i = 0; i < schemaChildren.length; ++i) {
            SchemaElement child = schemaChildren[i];
            if (child.getMinOccurs() != 1 || child.isChoiceElement()) continue;
            this.addElementBySchema(source, newElement, child, doSelect);
        }
        return newElement;
    }

    public Element addElementByXMLPath(Object source, Element parentElement, XMLPath xmlChildPath, boolean doSelect) {
        Element element = null;
        Namespace ns = null;
        XMLPath xmlElementPath = XMLPath.getXMLPathForElement((Element)parentElement);
        StringTokenizer t = xmlChildPath.getElements();
        while (t.hasMoreElements()) {
            String path = t.nextToken();
            xmlElementPath.appendElementName(path);
            int idx = path.indexOf(58);
            if (idx >= 0) {
                String prefix = path.substring(0, idx);
                path = path.substring(idx + 1);
                ns = parentElement.getNamespace(prefix);
            } else {
                ns = parentElement.getNamespace();
            }
            element = parentElement.getChild(path, ns);
            if (element == null) {
                SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlElementPath);
                element = this.addElementBySchema(source, parentElement, schemaElement, doSelect);
            }
            parentElement = element;
        }
        return element;
    }

    public Element addElementUndoable(Object source, Element parentElement, Element childElement, boolean doSelect) {
        Element newElement = this.addElement(source, parentElement, childElement, doSelect);
        if (this._undoHandler != null && newElement != null) {
            UndoableAddAction addAction = new UndoableAddAction(parentElement, newElement);
            this._undoHandler.addUndoableAction((UndoableAction)addAction);
        }
        return newElement;
    }

    public Element addElement(Object source, Element parentElement, Element childElement, boolean doSelect) {
        int index = this.getInsertPositionOfElement(parentElement, childElement);
        return this.addElementAtIndex(source, parentElement, childElement, index, doSelect);
    }

    public synchronized Element deleteElementUndoable(Object source, Element element) {
        Element parent = element.getParent();
        if (parent != null) {
            UndoableDeleteAction action = null;
            if (this._undoHandler != null) {
                action = new UndoableDeleteAction(parent, element);
            }
            this.removeElement(source, element);
            if (this._undoHandler != null && action != null) {
                this._undoHandler.addUndoableAction((UndoableAction)action);
            }
        }
        return element;
    }

    public synchronized Element cutElementUndoable(Object source, Element element) {
        Element parent = element.getParent();
        if (parent != null) {
            UndoableCutAction action = null;
            if (this._undoHandler != null) {
                action = new UndoableCutAction(parent, element);
            }
            this.removeElement(source, element);
            if (this._undoHandler != null && action != null) {
                this._undoHandler.addUndoableAction((UndoableAction)action);
            }
        }
        return element;
    }

    public Element moveElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element oldParent = element.getParent();
        if (oldParent != null) {
            UndoableMoveAction action = null;
            if (this._undoHandler != null) {
                action = new UndoableMoveAction(oldParent, newParent, element);
            }
            this.removeElement(source, element);
            this.addElement((Object)this, newParent, element, doSelect);
            if (this._undoHandler != null && action != null) {
                this._undoHandler.addUndoableAction((UndoableAction)action);
            }
        }
        return element;
    }

    public Element copyElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element newElement = (Element)element.clone();
        this.addElement((Object)this, newParent, newElement, doSelect);
        if (this._undoHandler != null) {
            UndoableCopyAction action = new UndoableCopyAction(newParent, newElement);
            this._undoHandler.addUndoableAction((UndoableAction)action);
        }
        return newElement;
    }

    public Element pasteElementUndoable(Object source, Element element, Element newParent, boolean doSelect) {
        Element newElement = (Element)element.clone();
        this.addElement((Object)this, newParent, newElement, doSelect);
        if (this._undoHandler != null) {
            UndoablePasteAction action = new UndoablePasteAction(newParent, newElement);
            this._undoHandler.addUndoableAction((UndoableAction)action);
        }
        return newElement;
    }

    public String generateUniqueID(Element element) {
        String prefix = "RLD-";
        return RandomGUID.getUniqueID((String)prefix);
    }

    public boolean canAddElement(Element parentElement, SchemaElement childSchemaElement) {
        if (childSchemaElement == null) {
            return true;
        }
        int max = childSchemaElement.getMaxOccurs();
        if (max == -1) {
            return true;
        }
        List list = parentElement.getChildren(childSchemaElement.getName(), childSchemaElement.getNamespace());
        return list.size() < max;
    }

    public boolean isAllowedChild(Element parentElement, Element childElement) {
        if (!parentElement.getNamespace().equals((Object)childElement.getNamespace())) {
            return false;
        }
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)parentElement);
        SchemaElement parentSchemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        if (parentSchemaElement != null) {
            SchemaElement childSchemaElement = parentSchemaElement.getChild(childElement.getName());
            if (childSchemaElement == null) {
                return false;
            }
            return this.canAddElement(parentElement, childSchemaElement);
        }
        return false;
    }

    public boolean canDeleteElement(Element element) {
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)element);
        SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        if (schemaElement == null) {
            return true;
        }
        Element parentElement = element.getParent();
        if (parentElement == null) {
            return false;
        }
        List list = parentElement.getChildren(schemaElement.getName(), schemaElement.getNamespace());
        return list.size() > schemaElement.getMinOccurs();
    }

    public boolean canMoveElementUp(Element element) {
        int index;
        List children;
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)element);
        SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        if (schemaElement == null) {
            return false;
        }
        boolean isChoiceElement = schemaElement.isChoiceElement();
        Element parent = element.getParent();
        if (parent != null && (children = parent.getChildren()).size() > 1 && (index = children.indexOf(element)) > 0) {
            Element previousSibling = (Element)children.get(index - 1);
            if (isChoiceElement) {
                xmlPath = XMLPath.getXMLPathForElement((Element)previousSibling);
                SchemaElement schemaElement2 = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
                if (schemaElement2 != null && schemaElement.getElementDecl().getParent() == schemaElement2.getElementDecl().getParent()) {
                    return true;
                }
            } else if (previousSibling.getName().equals(element.getName()) && previousSibling.getNamespace().equals((Object)element.getNamespace())) {
                return true;
            }
        }
        return false;
    }

    public boolean canMoveElementDown(Element element) {
        int index;
        List children;
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)element);
        SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        if (schemaElement == null) {
            return false;
        }
        boolean isChoiceElement = schemaElement.isChoiceElement();
        Element parent = element.getParent();
        if (parent != null && (children = parent.getChildren()).size() > 1 && (index = children.indexOf(element)) < children.size() - 1) {
            Element nextSibling = (Element)children.get(index + 1);
            if (isChoiceElement) {
                xmlPath = XMLPath.getXMLPathForElement((Element)nextSibling);
                SchemaElement schemaElement2 = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
                if (schemaElement2 != null && schemaElement.getElementDecl().getParent() == schemaElement2.getElementDecl().getParent()) {
                    return true;
                }
            } else if (nextSibling.getName().equals(element.getName()) && nextSibling.getNamespace().equals((Object)element.getNamespace())) {
                return true;
            }
        }
        return false;
    }

    public Attribute addAttribute(Object source, Element parentElement, SchemaAttribute newSchemaAttribute) {
        if (parentElement == null || newSchemaAttribute == null) {
            return null;
        }
        Attribute att = newSchemaAttribute.createAttribute();
        if (att != null) {
            List list = parentElement.getAttributes();
            int index = this.getInsertPositionOfAttribute(parentElement, newSchemaAttribute);
            if (index < 0 || index > list.size()) {
                index = 0;
            }
            list.add(index, att);
        }
        return att;
    }

    protected Attribute addAttributeWithDefaultValue(Object source, Element parentElement, String attName) {
        String attValue;
        SchemaAttribute schemaAtt;
        Attribute att = null;
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)parentElement).appendAttributeName(attName);
        if (xmlPath != null && (schemaAtt = (SchemaAttribute)this.getSchemaController().getSchemaNode(xmlPath)) != null && (att = this.addAttribute(source, parentElement, schemaAtt)) != null && (attValue = this.getSchemaController().getDefaultValue(schemaAtt)) != null) {
            att.setValue(attValue);
        }
        return att;
    }

    public int getInsertPositionOfElement(Element parentElement, Element childElement) {
        XMLPath xmlPath = XMLPath.getXMLPathForElement((Element)parentElement);
        xmlPath.appendElementName(childElement.getName());
        SchemaElement schemaElement = (SchemaElement)this.getSchemaController().getSchemaNode(xmlPath);
        return this.getInsertPositionOfElement(parentElement, schemaElement);
    }

    public int getInsertPositionOfElement(Element parentElement, SchemaElement childSchemaElement) {
        if (childSchemaElement == null) {
            return parentElement.getChildren().size();
        }
        if (parentElement.getChildren().size() == 0) {
            return 0;
        }
        int index = 0;
        String name = childSchemaElement.getName();
        SchemaElement parentSchemaElement = (SchemaElement)childSchemaElement.getParent();
        if (parentSchemaElement == null) {
            parentSchemaElement = childSchemaElement;
        }
        SchemaElement[] schemaChildren = parentSchemaElement.getChildren();
        List children = parentElement.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element element = (Element)children.get(i);
            String elementName = element.getName();
            int pos = parentSchemaElement.indexofChild(elementName, element.getNamespace());
            if (pos == -1) continue;
            for (int j = pos; j < schemaChildren.length; ++j) {
                if (!name.equals(schemaChildren[j].getName())) continue;
                index = i + 1;
            }
        }
        return index;
    }

    public int getInsertPositionOfAttribute(Element parentElement, SchemaAttribute schemaAttribute) {
        int index = 0;
        List elementAtts = parentElement.getAttributes();
        if (elementAtts.size() == 0) {
            return 0;
        }
        String name = schemaAttribute.getName();
        SchemaElement parentSchemaElement = (SchemaElement)schemaAttribute.getParent();
        SchemaAttribute[] schemaAtts = parentSchemaElement.getSchemaAttributes();
        for (int i = 0; i < elementAtts.size(); ++i) {
            Attribute att = (Attribute)elementAtts.get(i);
            String attName = att.getName();
            int pos = parentSchemaElement.indexofSchemaAttribute(attName);
            if (pos != -1) {
                for (int j = pos; j < schemaAtts.length; ++j) {
                    if (!name.equals(schemaAtts[j].getName())) continue;
                    index = i + 1;
                }
                continue;
            }
            index = i + 1;
        }
        return index;
    }

    public void setUndoHandler(UndoHandler undoHandler) {
        this._undoHandler = undoHandler;
    }

    public UndoHandler getUndoHandler() {
        return this._undoHandler;
    }

    protected class UndoableMoveAction
    implements UndoableAction {
        Element oldParent;
        Element newParent;
        Element element;
        int oldIndex;
        int newIndex;
        String name;

        public UndoableMoveAction(Element oldParent, Element newParent, Element element) {
            this.oldParent = oldParent;
            this.newParent = newParent;
            this.element = element;
            this.oldIndex = SchemaDocument.this.indexOfElement(element);
            this.name = SchemaDocument.this.getSchemaController().getElementFriendlyName(XMLPath.getXMLPathForElement((Element)element));
            if (this.name == null) {
                this.name = element.getName();
            }
        }

        public void undo() {
            this.newIndex = SchemaDocument.this.indexOfElement(this.element);
            SchemaDocument.this.removeElement(null, this.element);
            SchemaDocument.this.addElementAtIndex(null, this.oldParent, this.element, this.oldIndex, true);
        }

        public void redo() {
            this.oldIndex = SchemaDocument.this.indexOfElement(this.element);
            SchemaDocument.this.removeElement(null, this.element);
            SchemaDocument.this.addElementAtIndex(null, this.newParent, this.element, this.newIndex, true);
        }

        public String getName() {
            return Messages.getString("uk.ac.reload.moonunit.SchemaDocument.6") + " " + this.name;
        }
    }

    protected class UndoablePasteAction
    extends UndoableAddAction {
        public UndoablePasteAction(Element parent, Element element) {
            super(parent, element);
        }

        public String getName() {
            return Messages.getString("uk.ac.reload.moonunit.SchemaDocument.5") + " " + this.name;
        }
    }

    protected class UndoableCopyAction
    extends UndoableAddAction {
        public UndoableCopyAction(Element parent, Element element) {
            super(parent, element);
        }

        public String getName() {
            return Messages.getString("uk.ac.reload.moonunit.SchemaDocument.4") + " " + this.name;
        }
    }

    protected class UndoableAddAction
    implements UndoableAction {
        Element parent;
        Element element;
        int index;
        String name;

        public UndoableAddAction(Element parent, Element element) {
            this.parent = parent;
            this.element = element;
            this.index = SchemaDocument.this.indexOfElement(element);
            this.name = SchemaDocument.this.getSchemaController().getElementFriendlyName(XMLPath.getXMLPathForElement((Element)element));
            if (this.name == null) {
                this.name = element.getName();
            }
        }

        public void undo() {
            this.index = SchemaDocument.this.indexOfElement(this.element);
            SchemaDocument.this.removeElement(null, this.element);
        }

        public void redo() {
            SchemaDocument.this.addElementAtIndex(null, this.parent, this.element, this.index, true);
        }

        public String getName() {
            return Messages.getString("uk.ac.reload.moonunit.SchemaDocument.3") + " " + this.name;
        }
    }

    protected class UndoableCutAction
    extends UndoableDeleteAction {
        public UndoableCutAction(Element parent, Element element) {
            super(parent, element);
        }

        public String getName() {
            return Messages.getString("uk.ac.reload.moonunit.SchemaDocument.2") + " " + this.name;
        }
    }

    protected class UndoableDeleteAction
    implements UndoableAction {
        Element parent;
        Element element;
        int index;
        String name;

        public UndoableDeleteAction(Element parent, Element element) {
            this.parent = parent;
            this.element = element;
            this.index = SchemaDocument.this.indexOfElement(element);
            this.name = SchemaDocument.this.getSchemaController().getElementFriendlyName(XMLPath.getXMLPathForElement((Element)element));
            if (this.name == null) {
                this.name = element.getName();
            }
        }

        public void undo() {
            SchemaDocument.this.addElementAtIndex(null, this.parent, this.element, this.index, true);
        }

        public void redo() {
            this.index = SchemaDocument.this.indexOfElement(this.element);
            SchemaDocument.this.removeElement(null, this.element);
        }

        public String getName() {
            return Messages.getString("uk.ac.reload.moonunit.SchemaDocument.1") + " " + this.name;
        }
    }
}

