/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import uk.ac.reload.moonunit.schema.SchemaElement;
import uk.ac.reload.moonunit.schema.SchemaException;

public class SchemaModel {
    private Schema _castorSchema;
    private SchemaElement _root;
    private String _rootName;
    private File _schemaFile;
    private static Hashtable _schemaTable = new Hashtable();

    public static SchemaModel getSchemaModel(String version, File fileSchema, String rootName) throws SchemaException, IOException {
        SchemaModel schema = (SchemaModel)_schemaTable.get(version);
        if (schema == null) {
            schema = new SchemaModel(fileSchema, rootName);
            _schemaTable.put(version, schema);
        }
        return schema;
    }

    public SchemaModel() {
    }

    public SchemaModel(File schemaFile, String rootName) throws IOException, SchemaException {
        this._castorSchema = this.loadSchema(schemaFile);
        this._schemaFile = schemaFile;
        this._rootName = rootName;
        ElementDecl rootElementDecl = this._castorSchema.getElementDecl(this._rootName);
        if (rootElementDecl == null) {
            throw new SchemaException("Root Element was null for rootname \"" + rootName + "\"");
        }
        this._root = new SchemaElement(rootElementDecl);
        this._root.setSchemaModel(this);
    }

    public void setSchemaFile(File file) {
        this._schemaFile = file;
    }

    public File getSchemaFile() {
        return this._schemaFile;
    }

    public SchemaElement getRootElement() {
        return this._root;
    }

    public void setRootElementName(String rootName) {
        this._rootName = rootName;
    }

    public String getRootElementName() {
        return this._rootName;
    }

    public Schema getSchema() {
        return this._castorSchema;
    }

    public void addImportedSchema(SchemaModel subSchemaModel, String nsPrefix) throws SchemaException {
        Schema attachedSchema;
        Schema parentSchema = this.getSchema();
        if (parentSchema.getImportedSchema((attachedSchema = subSchemaModel.getSchema()).getTargetNamespace()) == null) {
            try {
                parentSchema.addImportedSchema(attachedSchema);
                parentSchema.addNamespace(nsPrefix, attachedSchema.getTargetNamespace());
            }
            catch (org.exolab.castor.xml.schema.SchemaException ex) {
                ex.printStackTrace();
                throw new SchemaException(ex.getMessage());
            }
        }
    }

    public void attachSchemaElement(SchemaModel subSchemaModel, String complexTypeName, String elementName) throws SchemaException {
        Schema parentSchema = this.getSchema();
        Schema attachedSchema = subSchemaModel.getSchema();
        ComplexType orgsType = parentSchema.getComplexType(complexTypeName);
        Group group = (Group)orgsType.getParticle(0);
        ElementDecl ed = group.getElementDecl(elementName);
        if (ed != null) {
            return;
        }
        ed = new ElementDecl(attachedSchema, elementName);
        ed.setReference(ed);
        try {
            group.addElementDecl(ed);
        }
        catch (org.exolab.castor.xml.schema.SchemaException ex) {
            ex.printStackTrace();
            throw new SchemaException(ex.getMessage());
        }
    }

    public String getTargetNamespaceURI() {
        return this._castorSchema.getTargetNamespace();
    }

    public String getSchemaNamespaceURI() {
        return this._castorSchema.getSchemaNamespace();
    }

    public String getSchemaLocation(String namespaceURI) {
        Schema schema = this._castorSchema.getImportedSchema(namespaceURI);
        return schema == null ? null : schema.getSchemaLocation();
    }

    public String getSchemaName() {
        return this.getSchemaFile().getName();
    }

    public String getSchemaName(String namespaceURI) {
        String path = this.getSchemaLocation(namespaceURI);
        return path == null ? null : new File(path).getName();
    }

    public String getNamespaceURI(String prefix) {
        return this._castorSchema.getNamespace(prefix);
    }

    public String getVersion() {
        return this._castorSchema.getVersion();
    }

    protected Schema loadSchema(File schemaFile) throws IOException {
        String url = schemaFile.toURL().toString();
        SchemaReader reader = new SchemaReader(url);
        return reader.read();
    }
}

