/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.jdom.Namespace;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.schema.SchemaAttribute;
import uk.ac.reload.moonunit.schema.SchemaModel;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public class SchemaElement
extends SchemaNode {
    private ElementDecl _elementDecl;
    private SchemaElement[] _children;
    private SchemaAttribute[] _attributes;

    public SchemaElement(ElementDecl elementDecl) {
        this._elementDecl = elementDecl;
    }

    public SchemaElement setSchemaModel(SchemaModel schemaModel) {
        this.setParent(schemaModel);
        return this;
    }

    public String getName() {
        return this._elementDecl.getName();
    }

    public ElementDecl getElementDecl() {
        return this._elementDecl;
    }

    public String getNamespacePrefix() {
        String refname = this._elementDecl.getReferenceName();
        if (refname != null) {
            Schema thisSchema;
            int idx = refname.indexOf(58);
            if (idx >= 0) {
                String prefix = refname.substring(0, idx);
                return prefix;
            }
            Schema elementSchema = this._elementDecl.getSchema();
            if (elementSchema != (thisSchema = this.getSchemaModel().getSchema())) {
                return thisSchema.getNamespaces().getNamespacePrefix(elementSchema.getTargetNamespace());
            }
        }
        return "";
    }

    public Namespace getNamespace() {
        String nsPrefix = this.getNamespacePrefix();
        String nsURI = this.getSchemaModel().getSchema().getNamespace(nsPrefix);
        return Namespace.getNamespace((String)nsPrefix, (String)nsURI);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public XMLPath getXMLPath() {
        if (this.getParent() instanceof SchemaElement) {
            XMLPath xmlPath = ((SchemaElement)this.getParent()).getXMLPath();
            String name = this.getName();
            if (this.isExternalNamespace()) {
                name = this.getNamespacePrefix() + ":" + name;
            }
            xmlPath.appendElementName(name);
            return xmlPath;
        }
        return new XMLPath(this.getName());
    }

    public VocabularyList getVocabularyList() {
        VocabularyList rvList = null;
        XMLType xmlType = this.getXMLType();
        if (xmlType.isSimpleType()) {
            SimpleType simpleType = (SimpleType)xmlType;
            int type = simpleType.getTypeCode();
            switch (type) {
                case 11: {
                    rvList = VocabularyList.getTrueFalseList();
                    break;
                }
                default: {
                    Vector<String> v = null;
                    Enumeration e = simpleType.getFacets("enumeration");
                    while (e.hasMoreElements()) {
                        if (v == null) {
                            v = new Vector<String>();
                        }
                        Facet facet = (Facet)e.nextElement();
                        v.addElement(facet.getValue());
                    }
                    if (v == null) break;
                    Object[] s = new String[v.size()];
                    v.copyInto(s);
                    rvList = new VocabularyList("$schema$", (String[])s);
                }
            }
        }
        return rvList;
    }

    public String getTypeName() {
        return this.getXMLType().getName();
    }

    public String getBaseTypeName() {
        XMLType xmlType = this.getXMLType();
        XMLType baseType = xmlType.getBaseType();
        return baseType == null ? xmlType.getName() : baseType.getName();
    }

    public String getAtomicBaseTypeName() {
        String name = null;
        XMLType xmlType = this.getXMLType();
        if (xmlType != null) {
            for (XMLType baseType = xmlType.getBaseType(); baseType != null; baseType = baseType.getBaseType()) {
                name = baseType.getName();
            }
            return name == null ? xmlType.getName() : name;
        }
        return "Unknown BaseType";
    }

    public boolean isValue() {
        String baseTypeName = this.getAtomicBaseTypeName();
        if (baseTypeName == null) {
            return false;
        }
        return baseTypeName.equals("string") || baseTypeName.equals("int") || baseTypeName.equals("integer") || baseTypeName.equals("decimal");
    }

    public boolean isStringType() {
        String baseTypeName = this.getAtomicBaseTypeName();
        return baseTypeName != null && baseTypeName.equals("string");
    }

    public int getMinOccurs() {
        if (this.isChoiceElement()) {
            return 0;
        }
        return this._elementDecl.getMinOccurs();
    }

    public int getMaxOccurs() {
        if (this.isChoiceElement() && this.getOrderMaxOccurs() == -1) {
            return -1;
        }
        return this._elementDecl.getMaxOccurs();
    }

    public String getDefaultValue() {
        return this._elementDecl.getDefaultValue();
    }

    protected XMLType getXMLType() {
        return this._elementDecl.getType();
    }

    public boolean isComplexType() {
        return this.getXMLType().isComplexType();
    }

    public boolean isChoiceElement() {
        return "choice".equals(this.getOrderType());
    }

    public boolean isSequenceElement() {
        return "sequence".equals(this.getOrderType());
    }

    public String getOrderType() {
        Structure s = this._elementDecl.getParent();
        if (s instanceof Group) {
            Group g = (Group)s;
            return g.getOrder().toString();
        }
        return null;
    }

    public int getOrderMaxOccurs() {
        Structure s = this._elementDecl.getParent();
        if (s instanceof Group) {
            Group g = (Group)s;
            return g.getMaxOccurs();
        }
        return 0;
    }

    public int getOrderMinOccurs() {
        Structure s = this._elementDecl.getParent();
        if (s instanceof Group) {
            Group g = (Group)s;
            return g.getMinOccurs();
        }
        return 0;
    }

    public String getFacetValue(String facetName) {
        SimpleType simpleType;
        Facet facet;
        String val = null;
        XMLType xmlType = this.getXMLType();
        if (xmlType.isSimpleType() && (facet = (simpleType = (SimpleType)xmlType).getFacet(facetName)) != null) {
            val = facet.getValue();
        }
        return val;
    }

    public SchemaAttribute[] getSchemaAttributes() {
        if (this._attributes == null) {
            Vector v = new Vector();
            this.buildAttributes(v);
            this._attributes = new SchemaAttribute[v.size()];
            v.copyInto(this._attributes);
            Object var1_1 = null;
        }
        return this._attributes;
    }

    private void buildAttributes(Vector v) {
        XMLType xmlType = this.getXMLType();
        if (xmlType instanceof ComplexType) {
            Enumeration e = ((ComplexType)xmlType).getAttributeDecls();
            while (e.hasMoreElements()) {
                AttributeDecl attDecl = (AttributeDecl)e.nextElement();
                SchemaAttribute att = new SchemaAttribute(attDecl);
                att.setParent(this);
                v.add(att);
            }
        }
    }

    public SchemaAttribute getSchemaAttribute(String attName) {
        Namespace ns;
        int idx = attName.indexOf(58);
        if (idx >= 0) {
            String prefix = attName.substring(0, idx);
            attName = attName.substring(idx + 1);
            String nsURI = this._elementDecl.getSchema().getNamespace(prefix);
            ns = Namespace.getNamespace((String)prefix, (String)nsURI);
        } else {
            ns = Namespace.NO_NAMESPACE;
        }
        return this.getSchemaAttribute(attName, ns);
    }

    public SchemaAttribute getSchemaAttribute(String attName, Namespace ns) {
        SchemaAttribute[] atts = this.getSchemaAttributes();
        for (int i = 0; i < atts.length; ++i) {
            if (!atts[i].getName().equals(attName) || !atts[i].getNamespace().equals((Object)ns)) continue;
            return atts[i];
        }
        return null;
    }

    public SchemaAttribute getSchemaAttributeAtIndex(int index) {
        if (index >= this.getSchemaAttributes().length || index < 0) {
            return null;
        }
        return this.getSchemaAttributes()[index];
    }

    public boolean hasSchemaAttributes() {
        return this.getSchemaAttributes().length > 0;
    }

    public boolean hasSchemaAttribute(String attName) {
        if (this.hasSchemaAttributes()) {
            return this.indexofSchemaAttribute(attName, Namespace.NO_NAMESPACE) != -1;
        }
        return false;
    }

    public boolean hasSchemaAttribute(String attName, Namespace ns) {
        if (this.hasSchemaAttributes()) {
            return this.indexofSchemaAttribute(attName, ns) != -1;
        }
        return false;
    }

    public int indexofSchemaAttribute(SchemaAttribute att) {
        if (att == null) {
            return -1;
        }
        return this.indexofSchemaAttribute(att.getName(), att.getNamespace());
    }

    public int indexofSchemaAttribute(String attName) {
        return this.indexofSchemaAttribute(attName, Namespace.NO_NAMESPACE);
    }

    public int indexofSchemaAttribute(String attName, Namespace ns) {
        if (attName == null) {
            return -1;
        }
        SchemaAttribute[] atts = this.getSchemaAttributes();
        for (int i = 0; i < atts.length; ++i) {
            if (!atts[i].getName().equals(attName) || !atts[i].getNamespace().equals((Object)ns)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.getName();
    }

    public SchemaElement[] getChildren() {
        return this.buildChildren();
    }

    public SchemaElement[] getChildren(Namespace ns) {
        Vector<SchemaElement> v = new Vector<SchemaElement>();
        SchemaElement[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getNamespace() != ns) continue;
            v.add(children[i]);
        }
        Object[] elements = new SchemaElement[v.size()];
        v.copyInto(elements);
        v = null;
        return elements;
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    public boolean hasChild(String childName) {
        return this.getChild(childName) != null;
    }

    public SchemaElement getChild(String childName) {
        Object ns;
        int idx = childName.indexOf(58);
        if (idx >= 0) {
            String prefix = childName.substring(0, idx);
            childName = childName.substring(idx + 1);
            String nsURI = this._elementDecl.getSchema().getNamespace(prefix);
            ns = nsURI == null || "".equals(nsURI) ? null : Namespace.getNamespace((String)prefix, (String)nsURI);
        } else {
            ns = this.getNamespace();
        }
        return this.getChild(childName, (Namespace)ns);
    }

    public SchemaElement getChild(String childName, Namespace ns) {
        SchemaElement[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getName().equals(childName) || !children[i].getNamespace().equals((Object)ns)) continue;
            return children[i];
        }
        return null;
    }

    public SchemaElement getChildAt(int index) {
        if (index >= this.getChildCount() || index < 0) {
            return null;
        }
        return this.getChildren()[index];
    }

    public int indexofChild(SchemaElement child) {
        if (child == null) {
            return -1;
        }
        SchemaElement[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != child) continue;
            return i;
        }
        return -1;
    }

    public int indexofChild(String childName, Namespace ns) {
        if (childName == null) {
            return -1;
        }
        SchemaElement[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getName().equals(childName) || !children[i].getNamespace().equals((Object)ns)) continue;
            return i;
        }
        return -1;
    }

    public String[] getChildNames() {
        SchemaElement[] children = this.getChildren();
        String[] s = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            s[i] = children[i].getName();
        }
        return s;
    }

    protected SchemaElement[] buildChildren() {
        if (this._children == null) {
            Vector v = new Vector();
            XMLType xmlType = this.getXMLType();
            if (xmlType instanceof ComplexType) {
                ComplexType complexType = (ComplexType)xmlType;
                Enumeration cTypeBits = complexType.enumerate();
                block4: while (cTypeBits.hasMoreElements()) {
                    Structure structure = (Structure)cTypeBits.nextElement();
                    switch (structure.getStructureType()) {
                        case 10: {
                            this.buildChildGroup((Group)structure, v);
                            continue block4;
                        }
                        case 16: {
                            this.buildChildGroup((Group)((ModelGroup)structure), v);
                            continue block4;
                        }
                    }
                    System.out.println("Other ComplexType Structure: " + structure.toString());
                }
            }
            this._children = new SchemaElement[v.size()];
            v.copyInto(this._children);
            Object var1_1 = null;
        }
        return this._children;
    }

    private void buildChildGroup(Group group, Vector v) {
        Enumeration groupMembers = group.enumerate();
        block6: while (groupMembers.hasMoreElements()) {
            Particle particle = (Particle)groupMembers.nextElement();
            switch (particle.getStructureType()) {
                case 8: {
                    ElementDecl ed = (ElementDecl)particle;
                    this.addChildElementDecl(ed, v);
                    continue block6;
                }
                case 16: {
                    ModelGroup mg = (ModelGroup)particle;
                    this.buildChildGroup((Group)mg, v);
                    continue block6;
                }
                case 10: {
                    Group gp = (Group)particle;
                    this.buildChildGroup(gp, v);
                    continue block6;
                }
                case 24: {
                    continue block6;
                }
            }
            System.out.println("Group Particle: " + particle.toString());
        }
    }

    private void addChildElementDecl(ElementDecl childElementDecl, Vector v) {
        SchemaElement child = new SchemaElement(childElementDecl);
        child.setParent(this);
        v.add(child);
    }

    public boolean hasAncestor(SchemaElement schemaElement) {
        if (this.getParent() instanceof SchemaElement) {
            SchemaElement parent = (SchemaElement)this.getParent();
            return parent.getName().equals(schemaElement.getName()) && parent.getNamespace().equals((Object)schemaElement.getNamespace()) ? true : parent.hasAncestor(schemaElement);
        }
        return false;
    }

    public SchemaElement[] getSchemaElements() {
        Vector v = new Vector();
        this.__getSchemaElements(v);
        Object[] schemaElements = new SchemaElement[v.size()];
        v.copyInto(schemaElements);
        return schemaElements;
    }

    private void __getSchemaElements(Vector v) {
        v.add(0, this);
        if (this.getParent() instanceof SchemaElement) {
            ((SchemaElement)this.getParent()).__getSchemaElements(v);
        }
    }
}

