/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.moonunit.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.jdom.Attribute;
import org.jdom.Namespace;
import uk.ac.reload.jdom.XMLPath;
import uk.ac.reload.moonunit.schema.SchemaNode;
import uk.ac.reload.moonunit.vocab.VocabularyList;

public class SchemaAttribute
extends SchemaNode {
    private AttributeDecl _attDecl;

    public SchemaAttribute(AttributeDecl attDecl) {
        this._attDecl = attDecl;
    }

    public String getName() {
        return this._attDecl.getName();
    }

    public AttributeDecl getAttributeDecl() {
        return this._attDecl;
    }

    public String getUse() {
        return this._attDecl.getUse();
    }

    public String getDefaultValue() {
        return this._attDecl.getDefaultValue();
    }

    public String getNamespacePrefix() {
        int idx;
        String refname = this._attDecl.getReferenceName();
        if (refname != null && (idx = refname.indexOf(58)) >= 0) {
            String prefix = refname.substring(0, idx);
            if (prefix.equals("x")) {
                prefix = "xml";
            }
            return prefix;
        }
        return "";
    }

    public Namespace getNamespace() {
        String nsPrefix = this.getNamespacePrefix();
        if ("".equals(nsPrefix)) {
            return Namespace.NO_NAMESPACE;
        }
        if (nsPrefix.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        String namespaceURI = this._attDecl.getSchema().getNamespace(nsPrefix);
        return Namespace.getNamespace((String)nsPrefix, (String)namespaceURI);
    }

    public VocabularyList getVocabularyList() {
        VocabularyList rvList = null;
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null) {
            int type = simpleType.getTypeCode();
            switch (type) {
                case 11: {
                    rvList = VocabularyList.getTrueFalseList();
                    break;
                }
                default: {
                    Vector<String> v = null;
                    Enumeration e = simpleType.getFacets("enumeration");
                    while (e.hasMoreElements()) {
                        if (v == null) {
                            v = new Vector<String>();
                        }
                        Facet facet = (Facet)e.nextElement();
                        v.addElement(facet.getValue());
                    }
                    if (v == null) break;
                    Object[] s = new String[v.size()];
                    v.copyInto(s);
                    rvList = new VocabularyList("$schema$", (String[])s);
                }
            }
        }
        return rvList;
    }

    public String getTypeName() {
        SimpleType simpleType = this._attDecl.getSimpleType();
        return simpleType == null ? "Not known" : simpleType.getName();
    }

    public Long getMaxLength() {
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null) {
            return simpleType.getMaxLength();
        }
        return null;
    }

    public Long getMinLength() {
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null) {
            return simpleType.getMinLength();
        }
        return null;
    }

    public String getBaseTypeName() {
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null) {
            XMLType baseType = simpleType.getBaseType();
            return baseType == null ? simpleType.getName() : baseType.getName();
        }
        return "Unknown BaseType";
    }

    public String getAtomicBaseTypeName() {
        String name = null;
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null) {
            for (XMLType baseType = simpleType.getBaseType(); baseType != null; baseType = baseType.getBaseType()) {
                name = baseType.getName();
            }
            return name == null ? simpleType.getName() : name;
        }
        return "Unknown BaseType";
    }

    public String getFacetValue(String facetName) {
        Facet facet;
        String val = null;
        SimpleType simpleType = this._attDecl.getSimpleType();
        if (simpleType != null && (facet = simpleType.getFacet(facetName)) != null) {
            val = facet.getValue();
        }
        return val;
    }

    public Attribute createAttribute() {
        Attribute att = null;
        String name = this.getName();
        if (this.isExternalNamespace()) {
            Namespace ns = this.getNamespace();
            att = new Attribute(name, "", ns);
        } else {
            att = new Attribute(name, "");
        }
        return att;
    }

    public XMLPath getXMLPath() {
        XMLPath xmlPath = this.getParent().getXMLPath();
        Attribute att = this.createAttribute();
        xmlPath.appendAttributeName(att.getQualifiedName());
        return xmlPath;
    }
}

