/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.scorm.xml;

import java.io.File;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import uk.ac.reload.editor.EditorHandler;
import uk.ac.reload.editor.contentpackaging.CP_EditorHandler;
import uk.ac.reload.editor.contentpackaging.xml.CP_SchemaController;
import uk.ac.reload.editor.contentpackaging.xml.ContentPackage;
import uk.ac.reload.editor.metadata.xml.MD_SchemaController;
import uk.ac.reload.editor.properties.EditorProperties;
import uk.ac.reload.editor.scorm.xml.SCORM12_SchemaController;
import uk.ac.reload.jdom.XMLUtils;
import uk.ac.reload.moonunit.SchemaController;
import uk.ac.reload.moonunit.schema.SchemaException;
import uk.ac.reload.moonunit.schema.SchemaModel;

public class SCORM12_Package
extends ContentPackage {
    static final String[] scorm_comments = new String[]{"This is a Reload version " + EditorProperties.getString("VERSION") + " SCORM 1.2 Content Package document", "Spawned from the Reload Content Package Generator - http://www.reload.ac.uk"};

    public SCORM12_Package() {
    }

    public SCORM12_Package(File projectFolder, SCORM12_SchemaController scormController, MD_SchemaController mdController) throws IOException {
        this.setSchemaController((SchemaController)scormController);
        scormController.setMD_SchemaController(mdController);
        this.init(projectFolder, scormController);
        this.saveDocument();
        this.setDirty(false);
        scormController.copySchemaFilesToFolder(projectFolder);
    }

    public SCORM12_Package(File file) throws JDOMException, SchemaException, IOException {
        String version;
        this.setFile(file);
        this.setDocument(XMLUtils.readXMLFile((File)file));
        Namespace nameSpace = XMLUtils.getDocumentNamespace((Document)this.getDocument());
        String versionSCORM = EditorHandler.SCORM12_EDITORHANDLER.getVersion(nameSpace);
        SCORM12_SchemaController scormController = (SCORM12_SchemaController)EditorHandler.SCORM12_EDITORHANDLER.getSchemaControllerInstance(versionSCORM);
        this.setSchemaController((SchemaController)scormController);
        Namespace nsMD = this.getDocument().getRootElement().getNamespace("imsmd");
        if (nsMD != null && (version = EditorHandler.MD_EDITORHANDLER.getVersion(nsMD)) != null) {
            MD_SchemaController mdController = (MD_SchemaController)EditorHandler.MD_EDITORHANDLER.getSchemaControllerInstance(version);
            scormController.setMD_SchemaController(mdController);
        }
    }

    protected void init(File projectFolder, CP_SchemaController cpController) {
        super.init(projectFolder, cpController);
        Element root = this.getDocument().getRootElement();
        SchemaModel cpSchema = cpController.getSchemaModel();
        root.addNamespaceDeclaration(CP_EditorHandler.ADLCP_NAMESPACE_12);
        Attribute att = root.getAttribute(XMLUtils.XSI_SchemaLocation, XMLUtils.XSI_Namespace);
        if (att != null) {
            String value = att.getValue();
            if (value == null) {
                value = "";
            }
            StringBuffer schemaLocationURI = new StringBuffer(value);
            schemaLocationURI.append(" ");
            schemaLocationURI.append(CP_EditorHandler.ADLCP_NAMESPACE_12.getURI());
            schemaLocationURI.append(" ");
            schemaLocationURI.append(cpSchema.getSchemaName(CP_EditorHandler.ADLCP_NAMESPACE_12.getURI()));
            att.setValue(schemaLocationURI.toString());
        }
    }

    public String[] getComments() {
        return scorm_comments;
    }
}

