/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.shared;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.ComponentHiderLabelPanel;
import uk.ac.reload.dweezil.gui.ErrorDialogBox;
import uk.ac.reload.dweezil.gui.LabelComponentPanel;
import uk.ac.reload.dweezil.gui.layout.SGLayout;
import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.IIcons;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.gui.widgets.DataElementTextField;
import uk.ac.reload.editor.learningdesign.datamodel.MetadataType;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;
import uk.ac.reload.editor.metadata.editor.MD_EditorDialog;
import uk.ac.reload.editor.properties.EditorProperties;

public class MetadataPanel
extends JPanel
implements IIcons {
    private MetadataType _mdType;
    private DataElementTextField _tfSchema;
    private DataElementTextField _tfSchemaVersion;
    private MenuAction _mdAction;
    private ComponentHiderLabelPanel _hiderPanel;

    public MetadataPanel() {
        this.setupView();
    }

    public void setMetadataType(MetadataType mdType) {
        this._mdType = mdType;
        this._tfSchema.setElement(mdType.getSchemaDataElement());
        this._tfSchemaVersion.setElement(mdType.getSchemaVersionDataElement());
        this._hiderPanel.getTitleLabel().setText(mdType.getTitle());
        this._hiderPanel.getDescriptionLabel().setText(mdType.getDescription());
    }

    protected void setupView() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(10, 10));
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.setBackground(new Color(250, 254, 250));
        subPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.add((Component)subPanel, "Center");
        this._hiderPanel = new ComponentHiderLabelPanel("", "");
        this._hiderPanel.getComponentHiderButton().setComponent((JComponent)subPanel);
        this._hiderPanel.getComponentHiderButton().showComponent(false);
        this.add((Component)this._hiderPanel, "North");
        SGLayout fieldPanelLayout = new SGLayout(1, 2, 5, 5);
        JPanel fieldPanel = new JPanel((LayoutManager)fieldPanelLayout);
        fieldPanel.setOpaque(false);
        subPanel.add((Component)fieldPanel, "Center");
        this._tfSchema = new DataElementTextField();
        LabelComponentPanel panelSchema = new LabelComponentPanel("Schema:", (JComponent)this._tfSchema, 0.3, 0.0);
        fieldPanel.add((Component)panelSchema);
        this._tfSchemaVersion = new DataElementTextField();
        LabelComponentPanel panelSchemaVersion = new LabelComponentPanel("Version:", (JComponent)this._tfSchemaVersion, 0.3, 0.0);
        fieldPanel.add((Component)panelSchemaVersion);
        this._mdAction = new MetadataAction();
        JPanel mdPanel = new JPanel(new FlowLayout(0, 0, 2));
        mdPanel.setOpaque(false);
        subPanel.add((Component)mdPanel, "South");
        mdPanel.add(this._mdAction.getButton());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void editMetadata() {
        if (this._mdType == null) {
            return;
        }
        MD_EditorDialog mdDialog = null;
        try {
            this._mdAction.setEnabled(false);
            this.setCursor(DweezilUIManager.WAIT_CURSOR);
            LearningDesign ld = this._mdType.getLD_DataModel().getLearningDesign();
            DataElement mdDataElement = this._mdType.getMetadataDataElement();
            Element mdElement = mdDataElement.createElement();
            mdDialog = new MD_EditorDialog(ld, mdElement);
            mdDialog.show();
            this._mdAction.setEnabled(true);
        }
        catch (Exception ex) {
            if (EditorProperties.getString("DEBUG").equals("true")) {
                ex.printStackTrace();
            }
            if (mdDialog != null) {
                mdDialog.dispose();
            }
            ErrorDialogBox.showWarning((String)Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.0"), (String)Messages.getString("uk.ac.reload.editor.contentpackaging.manifestview.ManifestTree.1"), (Exception)ex);
        }
        finally {
            this.setCursor(DweezilUIManager.DEFAULT_CURSOR);
        }
    }

    public void cleanup() {
        this._mdType = null;
    }

    class MetadataAction
    extends MenuAction {
        MetadataAction() {
            super("Edit Metadata");
            this.setButtonText("Edit");
        }

        public void actionPerformed(ActionEvent e) {
            MetadataPanel.this.editMetadata();
        }
    }
}

