/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.method;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.learningdesign.datamodel.method.Play;
import uk.ac.reload.editor.learningdesign.editor.shared.CompletionPanel;

public class PlayCompletionPanel
extends CompletionPanel {
    static final String TITLE = "Play Completion";
    static final String DESCRIPTION = "Information relating to the completion of this Play.";
    private static String[] radioText = new String[]{"None", "Time Limit", "When Last Act Completed", "When a property is set"};

    protected PlayCompletionPanel(boolean isVisible) {
        super(isVisible);
        this.getHiderLabelPanel().getTitleLabel().setText("<html>Play Completion");
        this.getHiderLabelPanel().getDescriptionLabel().setText("<html>Information relating to the completion of this Play.");
    }

    public void setComponent(DataComponent dataComponent) {
        super.setComponent(dataComponent);
        Play play = (Play)dataComponent;
        this.getCompletionFeedbackPanel().setItemModelType(play.getFeedbackDescriptionItemModelType());
        DataElement whenActCompleted = play.getWhenLastActCompletedDataElement();
        DataElement timeLimit = play.getTimeLimitDataElement();
        DataElement propertyValue = play.getWhenPropertyValueSetDataElement();
        if (timeLimit.getElement() != null) {
            this.selectRadioButton(1);
            this.getTimeLimitField().setElement(timeLimit);
        } else if (whenActCompleted.getElement() != null) {
            this.selectRadioButton(2);
            this.getTimeLimitField().clear();
        } else if (propertyValue.getElement() != null) {
            this.selectRadioButton(3);
            this.getTimeLimitField().clear();
        } else {
            this.selectRadioButton(0);
            this.getTimeLimitField().clear();
        }
    }

    protected void radioButtonPressed(int button) {
        Play play = (Play)this.getComponent();
        DataElement completePlay = play.getCompletePlayDataElement();
        completePlay.deleteElement();
        switch (button) {
            case 0: {
                this.getTimeLimitField().clear();
                break;
            }
            case 1: {
                DataElement timeLimit = play.getTimeLimitDataElement();
                this.getTimeLimitField().setElement(timeLimit);
                break;
            }
            case 2: {
                DataElement whenActCompleted = play.getWhenLastActCompletedDataElement();
                whenActCompleted.createElement();
                this.getTimeLimitField().clear();
                break;
            }
            case 3: {
                DataElement propertyValue = play.getWhenPropertyValueSetDataElement();
                this.getTimeLimitField().clear();
            }
        }
    }

    protected void setupView(boolean isHidden) {
        super.setupView(isHidden);
        this.getRadioButtons()[3].setEnabled(false);
        JButton button = new JButton("Define");
        button.setEnabled(false);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBackground(new Color(250, 250, 254));
        buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.getCenterPanel().add((Component)buttonPanel, "Center");
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.anchor = 17;
        gc.fill = 1;
        buttonPanel.add((Component)this.getRadioButtons()[0], gc);
        gc.gridy = 1;
        buttonPanel.add((Component)this.getRadioButtons()[1], gc);
        gc.gridx = 1;
        gc.weightx = 2.0;
        buttonPanel.add((Component)this.getTimeLimitField(), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 1.0;
        buttonPanel.add((Component)this.getRadioButtons()[2], gc);
        gc.gridy = 3;
        gc.insets.top = 5;
        buttonPanel.add((Component)this.getRadioButtons()[3], gc);
        gc.gridx = 1;
        gc.fill = 0;
        buttonPanel.add((Component)button, gc);
    }

    protected int getNumberRadioButtons() {
        return radioText.length;
    }

    protected String getRadioButtonText(int button) {
        return radioText[button];
    }
}

