/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.editor.environment;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.GradientPanel;
import uk.ac.reload.dweezil.gui.tree.DweezilTreeNode;
import uk.ac.reload.editor.gui.GroupingPanel;
import uk.ac.reload.editor.learningdesign.datamodel.ILD_DataModelHandler;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_ComponentRef;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Conference;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.IndexSearch;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.LearningObject;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.SendMail;
import uk.ac.reload.editor.learningdesign.editor.environment.ConferenceEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.environment.EnvironmentEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.environment.EnvironmentTreePanel;
import uk.ac.reload.editor.learningdesign.editor.environment.IndexSearchEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.environment.LearningObjectEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.environment.MonitorEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.environment.SendMailEditorPanel;
import uk.ac.reload.editor.learningdesign.editor.shared.ReferencePanel;
import uk.ac.reload.jdom.XMLPath;

public class EnvironmentsPanel
extends GradientPanel
implements TreeSelectionListener,
ILD_DataModelHandler {
    public static XMLPath XMLPATH = new XMLPath("learning-design/components/environments");
    private LD_DataModel _ldDataModel;
    private JSplitPane _splitPane;
    private JPanel _cardPanel;
    private EnvironmentTreePanel _treePanel;
    private LearningObjectEditorPanel _learningobjectEditorPanel;
    private JScrollPane _learningobjectEditorPanelScrollPane;
    private EnvironmentEditorPanel _envEditorPanel;
    private JScrollPane _envEditorPanelScrollPane;
    private ConferenceEditorPanel _conferenceEditorPanel;
    private JScrollPane _conferenceEditorPanelScrollPane;
    private SendMailEditorPanel _sendmailEditorPanel;
    private JScrollPane _sendmailEditorPanelScrollPane;
    private IndexSearchEditorPanel _indexSearchEditorPanel;
    private JScrollPane _indexSearchEditorPanelScrollPane;
    private MonitorEditorPanel _monitorEditorPanel;
    private JScrollPane _monitorEditorPanelScrollPane;
    private ReferencePanel _referencePanel;
    private GroupingPanel _blankPanel;
    private LD_Component _currentSelectedLD_Component;

    public EnvironmentsPanel() {
        super((LayoutManager)new BorderLayout());
        JLabel label = new JLabel("Environments");
        label.setFont(label.getFont().deriveFont(1, 16.0f));
        this.add(label, "North");
        this._splitPane = new JSplitPane(1);
        this._splitPane.setOneTouchExpandable(true);
        this.add(this._splitPane, "Center");
        this._splitPane.setLeftComponent((Component)((Object)this.getEnvironmentTreePanel()));
        this._cardPanel = new JPanel(new CardLayout());
        this._splitPane.setRightComponent(this._cardPanel);
        this.getEnvironmentTreePanel().getTree().addTreeSelectionListener(this);
    }

    public void setDataModel(LD_DataModel ldDataModel) {
        this._ldDataModel = ldDataModel;
        this.getEnvironmentTreePanel().setDataModel(ldDataModel);
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object obj;
        if (!e.isAddedPath()) {
            return;
        }
        TreePath selPath = e.getPath();
        Object selectedNode = selPath.getLastPathComponent();
        if (selectedNode instanceof DweezilTreeNode && (obj = ((DweezilTreeNode)selectedNode).getUserObject()) instanceof LD_Component) {
            this.updateEditorPanel((LD_Component)obj);
        }
    }

    protected void updateEditorPanel(LD_Component ldComponent) {
        if (ldComponent == this._currentSelectedLD_Component) {
            return;
        }
        String panelName = null;
        if (ldComponent instanceof LD_ComponentRef) {
            panelName = "#REF_PANEL";
            if (this.getReferencePanel().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)((Object)this.getReferencePanel()), panelName);
            }
            this.getReferencePanel().setComponent(ldComponent);
        } else if (ldComponent instanceof LearningObject) {
            panelName = "#LO_PANEL";
            if (this.getLearningobjectEditorPanelScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getLearningobjectEditorPanelScrollPane(), panelName);
            }
            this.getLearningObjectEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof Environment) {
            panelName = "#ENV_PANEL";
            if (this.getEnvironmentEditorScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getEnvironmentEditorScrollPane(), panelName);
            }
            this.getEnvironmentEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof Conference) {
            panelName = "#CONF_PANEL";
            if (this.getConferenceEditorScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getConferenceEditorScrollPane(), panelName);
            }
            this.getConferenceEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof SendMail) {
            panelName = "#SENDMAIL_PANEL";
            if (this.getSendMailEditorScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getSendMailEditorScrollPane(), panelName);
            }
            this.getSendMailEditorPanel().setComponent(ldComponent);
        } else if (ldComponent instanceof IndexSearch) {
            panelName = "#INDEXSEARCH_PANEL";
            if (this.getIndexSearchEditorScrollPane().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)this.getIndexSearchEditorScrollPane(), panelName);
            }
            this.getIndexSearchEditorPanel().setComponent(ldComponent);
        } else {
            panelName = "#BLANK_PANEL";
            if (this.getBlankPanel().getParent() != this._cardPanel) {
                this._cardPanel.add((Component)((Object)this.getBlankPanel()), panelName);
            }
            this.getBlankPanel().setComponent(ldComponent);
        }
        if (panelName != null) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, panelName);
        }
        this._currentSelectedLD_Component = ldComponent;
    }

    protected void setupView() {
        super.setupView();
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        this.setBorder(border);
    }

    public void initView() {
        this._splitPane.setDividerLocation(0.33);
        this._treePanel.setSelected(true);
    }

    public void cleanup() {
        if (this._treePanel != null) {
            this._treePanel.cleanup();
        }
        if (this._learningobjectEditorPanel != null) {
            this._learningobjectEditorPanel.cleanup();
        }
        if (this._envEditorPanel != null) {
            this._envEditorPanel.cleanup();
        }
        if (this._conferenceEditorPanel != null) {
            this._conferenceEditorPanel.cleanup();
        }
        if (this._sendmailEditorPanel != null) {
            this._sendmailEditorPanel.cleanup();
        }
        if (this._indexSearchEditorPanel != null) {
            this._indexSearchEditorPanel.cleanup();
        }
        if (this._monitorEditorPanel != null) {
            this._monitorEditorPanel.cleanup();
        }
        if (this._referencePanel != null) {
            this._referencePanel.cleanup();
        }
        if (this._blankPanel != null) {
            this._blankPanel.cleanup();
        }
        this._ldDataModel = null;
    }

    public boolean doSave() {
        return true;
    }

    public JScrollPane getIndexSearchEditorScrollPane() {
        if (this._indexSearchEditorPanelScrollPane == null) {
            this._indexSearchEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getIndexSearchEditorPanel()));
            this._indexSearchEditorPanelScrollPane.setBorder(null);
        }
        return this._indexSearchEditorPanelScrollPane;
    }

    public IndexSearchEditorPanel getIndexSearchEditorPanel() {
        if (this._indexSearchEditorPanel == null) {
            this._indexSearchEditorPanel = new IndexSearchEditorPanel();
        }
        return this._indexSearchEditorPanel;
    }

    public JScrollPane getSendMailEditorScrollPane() {
        if (this._sendmailEditorPanelScrollPane == null) {
            this._sendmailEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getSendMailEditorPanel()));
            this._sendmailEditorPanelScrollPane.setBorder(null);
        }
        return this._sendmailEditorPanelScrollPane;
    }

    public SendMailEditorPanel getSendMailEditorPanel() {
        if (this._sendmailEditorPanel == null) {
            this._sendmailEditorPanel = new SendMailEditorPanel();
        }
        return this._sendmailEditorPanel;
    }

    public JScrollPane getMonitorEditorScrollPane() {
        if (this._monitorEditorPanelScrollPane == null) {
            this._monitorEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getMonitorEditorPanel()));
            this._monitorEditorPanelScrollPane.setBorder(null);
        }
        return this._monitorEditorPanelScrollPane;
    }

    public MonitorEditorPanel getMonitorEditorPanel() {
        if (this._monitorEditorPanel == null) {
            this._monitorEditorPanel = new MonitorEditorPanel();
        }
        return this._monitorEditorPanel;
    }

    public JScrollPane getConferenceEditorScrollPane() {
        if (this._conferenceEditorPanelScrollPane == null) {
            this._conferenceEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getConferenceEditorPanel()));
            this._conferenceEditorPanelScrollPane.setBorder(null);
        }
        return this._conferenceEditorPanelScrollPane;
    }

    public ConferenceEditorPanel getConferenceEditorPanel() {
        if (this._conferenceEditorPanel == null) {
            this._conferenceEditorPanel = new ConferenceEditorPanel();
        }
        return this._conferenceEditorPanel;
    }

    public JScrollPane getEnvironmentEditorScrollPane() {
        if (this._envEditorPanelScrollPane == null) {
            this._envEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getEnvironmentEditorPanel()));
            this._envEditorPanelScrollPane.setBorder(null);
        }
        return this._envEditorPanelScrollPane;
    }

    public EnvironmentEditorPanel getEnvironmentEditorPanel() {
        if (this._envEditorPanel == null) {
            this._envEditorPanel = new EnvironmentEditorPanel();
        }
        return this._envEditorPanel;
    }

    public JScrollPane getLearningobjectEditorPanelScrollPane() {
        if (this._learningobjectEditorPanelScrollPane == null) {
            this._learningobjectEditorPanelScrollPane = new JScrollPane((Component)((Object)this.getLearningObjectEditorPanel()));
            this._learningobjectEditorPanelScrollPane.setBorder(null);
        }
        return this._learningobjectEditorPanelScrollPane;
    }

    public LearningObjectEditorPanel getLearningObjectEditorPanel() {
        if (this._learningobjectEditorPanel == null) {
            this._learningobjectEditorPanel = new LearningObjectEditorPanel();
        }
        return this._learningobjectEditorPanel;
    }

    public EnvironmentTreePanel getEnvironmentTreePanel() {
        if (this._treePanel == null) {
            this._treePanel = new EnvironmentTreePanel();
        }
        return this._treePanel;
    }

    public ReferencePanel getReferencePanel() {
        if (this._referencePanel == null) {
            this._referencePanel = new ReferencePanel();
        }
        return this._referencePanel;
    }

    public GroupingPanel getBlankPanel() {
        if (this._blankPanel == null) {
            this._blankPanel = new GroupingPanel();
        }
        return this._blankPanel;
    }
}

