/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel.components.activities;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import org.jdom.Element;
import uk.ac.reload.dweezil.util.DweezilUIManager;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.learningdesign.datamodel.ItemModelType;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.LD_DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.MetadataType;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.Activity;
import uk.ac.reload.jdom.XMLPath;

public class ActivityStructure
extends Activity {
    public static XMLPath XMLPATH = new XMLPath(XMLPATH_ROOT_LD).appendElementName("components/activities/activity-structure");
    static final String DESCRIPTION = "This section provides information about the Activity Structure.";
    private ItemModelType _informationItemModelType;
    private MetadataType _mdType;
    private static final String INFORMATION_TITLE = "Information";
    private static final String INFORMATION_DESCRIPTION = "May be used to provide additional information about the Activity Structure.";

    protected ActivityStructure(LD_DataModel ldDataModel, Element element) {
        super(ldDataModel, element);
        this.setDescription(DESCRIPTION);
    }

    protected boolean ensureAllReferences() {
        boolean modified = super.ensureAllReferences();
        modified |= this.ensureReferences(this.getElement(), "learning-activity-ref", "ref", this.getLD_DataModel().getActivities_Grouping().getLearningActivity_Grouping());
        modified |= this.ensureReferences(this.getElement(), "support-activity-ref", "ref", this.getLD_DataModel().getActivities_Grouping().getSupportActivity_Grouping());
        return modified |= this.ensureReferences(this.getElement(), "activity-structure-ref", "ref", this.getLD_DataModel().getActivities_Grouping().getActivityStructure_Grouping());
    }

    public LD_Component[] getReferencedComponents() {
        Vector<LD_Component> v = new Vector<LD_Component>();
        Iterator it = this.getElement().getChildren().iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (!element.getNamespace().equals((Object)this.getElement().getNamespace())) continue;
            LD_Component component = null;
            String ref = element.getAttributeValue("ref");
            if (element.getName().equals("learning-activity-ref")) {
                component = this.getLD_DataModel().getActivities_Grouping().getLearningActivity_Grouping().getChildByIdentifer(ref);
            } else if (element.getName().equals("support-activity-ref")) {
                component = this.getLD_DataModel().getActivities_Grouping().getSupportActivity_Grouping().getChildByIdentifer(ref);
            } else if (element.getName().equals("activity-structure-ref")) {
                component = this.getLD_DataModel().getActivities_Grouping().getActivityStructure_Grouping().getChildByIdentifer(ref);
            }
            if (component == null) continue;
            v.add(component);
        }
        Object[] components = new LD_Component[v.size()];
        v.copyInto(components);
        return components;
    }

    public ItemModelType getInformationItemModelType() {
        if (this._informationItemModelType == null) {
            DataElement dataElement = new DataElement(this.getDataModel(), this.getElement(), new XMLPath("information"));
            this._informationItemModelType = new ItemModelType(dataElement, INFORMATION_TITLE, INFORMATION_DESCRIPTION);
        }
        return this._informationItemModelType;
    }

    public MetadataType getMetadataType() {
        if (this._mdType == null) {
            this._mdType = new MetadataType(this.getDataElement(), "Metadata", "Metadata for the Activity Structure.");
        }
        return this._mdType;
    }

    public String getDefaultTitle() {
        return "Activity Structure";
    }

    public XMLPath getXMLPath() {
        return XMLPATH;
    }

    public Icon getIcon() {
        return DweezilUIManager.getIcon((String)"uk/ac/reload/editor/resources/images/activity_structure.gif");
    }
}

