/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.learningdesign.datamodel;

import org.jdom.Element;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.DataElement;
import uk.ac.reload.editor.datamodel.DataModel;
import uk.ac.reload.editor.learningdesign.datamodel.ItemModelType;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Component;
import uk.ac.reload.editor.learningdesign.datamodel.MetadataType;
import uk.ac.reload.editor.learningdesign.datamodel.components.activities.Activities_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environment;
import uk.ac.reload.editor.learningdesign.datamodel.components.environments.Environments_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.components.roles.Roles_Grouping;
import uk.ac.reload.editor.learningdesign.datamodel.method.Method;
import uk.ac.reload.editor.learningdesign.datamodel.resources.LD_Resources;
import uk.ac.reload.editor.learningdesign.xml.LearningDesign;
import uk.ac.reload.jdom.XMLPath;

public class LD_DataModel
extends DataModel {
    static final String LO_TITLE = "Learning Objectives";
    static final String LO_DESCRIPTION = "This section describes the Learning Objectives of the Learning Design.";
    static final String PREREQ_TITLE = "Prerequisites";
    static final String PREREQ_DESCRIPTION = "This section describes the Prerequisites for the Learning Design.";
    private ItemModelType _learningObjectivesItemModelType;
    private ItemModelType _prerequisitesItemModelType;
    private Roles_Grouping _rolesGrouping;
    private Environments_Grouping _envsGrouping;
    private Activities_Grouping _activitiesGrouping;
    private Method _method;
    private LD_Resources _resources;
    private MetadataType _mdType;

    public LD_DataModel(LearningDesign ld) {
        super(ld);
    }

    public LearningDesign getLearningDesign() {
        return (LearningDesign)this.getSchemaDocument();
    }

    public ItemModelType getLearningObjectives() {
        if (this._learningObjectivesItemModelType == null) {
            Element rootElement = this.getLearningDesign().getLDElement();
            DataElement dataElement = new DataElement(this, rootElement, new XMLPath("learning-objectives"));
            this._learningObjectivesItemModelType = new ItemModelType(dataElement, LO_TITLE, LO_DESCRIPTION);
        }
        return this._learningObjectivesItemModelType;
    }

    public ItemModelType getPrerequisites() {
        if (this._prerequisitesItemModelType == null) {
            Element rootElement = this.getLearningDesign().getLDElement();
            DataElement dataElement = new DataElement(this, rootElement, new XMLPath("prerequisites"));
            this._prerequisitesItemModelType = new ItemModelType(dataElement, PREREQ_TITLE, PREREQ_DESCRIPTION);
        }
        return this._prerequisitesItemModelType;
    }

    public Roles_Grouping getRoles_Grouping() {
        if (this._rolesGrouping == null) {
            this._rolesGrouping = new Roles_Grouping(this);
        }
        return this._rolesGrouping;
    }

    public Environments_Grouping getEnvironment_Grouping() {
        if (this._envsGrouping == null) {
            this._envsGrouping = new Environments_Grouping(this);
        }
        return this._envsGrouping;
    }

    public Activities_Grouping getActivities_Grouping() {
        if (this._activitiesGrouping == null) {
            this._activitiesGrouping = new Activities_Grouping(this);
        }
        return this._activitiesGrouping;
    }

    public Method getMethod() {
        if (this._method == null) {
            this._method = new Method(this);
        }
        return this._method;
    }

    public LD_Resources getResources() {
        if (this._resources == null) {
            this._resources = new LD_Resources(this);
        }
        return this._resources;
    }

    public MetadataType getMetadataType() {
        if (this._mdType == null) {
            DataElement dataElement = new DataElement(this, this.getLearningDesign().getLDElement());
            this._mdType = new MetadataType(dataElement, "Metadata", "Metadata for the Learning Design");
        }
        return this._mdType;
    }

    public LD_Component getChildByIdentifer(String refid) {
        int i;
        LD_Component component = this.getActivities_Grouping().getLearningActivity_Grouping().getChildByIdentifer(refid);
        if (component != null) {
            return component;
        }
        component = this.getActivities_Grouping().getSupportActivity_Grouping().getChildByIdentifer(refid);
        if (component != null) {
            return component;
        }
        component = this.getActivities_Grouping().getActivityStructure_Grouping().getChildByIdentifer(refid);
        if (component != null) {
            return component;
        }
        component = this.getEnvironment_Grouping().getChildByIdentifer(refid);
        if (component != null) {
            return component;
        }
        DataComponent[] components = this.getEnvironment_Grouping().getChildren();
        for (i = 0; i < components.length; ++i) {
            component = ((Environment)components[i]).getLearningObject_Grouping().getChildByIdentifer(refid);
            if (component == null) continue;
            return component;
        }
        for (i = 0; i < components.length; ++i) {
            component = ((Environment)components[i]).getService_Grouping().getChildByIdentifer(refid);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    public void destroy() {
        super.destroy();
        this._learningObjectivesItemModelType = null;
        this._prerequisitesItemModelType = null;
        this._rolesGrouping = null;
        this._envsGrouping = null;
        this._activitiesGrouping = null;
        this._method = null;
        this._resources = null;
    }
}

