/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.gui;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import uk.ac.reload.editor.datamodel.DataComponent;
import uk.ac.reload.editor.datamodel.IDataComponentIcon;
import uk.ac.reload.editor.gui.Editor_TreeNode;
import uk.ac.reload.editor.learningdesign.datamodel.LD_Grouping;

public class Editor_TreeRenderer
extends DefaultTreeCellRenderer {
    Font _italicFont;
    Font _plainFont;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof DefaultMutableTreeNode) {
            Editor_TreeNode selNode = (Editor_TreeNode)((Object)value);
            DataComponent dc = (DataComponent)selNode.getUserObject();
            if (selNode.isHiLited) {
                selected = true;
            }
            if (dc instanceof IDataComponentIcon) {
                IDataComponentIcon iconType = (IDataComponentIcon)((Object)dc);
                Icon icon = iconType.getIcon();
                this.setLeafIcon(icon);
                this.setClosedIcon(icon);
                this.setOpenIcon(icon);
            }
            this.setToolTipText(dc.toString());
            this.setFont(dc);
        }
        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    protected void setFont(DataComponent dc) {
        if (dc instanceof LD_Grouping) {
            this.setFont(dc.hasChildren() ? this.getPlainFont() : this.getItalicFont());
        } else {
            this.setFont(this.getPlainFont());
        }
    }

    public Font getPlainFont() {
        if (this._plainFont == null) {
            this._plainFont = this.getFont();
        }
        return this._plainFont;
    }

    public Font getItalicFont() {
        if (this._italicFont == null && this.getPlainFont() != null) {
            this._italicFont = this.getPlainFont().deriveFont(2);
        }
        return this._italicFont;
    }
}

