/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.editor.contentpackaging.editor.resourceview;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import uk.ac.reload.diva.util.FileUtils;
import uk.ac.reload.dweezil.gui.DweezilProgressMonitor;
import uk.ac.reload.dweezil.gui.YesAllNoDialog;
import uk.ac.reload.editor.EditorFrame;
import uk.ac.reload.editor.Messages;
import uk.ac.reload.editor.contentpackaging.htmlparser.FileType;
import uk.ac.reload.editor.contentpackaging.htmlparser.HTMLParserImporter;

public class CP_ResourceImporter {
    private boolean _yesToAll;
    private boolean _cancelOperation;
    private boolean _hasImportedFiles;
    private DweezilProgressMonitor _progressMonitor;
    private boolean _hadBadLinks;

    public CP_ResourceImporter(File aFile, File destFolder, boolean obtainDependencies, DweezilProgressMonitor progressMonitor) throws IOException {
        this._progressMonitor = progressMonitor;
        this._yesToAll = false;
        this.importFile(aFile, destFolder, obtainDependencies);
        if (this._progressMonitor != null) {
            this._progressMonitor.close();
        }
        if (this._hadBadLinks) {
            this.showWarningMessage();
        }
    }

    public CP_ResourceImporter(File[] files, File destFolder, boolean obtainDependencies, DweezilProgressMonitor progressMonitor) throws IOException {
        this._progressMonitor = progressMonitor;
        this._yesToAll = false;
        for (int i = 0; i < files.length; ++i) {
            this.importFile(files[i], destFolder, obtainDependencies);
        }
        if (this._progressMonitor != null) {
            this._progressMonitor.close();
        }
        if (this._hadBadLinks) {
            this.showWarningMessage();
        }
    }

    public boolean hasImportedFiles() {
        return this._hasImportedFiles;
    }

    protected void importFile(File aFile, File destFolder, boolean obtainDependencies) throws IOException {
        if (aFile.isDirectory()) {
            this.importFolder(aFile, destFolder);
        } else if (obtainDependencies && FileType.isParseableFile(aFile)) {
            this.importHTMLFile(aFile, destFolder);
        } else {
            this.importSingleResource(aFile, destFolder);
        }
    }

    protected void importFolder(File theFolder, File destFolder) throws IOException {
        if (!theFolder.isDirectory()) {
            return;
        }
        if (theFolder.equals(destFolder)) {
            return;
        }
        File destinationFolder = new File(destFolder, theFolder.getName());
        if (!destinationFolder.exists()) {
            destinationFolder.mkdirs();
        }
        this.copyTheFilesAndFolders(theFolder.listFiles(), destinationFolder);
    }

    protected void copyTheFilesAndFolders(File[] allTheFiles, File destFolder) throws IOException {
        File file;
        int i;
        if (this.isCancelled()) {
            return;
        }
        for (i = 0; i < allTheFiles.length; ++i) {
            file = allTheFiles[i];
            if (!file.isDirectory()) continue;
            File destinationFolder = new File(destFolder, file.getName());
            if (!destinationFolder.exists()) {
                destinationFolder.mkdir();
            }
            this.copyTheFilesAndFolders(file.listFiles(), destinationFolder);
        }
        for (i = 0; i < allTheFiles.length; ++i) {
            file = allTheFiles[i];
            if (file.isDirectory()) continue;
            this.importSingleResource(file, destFolder);
        }
    }

    protected void importSingleResource(File originalFile, File destFolder) throws IOException {
        if (this.isCancelled()) {
            return;
        }
        File destinationFile = new File(destFolder, originalFile.getName());
        if (destinationFile.exists() && !this._yesToAll) {
            int answer = this.askUserOverwriteFile(destinationFile);
            if (answer == 1) {
                this._yesToAll = true;
            }
            if (answer == 0 || answer == 1) {
                FileUtils.copyFile((File)originalFile, (File)destinationFile);
                this._hasImportedFiles = true;
            } else if (answer == 3 || answer == -1) {
                this._cancelOperation = true;
            }
        } else {
            FileUtils.copyFile((File)originalFile, (File)destinationFile);
            this._hasImportedFiles = true;
        }
    }

    protected void importHTMLFile(File theFile, File destFolder) throws IOException {
        HTMLParserImporter htmlParser = new HTMLParserImporter(theFile, destFolder);
        if (htmlParser.isHigherLocalLinkFound() || htmlParser.isAbsoluteLocalLinkFound()) {
            this._hadBadLinks = true;
        }
        Hashtable allLinks = htmlParser.getLinks();
        Enumeration keys = allLinks.keys();
        while (keys.hasMoreElements()) {
            if (this.isCancelled()) {
                return;
            }
            File originalFile = (File)keys.nextElement();
            File destinationFile = (File)allLinks.get(originalFile);
            destinationFile.getParentFile().mkdirs();
            if (destinationFile.isDirectory()) continue;
            if (destinationFile.exists() && !this._yesToAll) {
                int answer = this.askUserOverwriteFile(destinationFile);
                if (answer == 1) {
                    this._yesToAll = true;
                }
                if (answer == 0 || answer == 1) {
                    FileUtils.copyFile((File)originalFile, (File)destinationFile);
                    this._hasImportedFiles = true;
                    continue;
                }
                if (answer != 3 && answer != -1) continue;
                this._cancelOperation = true;
                return;
            }
            FileUtils.copyFile((File)originalFile, (File)destinationFile);
            this._hasImportedFiles = true;
        }
    }

    protected int askUserOverwriteFile(File file) {
        YesAllNoDialog dialog = new YesAllNoDialog();
        String message = file.getName() + " " + Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourceImporter.0") + "\n" + Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourceImporter.1");
        return dialog.getUserResponse((JFrame)EditorFrame.getInstance(), message, Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourceImporter.2"));
    }

    protected boolean isCancelled() {
        boolean progressCancelled = false;
        if (this._progressMonitor != null) {
            progressCancelled = this._progressMonitor.isCanceled();
        }
        return this._cancelOperation || progressCancelled;
    }

    protected void showWarningMessage() {
        JOptionPane.showMessageDialog(EditorFrame.getInstance(), Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourceImporter.3"), Messages.getString("uk.ac.reload.editor.contentpackaging.resourceview.CP_ResourceImporter.5"), 2);
    }
}

